/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry.handlers;

import com.google.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecificationWithGenericMatcher;
import org.eclipse.viatra.query.runtime.extensibility.IQuerySpecificationProvider;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.index.IPatternBasedSpecificationProvider;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;

public abstract class ShowPatternLocationHandler
extends AbstractHandler {
    @Inject
    protected IURIEditorOpener uriOpener;

    protected void showPatternLocation(ExecutionEvent event, IQuerySpecificationProvider provider) throws ExecutionException {
        Class<?> specificationClass = ((IQuerySpecification)provider.get()).getClass();
        if (provider instanceof IQuerySpecificationRegistryEntry) {
            this.showPatternLocation(event, ((IQuerySpecificationRegistryEntry)provider).getProvider());
        } else if (provider instanceof IPatternBasedSpecificationProvider) {
            IPatternBasedSpecificationProvider patternBasedProvider = (IPatternBasedSpecificationProvider)provider;
            this.uriOpener.open(patternBasedProvider.getSpecificationSourceURI(), true);
        } else if (BaseGeneratedEMFQuerySpecification.class.isAssignableFrom(specificationClass) || BaseGeneratedEMFQuerySpecificationWithGenericMatcher.class.isAssignableFrom(specificationClass)) {
            String patternFqn = specificationClass.getName();
            SearchPattern searchPattern = SearchPattern.createPattern((String)patternFqn, (int)5, (int)0, (int)0);
            IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
            LocationSearchRequestor requestor = new LocationSearchRequestor();
            try {
                new SearchEngine().search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
                if (!requestor.opened) {
                    MessageDialog.openWarning((Shell)HandlerUtil.getActiveShellChecked((ExecutionEvent)event), (String)"Show Location", (String)String.format("Cannot open source pattern %s. Is contributing project %s indexed by JDT?", provider.getFullyQualifiedName(), provider.getSourceProjectName()));
                }
            }
            catch (CoreException e) {
                throw new ExecutionException("Error while opening editor", (Throwable)e);
            }
        }
    }

    protected static class LocationSearchRequestor
    extends SearchRequestor {
        private boolean opened = false;

        protected LocationSearchRequestor() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object element = match.getElement();
            if (!this.opened && element instanceof IJavaElement) {
                this.opened = true;
                JavaUI.openInEditor((IJavaElement)((IJavaElement)element));
            }
        }
    }
}

