/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.filter.xml;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.xml.TmfFilterContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TmfFilterXMLParser {
    private static ITmfFilterTreeNode fRoot = null;

    public TmfFilterXMLParser(String uri) throws SAXException, IOException {
        SAXParserFactory m_parserFactory = SAXParserFactory.newInstance();
        XMLReader saxReader = null;
        try {
            m_parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            m_parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            m_parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            m_parserFactory.setNamespaceAware(true);
            saxReader = m_parserFactory.newSAXParser().getXMLReader();
            saxReader.setContentHandler(new TmfFilterContentHandler());
            saxReader.parse(uri);
            fRoot = ((TmfFilterContentHandler)saxReader.getContentHandler()).getTree();
        }
        catch (ParserConfigurationException e) {
            Activator.logError("Error to parse the configuration ", e);
        }
    }

    public ITmfFilterTreeNode getTree() {
        return fRoot;
    }
}

