/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.preferences.wrappers.ColorPreferenceWrapper;
import org.eclipse.jwt.we.editors.preferences.wrappers.FontPreferenceWrapper;
import org.eclipse.jwt.we.misc.extensions.ExtensionsHelper;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralHelper {
    private static List<WEEditor> editorinstances = new ArrayList<WEEditor>();
    private static WEEditor initializingEditor;
    private static boolean jUnitMode;

    static {
        jUnitMode = false;
    }

    public static void setInitializingEditor(WEEditor initializingEditor) {
        GeneralHelper.initializingEditor = initializingEditor;
    }

    public static WEEditor getActiveInstance() {
        Plugin instance = Plugin.getInstance();
        if (initializingEditor != null) {
            return initializingEditor;
        }
        IWorkbenchWindow workbenchwindow = instance.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchwindow == null) {
            return null;
        }
        IWorkbenchPage activepage = workbenchwindow.getActivePage();
        if (activepage == null) {
            return null;
        }
        if (activepage.getActiveEditor() instanceof WEEditor) {
            return (WEEditor)activepage.getActiveEditor();
        }
        return null;
    }

    public static WEEditor getInstanceForEObject(EObject eobject) {
        if (eobject == null) {
            return null;
        }
        for (WEEditor ed : GeneralHelper.getEditors()) {
            if (!eobject.eResource().getResourceSet().equals(ed.getMainModelResource().getResourceSet())) continue;
            return ed;
        }
        return null;
    }

    public static Shell getActiveShell() {
        Plugin instance = Plugin.getInstance();
        IWorkbench iwb = instance.getWorkbench();
        if (iwb == null) {
            return null;
        }
        IWorkbenchWindow iwbw = iwb.getActiveWorkbenchWindow();
        if (iwbw == null) {
            return null;
        }
        Shell shell = iwbw.getShell();
        if (shell == null) {
            return null;
        }
        return shell;
    }

    public static boolean isPluginMode() {
        return Platform.getProduct() != null && (Platform.getProduct().getName() == null || !Platform.getProduct().getName().toLowerCase().contains("rcp") && !Platform.getProduct().getName().toLowerCase().contains("limo"));
    }

    public static boolean isjUnitMode() {
        return jUnitMode;
    }

    public static void setJUnitMode(boolean jUnitMode) {
        GeneralHelper.jUnitMode = jUnitMode;
    }

    public static void registerEditor(WEEditor ed) {
        editorinstances.add(ed);
    }

    public static void deregisterEditor(WEEditor ed) {
        editorinstances.remove((Object)ed);
        if (editorinstances.size() == 0) {
            Plugin.getDefault().getImageRegistry().dispose();
            FontPreferenceWrapper.disposeFonts();
            ColorPreferenceWrapper.disposeColors();
        }
    }

    public static List<WEEditor> getEditors() {
        return editorinstances;
    }

    public static String getWEVersion() {
        Bundle weBundle = Plugin.getInstance().getBundle();
        String version = (String)weBundle.getHeaders().get("Bundle-Version");
        String[] versionItems = version.split("\\.");
        if (versionItems.length > 3) {
            version = String.valueOf(versionItems[0]) + "." + versionItems[1] + "." + versionItems[2];
        }
        return version;
    }

    public static void switchToWEPerspective() {
        IConfigurationElement element = ExtensionsHelper.findConfigurationElement("org.eclipse.ui.newWizards", "org.eclipse.jwt.we.wizards.export.CreationWizard2");
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)element);
    }

    public static Class getObjectClass(Object modelObject) {
        if (modelObject instanceof EObject) {
            return ((EObject)modelObject).eClass().getInstanceClass();
        }
        if (modelObject instanceof EClass) {
            return ((EClass)modelObject).getInstanceClass();
        }
        if (modelObject instanceof Class) {
            return (Class)modelObject;
        }
        if (modelObject != null) {
            return modelObject.getClass();
        }
        return null;
    }
}

