/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.log;

import java.util.Date;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.log.AbstractLogEvent;
import org.eclipse.emf.diffmerge.ui.log.DiffMergeLogger;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeLabelProvider;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.edit.domain.EditingDomain;

public class CompareLogEvent
extends AbstractLogEvent {
    public CompareLogEvent(EditingDomain domain_p, EMFDiffNode node_p) {
        super(node_p);
    }

    public String getLeftLabel() {
        return this.getSideLabel(true);
    }

    public String getRightLabel() {
        return this.getSideLabel(false);
    }

    @Override
    public String getRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append(DiffMergeLogger.LINE_SEP);
        builder.append("*** Starting logging events on comparison - ");
        Date date = new Date();
        builder.append(date);
        builder.append(DiffMergeLogger.LINE_SEP);
        builder.append(Messages.ComparisonSetupWizardPage_RoleLeft);
        builder.append(this.getLeftLabel());
        builder.append(DiffMergeLogger.LINE_SEP);
        builder.append(Messages.ComparisonSetupWizardPage_RoleRight);
        builder.append(this.getRightLabel());
        builder.append(DiffMergeLogger.LINE_SEP);
        return builder.toString();
    }

    protected String getSideLabel(boolean left_p) {
        EMFDiffNode node = this.getDiffNode();
        Role sideRole = node.getRoleForSide(left_p);
        IEditableModelScope sideScope = node.getActualComparison().getScope(sideRole);
        return DiffMergeLabelProvider.getInstance().getText(sideScope);
    }
}

