/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.sirius;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.sirius.SiriusScope;
import org.eclipse.emf.diffmerge.ui.gmf.GMFScopeDefinitionFactory;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;

public class SiriusScopeDefinitionFactory
extends GMFScopeDefinitionFactory {
    protected IModelScopeDefinition createScopeDefinitionFromURI(URI uri_p, String label_p, boolean editable_p) {
        return new SiriusScopeDefinition(uri_p, label_p, editable_p);
    }

    public Collection<? extends Class<?>> getOverridenClasses() {
        return Collections.singleton(GMFScopeDefinitionFactory.class);
    }

    public static class SiriusScopeDefinition
    extends GMFScopeDefinitionFactory.GMFScopeDefinition {
        public SiriusScopeDefinition(URI uri_p, String label_p, boolean editable_p) {
            super(uri_p, label_p, editable_p);
        }

        protected IEditableModelScope createScopeOnEditingDomain(EditingDomain editingDomain) {
            return new SiriusScope(this.getEntrypoint(), editingDomain, !this.isEditable());
        }

        protected IEditableModelScope createScopeOnResourceSet(ResourceSet resourceSet_p) {
            return new SiriusScope(this.getEntrypoint(), resourceSet_p, !this.isEditable());
        }

        protected Object getDefaultContext() {
            URI uri = this.getEntrypoint();
            Session session = SessionManager.INSTANCE.getExistingSession(uri);
            Object result = session != null ? session.getTransactionalEditingDomain() : super.getDefaultContext();
            return result;
        }
    }
}

