/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.launch;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.eclipse.cdt.core.build.ErrorBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfiguration2;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.ICBuildConfigurationProvider;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.launchbar.core.ILaunchBarListener;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetListener;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.launchbar.core.target.TargetStatus;

public class CoreBuildLaunchBarTracker
implements ILaunchBarListener,
ILaunchTargetListener {
    private final ILaunchBarManager launchBarManager = CDebugCorePlugin.getService(ILaunchBarManager.class);
    private final ICBuildConfigurationManager configManager = CDebugCorePlugin.getService(ICBuildConfigurationManager.class);
    private final IToolChainManager toolChainManager = CDebugCorePlugin.getService(IToolChainManager.class);
    private final ILaunchTargetManager targetManager = CDebugCorePlugin.getService(ILaunchTargetManager.class);
    private ILaunchMode lastMode;
    private ILaunchDescriptor lastDescriptor;
    private ILaunchTarget lastTarget;

    public CoreBuildLaunchBarTracker() {
        this.targetManager.addListener((ILaunchTargetListener)this);
    }

    public void dispose() {
        this.targetManager.removeListener((ILaunchTargetListener)this);
    }

    private void setActiveBuildConfig(final ILaunchMode mode, ILaunchDescriptor descriptor, final ILaunchTarget target) throws CoreException {
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        if (project == null) {
            IResource[] mappedResources;
            ILaunchConfiguration configuration = this.launchBarManager.getLaunchConfiguration(descriptor, target);
            if (configuration == null) {
                return;
            }
            String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            if (!projectName.isEmpty()) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
            if (project == null && (mappedResources = configuration.getMappedResources()) != null && mappedResources.length > 0) {
                project = mappedResources[0].getProject();
            }
        }
        if (project == null || !this.configManager.supports(project)) {
            return;
        }
        final IProject finalProject = project;
        this.lastMode = mode;
        this.lastDescriptor = descriptor;
        this.lastTarget = target;
        Job job = new Job(InternalDebugCoreMessages.CoreBuildLaunchBarTracker_Job){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ICBuildConfiguration testConfig;
                    int n;
                    HashMap properties = new HashMap();
                    properties.putAll(CoreBuildLaunchBarTracker.this.lastTarget.getAttributes());
                    Collection tcs = CoreBuildLaunchBarTracker.this.toolChainManager.getToolChainsMatching(properties);
                    ICBuildConfiguration buildConfig = null;
                    if (!tcs.isEmpty()) {
                        IBuildConfiguration[] iBuildConfigurationArray = finalProject.getBuildConfigs();
                        n = iBuildConfigurationArray.length;
                        int n2 = 0;
                        block5: while (n2 < n) {
                            IBuildConfiguration config = iBuildConfigurationArray[n2];
                            if (!config.getName().equals("") && (testConfig = CoreBuildLaunchBarTracker.this.configManager.getBuildConfiguration(config)) != null && !(testConfig instanceof ErrorBuildConfiguration)) {
                                for (IToolChain tc : tcs) {
                                    if (!testConfig.getToolChain().equals(tc)) continue;
                                    buildConfig = testConfig;
                                    break block5;
                                }
                            }
                            ++n2;
                        }
                        if (buildConfig == null) {
                            for (IToolChain toolChain : tcs) {
                                buildConfig = CoreBuildLaunchBarTracker.this.configManager.getBuildConfiguration(finalProject, toolChain, mode.getIdentifier(), monitor);
                                if (buildConfig == null) {
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        ICBuildConfiguration config;
                        String error = String.format(InternalDebugCoreMessages.CoreBuildLaunchBarTracker_NoToolchainForTarget, target.getId());
                        if (!CoreBuildLaunchBarTracker.this.targetManager.getStatus(target).equals(TargetStatus.OK_STATUS)) {
                            error = String.valueOf(error) + '\n' + InternalDebugCoreMessages.CoreBuildLaunchBarTracker_TargetNotAvailable;
                        }
                        testConfig = finalProject.getBuildConfigs();
                        int n3 = ((IBuildConfiguration[])testConfig).length;
                        n = 0;
                        while (n < n3) {
                            ICBuildConfiguration testConfig2;
                            config = testConfig[n];
                            if (!config.getName().equals("") && (testConfig2 = CoreBuildLaunchBarTracker.this.configManager.getBuildConfiguration((IBuildConfiguration)config)) instanceof ErrorBuildConfiguration) {
                                ((ErrorBuildConfiguration)testConfig2).setErrorMessage(error);
                                buildConfig = testConfig2;
                                break;
                            }
                            ++n;
                        }
                        if (buildConfig == null) {
                            config = CoreBuildLaunchBarTracker.this.configManager.createBuildConfiguration((ICBuildConfigurationProvider)ErrorBuildConfiguration.PROVIDER, finalProject, "!", monitor);
                            buildConfig = new ErrorBuildConfiguration((IBuildConfiguration)config, error);
                            CoreBuildLaunchBarTracker.this.configManager.addBuildConfiguration((IBuildConfiguration)config, buildConfig);
                        }
                    }
                    if (buildConfig != null && !buildConfig.getBuildConfiguration().equals(finalProject.getActiveBuildConfig())) {
                        CoreModel m;
                        CoreModel coreModel = m = CoreModel.getDefault();
                        synchronized (coreModel) {
                            IProjectDescription desc = finalProject.getDescription();
                            IBuildConfiguration[] configs = finalProject.getBuildConfigs();
                            LinkedHashSet<String> names = new LinkedHashSet<String>();
                            IBuildConfiguration[] iBuildConfigurationArray = configs;
                            int n4 = configs.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                IBuildConfiguration config = iBuildConfigurationArray[n5];
                                names.add(config.getName());
                                ++n5;
                            }
                            names.add("");
                            names.remove(buildConfig.getBuildConfiguration().getName());
                            names.add(buildConfig.getBuildConfiguration().getName());
                            desc.setBuildConfigs(names.toArray(new String[0]));
                            desc.setActiveBuildConfig(buildConfig.getBuildConfiguration().getName());
                            finalProject.setDescription(desc, monitor);
                        }
                        ((ICBuildConfiguration2)buildConfig).setActive();
                    }
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        };
        job.setRule((ISchedulingRule)project.getWorkspace().getRoot());
        job.schedule();
    }

    public void activeLaunchTargetChanged(ILaunchTarget target) {
        try {
            if (target == null || target.equals(ILaunchTarget.NULL_TARGET) || target.equals(this.lastTarget)) {
                return;
            }
            ILaunchMode mode = this.launchBarManager.getActiveLaunchMode();
            if (mode == null) {
                return;
            }
            ILaunchDescriptor descriptor = this.launchBarManager.getActiveLaunchDescriptor();
            this.setActiveBuildConfig(mode, descriptor, target);
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e.getStatus());
        }
    }

    public void launchTargetStatusChanged(ILaunchTarget target) {
        try {
            if (this.targetManager.getStatus(target).equals(TargetStatus.OK_STATUS)) {
                ILaunchMode mode = this.launchBarManager.getActiveLaunchMode();
                if (mode == null) {
                    return;
                }
                ILaunchDescriptor descriptor = this.launchBarManager.getActiveLaunchDescriptor();
                this.setActiveBuildConfig(mode, descriptor, target);
            }
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e.getStatus());
        }
    }

    public void activeLaunchDescriptorChanged(ILaunchDescriptor descriptor) {
        try {
            if (descriptor == null || descriptor.equals(this.lastDescriptor)) {
                return;
            }
            ILaunchMode mode = this.launchBarManager.getActiveLaunchMode();
            if (mode == null) {
                return;
            }
            ILaunchTarget target = this.launchBarManager.getActiveLaunchTarget();
            this.setActiveBuildConfig(mode, descriptor, target);
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e.getStatus());
        }
    }

    public void activeLaunchModeChanged(ILaunchMode mode) {
        try {
            if (mode == null || mode.equals(this.lastMode)) {
                return;
            }
            ILaunchDescriptor descriptor = this.launchBarManager.getActiveLaunchDescriptor();
            ILaunchTarget target = this.launchBarManager.getActiveLaunchTarget();
            this.setActiveBuildConfig(mode, descriptor, target);
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e.getStatus());
        }
    }
}

