/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.ICollectionConditionalExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.AggregateExpression;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ComplexExpression;
import org.eclipse.birt.data.engine.expression.ExpressionCompiler;
import org.eclipse.birt.data.engine.expression.InvalidExpression;
import org.eclipse.birt.data.engine.expression.NamedExpression;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateRegistry;
import org.eclipse.birt.data.engine.impl.util.DirectedGraph;
import org.eclipse.birt.data.engine.impl.util.DirectedGraphEdge;
import org.eclipse.birt.data.engine.impl.util.GraphNode;

public class ExpressionCompilerUtil {
    public static CompiledExpression compile(String expr, ScriptContext cx) {
        ExpressionCompiler expressionCompiler = new ExpressionCompiler();
        expressionCompiler.setDataSetMode(true);
        return expressionCompiler.compile(expr, null, cx);
    }

    public static boolean hasColumnRow(String expression, ExprManager exprManager, ScriptContext cx) throws DataException {
        if (expression == null) {
            return false;
        }
        return ExpressionCompilerUtil.compile(expression, exprManager, cx);
    }

    public static List<String> extractDataSetColumnExpression(IBaseExpression expression) throws DataException {
        return ExpressionCompilerUtil.extractColumnExpression(expression, "dataSetRow");
    }

    public static List<String> extractColumnExpression(IBaseExpression expression, String indicator) throws DataException {
        return ExpressionCompilerUtil.extractColumnExpression(expression, new String[]{indicator});
    }

    public static List<String> extractColumnExpression(IBaseExpression expression, String[] indicators) throws DataException {
        if (expression == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> bindings = new LinkedHashSet<String>();
        ExpressionCompilerUtil.extractColumnExpression(bindings, expression, indicators);
        return new ArrayList<String>(bindings);
    }

    private static void extractColumnExpression(Set<String> existingBindings, IBaseExpression expression, String[] indicators) throws DataException {
        if (expression != null) {
            if (expression instanceof IScriptExpression) {
                ExpressionCompilerUtil.extractColumnExpression(existingBindings, (IScriptExpression)expression, indicators);
            } else if (expression instanceof IConditionalExpression) {
                ExpressionCompilerUtil.extractColumnExpression(existingBindings, (IConditionalExpression)expression, indicators);
            } else if (expression instanceof IExpressionCollection) {
                ExpressionCompilerUtil.extractColumnExpression(existingBindings, (IExpressionCollection)expression, indicators);
            } else if (expression instanceof ICollectionConditionalExpression) {
                ExpressionCompilerUtil.extractColumnExpression(existingBindings, (ICollectionConditionalExpression)((Object)expression), indicators);
            } else {
                throw new RuntimeException("unknown expresion type:" + expression);
            }
        }
    }

    private static void extractColumnExpression(Set<String> existingBindings, IScriptExpression expression, String[] indicators) throws DataException {
        if (expression != null) {
            ExpressionCompilerUtil.populateColumnList(existingBindings, expression, indicators);
        }
    }

    private static void extractColumnExpression(Set<String> existingBindings, IConditionalExpression expression, String[] indicators) throws DataException {
        if (expression != null) {
            ExpressionCompilerUtil.extractColumnExpression(existingBindings, expression.getExpression(), indicators);
            ExpressionCompilerUtil.extractColumnExpression(existingBindings, expression.getOperand1(), indicators);
            ExpressionCompilerUtil.extractColumnExpression(existingBindings, expression.getOperand2(), indicators);
        }
    }

    private static void extractColumnExpression(Set<String> existingBindings, IExpressionCollection expression, String[] indicators) throws DataException {
        if (expression != null) {
            Collection exprs = expression.getExpressions();
            for (IBaseExpression expr : exprs) {
                ExpressionCompilerUtil.extractColumnExpression(existingBindings, expr, indicators);
            }
        }
    }

    private static void extractColumnExpression(Set<String> existingBindings, ICollectionConditionalExpression expression, String[] indicators) throws DataException {
        if (expression != null) {
            Collection<IScriptExpression> exprs = expression.getExpr();
            for (IScriptExpression expr : exprs) {
                ExpressionCompilerUtil.extractColumnExpression(existingBindings, expr, indicators);
            }
        }
    }

    public static boolean hasAggregationInExpr(IBaseExpression expression) {
        if (expression == null || "constant".equals(expression.getScriptId())) {
            return false;
        }
        if (expression instanceof IScriptExpression) {
            String text = ((IScriptExpression)expression).getText();
            return ExpressionUtil.hasAggregation((String)text);
        }
        if (expression instanceof IConditionalExpression) {
            return ExpressionCompilerUtil.hasAggregationInExpr(((IConditionalExpression)expression).getExpression()) || ExpressionCompilerUtil.hasAggregationInExpr(((IConditionalExpression)expression).getOperand1()) || ExpressionCompilerUtil.hasAggregationInExpr(((IConditionalExpression)expression).getOperand2());
        }
        if (expression instanceof IExpressionCollection) {
            Object[] text = ((IExpressionCollection)expression).getExpressions().toArray();
            int i = 0;
            while (i < text.length) {
                if (ExpressionCompilerUtil.hasAggregationInExpr((IBaseExpression)text[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isValidExpressionInQueryFilter(IBaseExpression expression, ScriptContext context) throws DataException {
        if (expression instanceof IScriptExpression) {
            String text = ((IScriptExpression)expression).getText();
            if (text == null || text.trim().length() == 0 || "constant".equals(expression.getScriptId())) {
                return true;
            }
            AggregateRegistry aggrReg = new AggregateRegistry(){

                @Override
                public int register(AggregateExpression aggregationExpr) {
                    return -1;
                }
            };
            ExpressionCompiler expressionCompiler = new ExpressionCompiler();
            CompiledExpression expr = expressionCompiler.compile(text, aggrReg, context);
            return ExpressionCompilerUtil.flattenFilterExpression(expr);
        }
        if (expression instanceof IConditionalExpression) {
            IScriptExpression expr = ((IConditionalExpression)expression).getExpression();
            IBaseExpression oprand1 = ((IConditionalExpression)expression).getOperand1();
            IBaseExpression oprand2 = ((IConditionalExpression)expression).getOperand2();
            return ExpressionCompilerUtil.isValidExpressionInQueryFilter(expr, context) && ExpressionCompilerUtil.isValidExpressionInQueryFilter(oprand1, context) && ExpressionCompilerUtil.isValidExpressionInQueryFilter(oprand2, context);
        }
        return true;
    }

    private static boolean compile(String expression, ExprManager exprManager, ScriptContext cx) throws DataException {
        AggregateRegistry aggrReg = new AggregateRegistry(){

            @Override
            public int register(AggregateExpression aggregationExpr) {
                return -1;
            }
        };
        ExpressionCompiler expressionCompiler = new ExpressionCompiler();
        CompiledExpression expr = expressionCompiler.compile(expression, aggrReg, cx);
        return ExpressionCompilerUtil.flattenExpression(expr, exprManager, cx);
    }

    private static boolean flattenExpression(CompiledExpression expr, ExprManager exprManager, ScriptContext cx) throws DataException {
        int type = expr.getType();
        switch (type) {
            case 3: {
                Iterator col = ((ComplexExpression)expr).getSubExpressions().iterator();
                while (col.hasNext()) {
                    if (ExpressionCompilerUtil.flattenExpression((CompiledExpression)col.next(), exprManager, cx)) continue;
                    return false;
                }
                break;
            }
            case 1: {
                String columnName = ((ColumnReferenceExpression)expr).getColumnName();
                if ("__rownum".equals(columnName)) {
                    return true;
                }
                if (exprManager.getExpr(columnName) != null) {
                    String expression = ((IScriptExpression)exprManager.getExpr(columnName)).getText();
                    return ExpressionCompilerUtil.compile(expression, exprManager, cx);
                }
                return false;
            }
            case 2: {
                Iterator args = ((AggregateExpression)expr).getArguments().iterator();
                while (args.hasNext()) {
                    if (ExpressionCompilerUtil.flattenExpression((CompiledExpression)args.next(), exprManager, cx)) continue;
                    return false;
                }
                break;
            }
            case 4: 
            case 5: {
                return true;
            }
        }
        return true;
    }

    private static boolean flattenFilterExpression(CompiledExpression expr) throws DataException {
        int type = expr.getType();
        switch (type) {
            case 3: {
                Iterator col = ((ComplexExpression)expr).getSubExpressions().iterator();
                while (col.hasNext()) {
                    if (ExpressionCompilerUtil.flattenFilterExpression((CompiledExpression)col.next())) continue;
                    return false;
                }
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                int numberOfPasses = ((AggregateExpression)expr).getAggregation().getNumberOfPasses();
                if (numberOfPasses > 1) break;
                return false;
            }
            case 4: {
                break;
            }
            case 5: {
                throw (DataException)((Object)((InvalidExpression)expr).evaluate(null, null));
            }
        }
        return true;
    }

    private static void populateColumnList(Set<String> existingBindings, IScriptExpression expression, String[] indicators) throws DataException {
        if (expression != null) {
            if ("constant".equals(expression.getScriptId())) {
                return;
            }
            if ("javascript".equals(expression.getScriptId())) {
                try {
                    String[] stringArray = indicators;
                    int n = indicators.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String indicator = stringArray[n2];
                        List l = ExpressionUtil.extractColumnExpressions((String)expression.getText(), (String)indicator);
                        for (IColumnBinding cb : l) {
                            if (cb.getOuterLevel() != 0) continue;
                            existingBindings.add(cb.getResultSetColumnName());
                        }
                        ++n2;
                    }
                }
                catch (BirtException e) {
                    throw DataException.wrap(e);
                }
                return;
            }
            throw new RuntimeException("unsupported script type:" + expression.getScriptId());
        }
    }

    public static String getFirstFoundNameInCycle(Set<NamedExpression> namedExpressions, String indicator) {
        if (namedExpressions == null) {
            return null;
        }
        HashSet<DirectedGraphEdge> graphEdges = new HashSet<DirectedGraphEdge>();
        for (NamedExpression ne : namedExpressions) {
            List<String> referenceNames = null;
            try {
                referenceNames = ExpressionCompilerUtil.extractColumnExpression(ne.getExpression(), indicator);
            }
            catch (DataException dataException) {}
            if (referenceNames == null) continue;
            for (String reference : referenceNames) {
                graphEdges.add(new DirectedGraphEdge(new GraphNode(ne.getName()), new GraphNode(reference)));
            }
        }
        DirectedGraph graph = new DirectedGraph(graphEdges);
        String foundName = null;
        try {
            graph.validateCycle();
        }
        catch (DirectedGraph.CycleFoundException e) {
            foundName = (String)e.getNode().getValue();
        }
        return foundName;
    }
}

