/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.image.plugin;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.ImageInfo;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.ImageResource;

public final class FileImageResource
extends ImageResource {
    private final IFile m_resource;
    private final String m_symbolicName;
    private final String m_imagePath;
    private ImageInfo m_imageInfo;

    public FileImageResource(IFile resource, String symbolicName) {
        this.m_resource = resource;
        this.m_symbolicName = symbolicName;
        this.m_imagePath = this.m_resource.getProjectRelativePath().toOSString().replace('\\', '/');
    }

    public ImageInfo getImageInfo() {
        if (this.m_imageInfo == null) {
            Image image;
            try {
                InputStream inputStream = this.m_resource.getContents(true);
                try {
                    image = new Image((Device)Display.getCurrent(), inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Throwable e) {
                return null;
            }
            try {
                this.m_imageInfo = new ImageInfo("PLUGIN", (Object)new String[]{this.m_symbolicName, this.m_imagePath}, image, -1L);
            }
            catch (Throwable e) {
                this.m_imageInfo = null;
            }
        }
        return this.m_imageInfo;
    }

    public String getName() {
        return this.m_resource.getName();
    }

    public String getPath() {
        return this.m_imagePath;
    }

    public void dispose() {
        if (this.m_imageInfo != null) {
            this.m_imageInfo.getImage().dispose();
        }
    }
}

