/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.dialogfields;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.TitleAreaDialog;

public class StatusUtils {
    public static final IStatus OK_STATUS = new Status(0, "org.eclipse.wb.core", 0, "", null);
    public static final IStatus ERROR_STATUS = new Status(4, "org.eclipse.wb.core", 4, "", null);

    public static IStatus createError(String message) {
        return new Status(4, "org.eclipse.wb.core", 4, message, null);
    }

    public static IStatus getMoreSevere(IStatus s1, IStatus s2) {
        if (s1.getSeverity() > s2.getSeverity()) {
            return s1;
        }
        return s2;
    }

    public static IStatus getMostSevere(Collection<IStatus> statusCollection) {
        IStatus max = null;
        for (IStatus status : statusCollection) {
            if (status.matches(4)) {
                return status;
            }
            if (max != null && status.getSeverity() <= max.getSeverity()) continue;
            max = status;
        }
        return max;
    }

    public static void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }

    public static void applyToTitleAreaDialog(TitleAreaDialog dialog, IStatus status, String okMessage) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                dialog.setMessage(okMessage);
                dialog.setErrorMessage(null);
                break;
            }
            case 1: {
                dialog.setMessage(message, 1);
                dialog.setErrorMessage(null);
                break;
            }
            case 2: {
                dialog.setMessage(message, 2);
                dialog.setErrorMessage(null);
                break;
            }
            case 4: {
                if (message.length() == 0) {
                    message = null;
                }
                dialog.setMessage(null);
                dialog.setErrorMessage(message);
            }
        }
    }
}

