/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.SingleValueExtendOperationExecutor;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class IterateOverContainers
implements ISearchOperation {
    private final int sourcePosition;
    private final int containerPosition;
    private final boolean transitive;

    public IterateOverContainers(int containerPosition, int sourcePosition, boolean transitive) {
        this.containerPosition = containerPosition;
        this.sourcePosition = sourcePosition;
        this.transitive = transitive;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor(this.containerPosition);
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "extend    containment -" + variableMapping.apply(this.sourcePosition) + " <>--> +" + variableMapping.apply(this.containerPosition) + (this.transitive ? " transitively" : " directly");
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.containerPosition, this.sourcePosition);
    }

    private class Executor
    extends SingleValueExtendOperationExecutor<EObject> {
        public Executor(int position) {
            super(position);
        }

        @Override
        public Iterator<EObject> getIterator(MatchingFrame frame, ISearchContext context) {
            Preconditions.checkState((boolean)(frame.get(IterateOverContainers.this.sourcePosition) instanceof EObject), (String)"Only children of EObject elements are supported.");
            EObject source = (EObject)frame.get(IterateOverContainers.this.sourcePosition);
            EObject container = source.eContainer();
            if (container == null) {
                return Collections.emptyIterator();
            }
            if (IterateOverContainers.this.transitive) {
                return new ParentIterator(source);
            }
            return Collections.singleton(container).iterator();
        }

        @Override
        public ISearchOperation getOperation() {
            return IterateOverContainers.this;
        }
    }

    private static final class ParentIterator
    implements Iterator<EObject> {
        private EObject current;

        public ParentIterator(EObject source) {
            this.current = source;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EObject next() {
            EObject newObject = this.current.eContainer();
            if (newObject == null) {
                throw new NoSuchElementException(String.format("No more parents available for EObject %s", this.current));
            }
            this.current = newObject;
            return this.current;
        }

        @Override
        public boolean hasNext() {
            return this.current.eContainer() != null;
        }
    }
}

