/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class AutoSavePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button autoSaveButton;
    private Group autoSaveGroup;
    private Composite intervalComposite;
    private IntegerFieldEditor intervalField;
    private Label resetMessage;
    private Label noteLabel;
    private Label noteMessage;
    private IPropertyChangeListener validityChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                AutoSavePreferencePage.this.updateValidState();
            }
        }
    };

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent);
        this.createAutoSaveCheckbox(composite);
        this.createAutoSaveGroup(composite);
        this.createIntervalPart();
        this.createMessagesPart();
        this.updateEnablement();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void performDefaults() {
        boolean autoSave = this.getPreferenceStore().getDefaultBoolean("SAVE_AUTOMATICALLY");
        this.autoSaveButton.setSelection(autoSave);
        this.autoSaveButton.notifyListeners(13, new Event());
        int interval = this.getPreferenceStore().getDefaultInt("SAVE_AUTOMATICALLY_INTERVAL");
        this.intervalField.setStringValue(String.valueOf(interval));
        this.intervalField.setEnabled(autoSave, this.intervalComposite);
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.isValid()) {
            this.getPreferenceStore().setValue("SAVE_AUTOMATICALLY", this.autoSaveButton.getSelection());
            this.getPreferenceStore().setValue("SAVE_AUTOMATICALLY_INTERVAL", this.intervalField.getTextControl(this.intervalComposite).getText());
        }
        return super.performOk();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    public void dispose() {
        this.intervalField.setPropertyChangeListener(null);
        this.noteMessage.dispose();
        this.noteLabel.dispose();
        this.resetMessage.dispose();
        this.intervalField.dispose();
        this.intervalComposite.dispose();
        this.autoSaveGroup.dispose();
        this.autoSaveButton.dispose();
        super.dispose();
    }

    protected boolean isAutoSaveButtonSelected() {
        boolean enabled = this.autoSaveButton != null && !this.autoSaveButton.isDisposed() ? this.autoSaveButton.getSelection() : false;
        return enabled;
    }

    protected void selectAutoSaveButton(boolean enable) {
        if (this.autoSaveButton != null && !this.autoSaveButton.isDisposed()) {
            this.autoSaveButton.setSelection(enable);
            this.autoSaveButton.notifyListeners(13, new Event());
        }
    }

    protected int getAutoSaveIntervalTextValue() {
        int interval = this.intervalField != null && this.intervalComposite != null && !this.intervalField.getTextControl(this.intervalComposite).isDisposed() ? this.intervalField.getIntValue() : 0;
        return interval;
    }

    protected void setAutoSaveIntervalTextValue(int interval) {
        if (this.intervalField != null && this.intervalComposite != null && !this.intervalField.getTextControl(this.intervalComposite).isDisposed() && this.autoSaveButton != null && !this.autoSaveButton.isDisposed() && this.autoSaveButton.getSelection()) {
            this.intervalField.setStringValue(String.valueOf(interval));
        }
    }

    protected void updateValidState() {
        if (this.intervalField != null && !this.intervalField.isValid()) {
            this.setValid(false);
        } else {
            this.setValid(true);
        }
    }

    protected Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, false, false));
        return composite;
    }

    private void createAutoSaveCheckbox(Composite composite) {
        this.autoSaveButton = new Button(composite, 32);
        this.autoSaveButton.setText(IDEWorkbenchMessages.AutoSavePreferencPage_autoSaveButton);
        this.autoSaveButton.setToolTipText(IDEWorkbenchMessages.AutoSavePreferencPage_autoSaveButton);
        this.autoSaveButton.setSelection(this.getPreferenceStore().getBoolean("SAVE_AUTOMATICALLY"));
        this.autoSaveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AutoSavePreferencePage.this.updateEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void updateEnablement() {
        boolean autoSave = this.autoSaveButton.getSelection();
        Display display = this.autoSaveButton.getDisplay();
        this.noteMessage.setEnabled(autoSave);
        this.noteLabel.setEnabled(autoSave);
        this.resetMessage.setEnabled(autoSave);
        this.intervalField.getTextControl(this.intervalComposite).setEnabled(autoSave);
        this.intervalField.getLabelControl(this.intervalComposite).setEnabled(autoSave);
        this.intervalComposite.setEnabled(autoSave);
        this.autoSaveGroup.setEnabled(autoSave);
        if (autoSave) {
            this.noteMessage.setForeground(display.getSystemColor(21));
            this.noteLabel.setForeground(display.getSystemColor(21));
            this.resetMessage.setForeground(display.getSystemColor(21));
            this.intervalField.getLabelControl(this.intervalComposite).setForeground(display.getSystemColor(21));
        } else {
            this.noteMessage.setForeground(display.getSystemColor(33));
            this.noteLabel.setForeground(display.getSystemColor(33));
            this.resetMessage.setForeground(display.getSystemColor(33));
            this.intervalField.getLabelControl(this.intervalComposite).setForeground(display.getSystemColor(33));
        }
    }

    private void createAutoSaveGroup(Composite composite) {
        this.autoSaveGroup = new Group(composite, 0);
        GridLayout autoSaveGroupLayout = new GridLayout();
        autoSaveGroupLayout.numColumns = 1;
        autoSaveGroupLayout.marginWidth = 6;
        autoSaveGroupLayout.marginHeight = 2;
        this.autoSaveGroup.setLayout((Layout)autoSaveGroupLayout);
        GridData autoSaveGroupLayoutData = new GridData();
        autoSaveGroupLayoutData.horizontalAlignment = 4;
        autoSaveGroupLayoutData.grabExcessHorizontalSpace = true;
        this.autoSaveGroup.setLayoutData((Object)autoSaveGroupLayoutData);
        this.autoSaveGroup.setEnabled(this.autoSaveButton.getSelection());
    }

    private void createIntervalPart() {
        this.intervalComposite = new Composite((Composite)this.autoSaveGroup, 0);
        GridLayout intervalCompositeLayout = new GridLayout();
        intervalCompositeLayout.numColumns = 2;
        intervalCompositeLayout.marginWidth = 0;
        intervalCompositeLayout.marginHeight = 10;
        this.intervalComposite.setLayout((Layout)intervalCompositeLayout);
        this.intervalComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.intervalComposite.setEnabled(this.autoSaveButton.getSelection());
        this.intervalField = new IntegerFieldEditor("SAVE_AUTOMATICALLY_INTERVAL", "", this.intervalComposite);
        this.intervalField.setLabelText(IDEWorkbenchMessages.AutoSavePreferencPage_intervalMessage);
        this.intervalField.setPreferenceStore(WorkbenchPlugin.getDefault().getPreferenceStore());
        this.intervalField.setPage((DialogPage)this);
        this.intervalField.setTextLimit(10);
        this.intervalField.setErrorMessage(IDEWorkbenchMessages.AutoSavePreferencPage_errorMessage);
        this.intervalField.setValidateStrategy(0);
        this.intervalField.setValidRange(1, Integer.MAX_VALUE);
        this.intervalField.load();
        this.intervalField.getLabelControl(this.intervalComposite).setEnabled(this.autoSaveButton.getSelection());
        this.intervalField.getTextControl(this.intervalComposite).setEnabled(this.autoSaveButton.getSelection());
        this.intervalField.setPropertyChangeListener(this.validityChangeListener);
    }

    private void createMessagesPart() {
        this.resetMessage = new Label((Composite)this.autoSaveGroup, 64);
        this.resetMessage.setText(IDEWorkbenchMessages.AutoSavePreferencPage_resetMessage);
        GridData resetMessageLayoutData = new GridData(4, 4, true, false);
        resetMessageLayoutData.widthHint = 350;
        this.resetMessage.setLayoutData((Object)resetMessageLayoutData);
        Composite noteComposite = new Composite((Composite)this.autoSaveGroup, 0);
        GridLayout messageLayout = new GridLayout();
        messageLayout.numColumns = 2;
        messageLayout.marginWidth = 0;
        messageLayout.marginHeight = 0;
        noteComposite.setLayout((Layout)messageLayout);
        noteComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.noteLabel = new Label(noteComposite, 0);
        this.noteLabel.setText(IDEWorkbenchMessages.AutoSavePreferencPage_noteLabel);
        this.noteLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        this.noteLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.noteMessage = new Label(noteComposite, 64);
        this.noteMessage.setText(IDEWorkbenchMessages.AutoSavePreferencPage_noteMessage);
        GridData noteMessageData = new GridData(4, 4, true, false);
        noteMessageData.widthHint = 350;
        this.noteMessage.setLayoutData((Object)noteMessageData);
    }
}

