/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.FilteredCheckboxTree;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.IPreCheckStateListener;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class TriStateFilteredCheckboxTree
extends FilteredCheckboxTree {
    private Set<Object> fGrayedObjects = new HashSet<Object>();
    private List<IPreCheckStateListener> fPreCheckStateListeners = new ArrayList<IPreCheckStateListener>();

    public TriStateFilteredCheckboxTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook) {
        super(parent, treeStyle, filter, useNewLook);
    }

    @Override
    public void setCheckedElements(Object[] elements) {
        super.setCheckedElements(elements);
        this.maintainAllCheckIntegrity();
    }

    @Override
    public boolean setSubtreeChecked(Object element, boolean state) {
        HashSet<Object> prevChecked = new HashSet<Object>(Arrays.asList(this.getCheckedElements()));
        if (state) {
            prevChecked.remove(element);
        } else {
            prevChecked.add(element);
        }
        for (IPreCheckStateListener preCheckStateListener : this.fPreCheckStateListeners) {
            if (preCheckStateListener == null || !preCheckStateListener.setSubtreeChecked(element, state)) continue;
            this.setCheckedElements(prevChecked.toArray());
            return false;
        }
        this.checkSubtree(element, state);
        return this.getCheckboxTreeViewer().setSubtreeChecked(element, state);
    }

    @Override
    protected TreeViewer doCreateTreeViewer(Composite parentComposite, int style) {
        TreeViewer tree = super.doCreateTreeViewer(parentComposite, style);
        if (tree instanceof CheckboxTreeViewer) {
            CheckboxTreeViewer checkboxTree = (CheckboxTreeViewer)tree;
            checkboxTree.addCheckStateListener(event -> {
                boolean bl = this.setSubtreeChecked(event.getElement(), event.getChecked());
            });
        }
        return tree;
    }

    @Override
    protected WorkbenchJob doCreateRefreshJob() {
        WorkbenchJob job = super.doCreateRefreshJob();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (TriStateFilteredCheckboxTree.this.getCheckboxTreeViewer().getTree().isDisposed()) {
                    return;
                }
                TriStateFilteredCheckboxTree.this.maintainAllCheckIntegrity();
            }
        });
        return job;
    }

    @Override
    protected void checkSubtree(Object element, boolean state) {
        CheckboxTreeViewer checkboxTreeViewer = this.getCheckboxTreeViewer();
        if (checkboxTreeViewer.testFindItem(element) != null) {
            if (state) {
                this.fCheckedObjects.add(element);
            } else {
                this.fCheckedObjects.remove(element);
            }
        }
        boolean expanded = checkboxTreeViewer.getExpandedState(element);
        checkboxTreeViewer.setExpandedState(element, true);
        Object[] objectArray = ((ITreeContentProvider)checkboxTreeViewer.getContentProvider()).getChildren(element);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.checkSubtree(o, state);
            ++n2;
        }
        checkboxTreeViewer.setExpandedState(element, expanded);
        this.maintainAllCheckIntegrity();
    }

    private boolean getGrayed(Object element) {
        return this.fGrayedObjects.contains(element);
    }

    private boolean setGrayed(Object element, boolean state) {
        boolean checkable = this.getCheckboxTreeViewer().setGrayed(element, state);
        if (!state) {
            this.fGrayedObjects.remove(element);
        } else if (checkable) {
            this.fGrayedObjects.add(element);
        }
        return checkable;
    }

    private void maintainCheckIntegrity(Object element) {
        CheckboxTreeViewer checkboxTreeViewer = this.getCheckboxTreeViewer();
        ITreeContentProvider contentProvider = (ITreeContentProvider)checkboxTreeViewer.getContentProvider();
        boolean allChecked = true;
        boolean oneChecked = false;
        boolean oneGrayed = false;
        Object[] objectArray = contentProvider.getChildren(element);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (checkboxTreeViewer.testFindItem(child) != null) {
                boolean checked = this.getChecked(child);
                if ((oneGrayed |= checked && this.getGrayed(child)) || (oneChecked |= checked) && !(allChecked &= checked)) {
                    this.setGrayed(element, true);
                    this.setChecked(element, true);
                } else {
                    this.setGrayed(element, false);
                    this.setChecked(element, allChecked);
                }
            }
            ++n2;
        }
        Object parentElement = contentProvider.getParent(element);
        if (parentElement != null) {
            this.maintainCheckIntegrity(parentElement);
        }
    }

    private void maintainAllCheckIntegrity() {
        Object[] objectArray = this.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            this.maintainCheckIntegrity(checkedElement);
            ++n2;
        }
    }

    public void setFilterText(String string) {
        super.setFilterText(string);
    }

    public void addPreCheckStateListener(IPreCheckStateListener listener) {
        this.fPreCheckStateListeners.add(listener);
    }
}

