/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.EObjectCouple;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.query.ContainerMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.extensions.IContainerMappingExt;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.AbstractNodeMappingSpecOperations;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.SiriusElementMappingSpecOperations;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.spec.ContainerMappingSpec;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.DiagramElementMappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingWithInterpreterHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.StyleHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.style.ContainerStyleDescription;
import org.eclipse.sirius.diagram.description.tool.ContainerDropDescription;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;

public final class ContainerMappingWithInterpreterHelper {
    private IInterpreter interpreter;

    public ContainerMappingWithInterpreterHelper(IInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public static void clearDNodesDone(IContainerMappingExt self) {
        self.getViewContainerDone().clear();
        self.getCandidatesCache().clear();
    }

    public static EList<DDiagramElement> findDNodeFromEObject(IContainerMappingExt self, EObject object) {
        BasicEList result = self.getViewContainerDone().get(object);
        if (result == null) {
            result = new BasicEList();
        }
        return result;
    }

    public static void addDoneNode(IContainerMappingExt self, DSemanticDecorator node) {
        BasicEList list = self.getViewContainerDone().get(node.getTarget());
        if (list == null) {
            list = new BasicEList();
            self.getViewContainerDone().put(node.getTarget(), (EList<DSemanticDecorator>)list);
        }
        list.add((Object)node);
    }

    public static EList<EObject> getNodesCandidates(IContainerMappingExt self, EObject semanticOrigin, EObject container, EObject containerView) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.GET_CONTAINER_CANDIDATES_KEY);
        DDiagram diagram = null;
        if (containerView instanceof DDiagramElement) {
            diagram = ((DDiagramElement)containerView).getParentDiagram();
        } else if (containerView instanceof DDiagram) {
            diagram = (DDiagram)containerView;
        }
        EObject safeContainer = container == null ? semanticOrigin : container;
        EObjectCouple couple = new EObjectCouple(semanticOrigin, safeContainer, RefreshIdsHolder.getOrCreateHolder((EObject)diagram));
        UniqueEList result = self.getCandidatesCache().get(couple);
        if (result == null) {
            result = new UniqueEList();
            Iterator<EObject> it = DiagramElementMappingHelper.getSemanticIterator(self, semanticOrigin, (EObject)diagram);
            if (self.getDomainClass() != null) {
                while (it.hasNext()) {
                    EObject eObj = it.next();
                    if (!ContainerMappingWithInterpreterHelper.isInstanceOf(eObj, self.getDomainClass()) || !SiriusElementMappingSpecOperations.checkPrecondition(self, eObj, safeContainer, containerView)) continue;
                    result.add((Object)eObj);
                }
            } else {
                SiriusPlugin.getDefault().error(Messages.ContainerMappingHelper_nodeCreationErrorMsg, (Throwable)new RuntimeException());
            }
            self.getCandidatesCache().put(couple, (EList<EObject>)result);
        }
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.GET_CONTAINER_CANDIDATES_KEY);
        return result;
    }

    private static boolean isInstanceOf(EObject eObj, String typename) {
        return SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(eObj).eInstanceOf(eObj, typename);
    }

    public static DiagramElementMapping getBestMapping(ContainerDropDescription dropTool, DragAndDropTarget targetContainer, EObject droppedElement) {
        DDiagram diagram;
        LinkedList<ContainerMapping> allMappings;
        DiagramElementMapping bestMapping = null;
        Iterator iterCandidates = null;
        if (targetContainer instanceof DDiagram) {
            Session session;
            DDiagram diagram2 = (DDiagram)targetContainer;
            DiagramDescription desc = diagram2.getDescription();
            Collection<Object> selectedViewpoints = Collections.emptyList();
            if (diagram2 instanceof DSemanticDiagram && (session = SessionManager.INSTANCE.getSession(((DSemanticDiagram)diagram2).getTarget())) != null) {
                selectedViewpoints = session.getSelectedViewpoints(false);
            }
            allMappings = new LinkedList<ContainerMapping>((Collection<ContainerMapping>)new DiagramComponentizationManager().getAllContainerMappings(selectedViewpoints, desc));
            allMappings.addAll(ContainerMappingWithInterpreterHelper.getAllMappingsWithSuperMappings(selectedViewpoints, desc));
            allMappings.addAll((Collection<ContainerMapping>)new DiagramComponentizationManager().getAllEdgeMappings(selectedViewpoints, desc));
            iterCandidates = allMappings.iterator();
        } else if (targetContainer instanceof DDiagramElementContainer) {
            DDiagramElementContainer elementContainer = (DDiagramElementContainer)targetContainer;
            RepresentationElementMapping mapping = elementContainer.getMapping();
            if (mapping instanceof ContainerMapping) {
                ContainerMapping containerMapping = (ContainerMapping)mapping;
                allMappings = new LinkedList<ContainerMapping>((Collection<ContainerMapping>)MappingHelper.getAllContainerMappings(containerMapping));
                allMappings.addAll(ContainerMappingWithInterpreterHelper.getAllMappingsWithSuperMappings(containerMapping));
                allMappings.addAll((Collection<ContainerMapping>)MappingHelper.getAllBorderedNodeMappings(containerMapping));
                diagram = elementContainer.getParentDiagram();
                DiagramDescription desc = diagram.getDescription();
                allMappings.addAll((Collection<ContainerMapping>)desc.getAllEdgeMappings());
                iterCandidates = allMappings.iterator();
            }
        } else if (targetContainer instanceof DNode) {
            DNode viewNode = (DNode)targetContainer;
            NodeMapping nodeMapping = viewNode.getActualMapping();
            LinkedList<NodeMapping> allMappings2 = new LinkedList<NodeMapping>((Collection<NodeMapping>)MappingHelper.getAllBorderedNodeMappings(nodeMapping));
            iterCandidates = allMappings2.iterator();
        }
        if (iterCandidates == null) {
            SiriusPlugin.getDefault().error(MessageFormat.format(Messages.ContainerDropDescriptionSpec_unknownTgtMsg, targetContainer), (Throwable)new RuntimeException());
            return null;
        }
        Session session = SessionManager.INSTANCE.getSession(droppedElement);
        ModelAccessor extendedPackage = session.getModelAccessor();
        while (iterCandidates.hasNext()) {
            DiagramMappingsManager mappingManager;
            DiagramElementMapping currentMapping = (DiagramElementMapping)iterCandidates.next();
            String domainClass = ContainerMappingWithInterpreterHelper.getDomainClass(currentMapping);
            if (!dropTool.getMappings().contains((Object)currentMapping) || domainClass == null || StringUtil.isEmpty((String)domainClass.trim()) || !extendedPackage.eInstanceOf(droppedElement, domainClass) || (diagram = ContainerMappingWithInterpreterHelper.getDiagram(targetContainer)) == null || !LayerHelper.isInActivatedLayer(mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, diagram), diagram, currentMapping)) continue;
            bestMapping = currentMapping;
            break;
        }
        return bestMapping;
    }

    private static Collection<DiagramElementMapping> getAllMappingsWithSuperMappings(ContainerMapping containerMapping) {
        ArrayList<DiagramElementMapping> result = new ArrayList<DiagramElementMapping>();
        for (NodeMapping nM : MappingHelper.getAllNodeMappings(containerMapping)) {
            result.add(nM);
        }
        return result;
    }

    private static Collection<DiagramElementMapping> getAllMappingsWithSuperMappings(Collection<Viewpoint> selectedViewpoints, DiagramDescription desc) {
        ArrayList<DiagramElementMapping> result = new ArrayList<DiagramElementMapping>();
        for (NodeMapping nM : new DiagramComponentizationManager().getAllNodeMappings(selectedViewpoints, desc)) {
            result.add(nM);
        }
        return result;
    }

    private static DDiagram getDiagram(DragAndDropTarget target) {
        DDiagram diagram = null;
        if (target instanceof DDiagramElement) {
            diagram = ((DDiagramElement)((Object)target)).getParentDiagram();
        } else if (target instanceof DDiagram) {
            diagram = (DDiagram)target;
        }
        return diagram;
    }

    private static String getDomainClass(DiagramElementMapping mapping) {
        String domainClass = null;
        if (mapping instanceof EdgeMapping) {
            EdgeMapping edgeMapping = (EdgeMapping)mapping;
            if (edgeMapping.isUseDomainElement()) {
                domainClass = edgeMapping.getDomainClass();
            }
        } else if (mapping instanceof AbstractNodeMapping) {
            domainClass = ((AbstractNodeMapping)mapping).getDomainClass();
        }
        return domainClass;
    }

    public DDiagramElementContainer createContainer(IContainerMappingExt self, EObject modelElement, EObject container, DDiagram dDiagram) {
        ContainerStyle containerStyle;
        DDiagramElementContainer newContainer = null;
        if (new ContainerMappingQuery(self).isListContainer()) {
            newContainer = DiagramFactory.eINSTANCE.createDNodeList();
        } else {
            newContainer = DiagramFactory.eINSTANCE.createDNodeContainer();
            DNodeContainer nodeContainer = DiagramFactory.eINSTANCE.createDNodeContainer();
            nodeContainer.setChildrenPresentation(self.getChildrenPresentation());
            newContainer = nodeContainer;
        }
        ContainerStyleDescription style = (ContainerStyleDescription)new MappingWithInterpreterHelper(this.interpreter).getBestStyleDescription(self, modelElement, (EObject)newContainer, container, dDiagram);
        newContainer.setTarget(modelElement);
        newContainer.setActualMapping(self);
        DiagramElementMappingHelper.refreshSemanticElements(self, newContainer, this.interpreter);
        this.interpreter.setVariable("diagram", (Object)dDiagram);
        this.interpreter.setVariable("view", (Object)newContainer);
        if (style != null && style.getLabelExpression() != null) {
            try {
                String name = this.interpreter.evaluateString(modelElement, style.getLabelExpression());
                newContainer.setName(name);
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)style, (EStructuralFeature)StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelExpression(), (Throwable)e);
            }
        }
        if ((containerStyle = (ContainerStyle)new MappingWithInterpreterHelper(this.interpreter).getBestStyle(self, modelElement, (EObject)newContainer, container, dDiagram)) != null) {
            newContainer.setOwnedStyle(containerStyle);
        }
        if (newContainer.getOwnedStyle() != null) {
            Option noPreviousStyle = Options.newNone();
            new StyleHelper(this.interpreter).refreshStyle(newContainer.getOwnedStyle(), (Option<? extends Style>)noPreviousStyle);
        }
        MappingWithInterpreterHelper.addDoneNode(self, (DSemanticDecorator)newContainer);
        this.interpreter.unSetVariable("view");
        this.interpreter.unSetVariable("diagram");
        AbstractNodeMappingSpecOperations.createBorderingNodes(self, modelElement, newContainer, Collections.EMPTY_LIST, dDiagram);
        return newContainer;
    }

    public void updateContainer(IContainerMappingExt self, DDiagramElementContainer container) {
        DSemanticDecorator cContainer = (DSemanticDecorator)container.eContainer();
        ContainerStyleDescription style = null;
        if (cContainer != null) {
            style = (ContainerStyleDescription)new MappingWithInterpreterHelper(this.interpreter).getBestStyleDescription(self, container.getTarget(), (EObject)container, (EObject)container, container.getParentDiagram());
        }
        this.interpreter.setVariable("view", (Object)container);
        if (style != null && style.getLabelExpression() != null) {
            try {
                String name = this.interpreter.evaluateString(container.getTarget(), style.getLabelExpression());
                container.setName(name);
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)style, (EStructuralFeature)StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelExpression(), (Throwable)e);
            }
        }
        if (style != null && style.getTooltipExpression() != null) {
            try {
                try {
                    this.interpreter.setVariable("view", (Object)container);
                    String tooltip = this.interpreter.evaluateString(container.getTarget(), style.getTooltipExpression());
                    container.setTooltipText(tooltip);
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)style, (EStructuralFeature)StylePackage.eINSTANCE.getTooltipStyleDescription_TooltipExpression(), (Throwable)e);
                    this.interpreter.unSetVariable("view");
                }
            }
            finally {
                this.interpreter.unSetVariable("view");
            }
        }
        DiagramElementMappingHelper.refreshSemanticElements(self, container, this.interpreter);
        EObject containerVariable = null;
        if (container.eContainer() instanceof DSemanticDecorator) {
            containerVariable = ((DSemanticDecorator)container.eContainer()).getTarget();
        }
        Style currentStyle = container.getStyle();
        Style bestStyle = new MappingWithInterpreterHelper(this.interpreter).getBestStyle(self, container.getTarget(), (EObject)container, containerVariable, container.getParentDiagram());
        StyleHelper sHelper = new StyleHelper(this.interpreter);
        if (currentStyle == null) {
            sHelper.setAndRefreshStyle(container, null, bestStyle);
        } else if (currentStyle.getCustomFeatures().isEmpty()) {
            if (currentStyle.getDescription() != bestStyle.getDescription() || !currentStyle.equals(bestStyle)) {
                sHelper.setAndRefreshStyle(container, currentStyle, bestStyle);
            } else {
                sHelper.refreshStyle(currentStyle);
            }
        }
        MappingWithInterpreterHelper.addDoneNode(self, (DSemanticDecorator)container);
    }

    public ContainerStyle getBestStyle(ContainerMapping containerMapping, EObject modelElement, EObject viewVariable, EObject containerVariable) {
        ContainerStyle result = null;
        if (containerMapping instanceof ContainerMappingImport) {
            ContainerMappingImport containerMappingImport = (ContainerMappingImport)containerMapping;
            StyleHelper sHelper = new StyleHelper(SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(modelElement));
            result = sHelper.createContainerStyle(containerMapping.getStyle());
            ContainerMapping importedMappingStyle = containerMappingImport.getImportedMapping();
            if (result == null && importedMappingStyle != null && importedMappingStyle != containerMapping) {
                result = importedMappingStyle instanceof ContainerMappingSpec ? (ContainerStyle)new MappingWithInterpreterHelper(this.interpreter).getBestStyle(importedMappingStyle, modelElement, viewVariable, containerVariable, (DDiagram)new EObjectQuery(viewVariable).getParentDiagram().get()) : this.getBestStyle(importedMappingStyle, modelElement, viewVariable, containerVariable);
            }
        }
        return result;
    }
}

