/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.util.ast;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.AbstractAstBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.AstNodeFactory;
import org.eclipse.scout.sdk.s2e.util.ast.AstUtils;

public class AstMethodBuilder<INSTANCE extends AstMethodBuilder<INSTANCE>>
extends AbstractAstBuilder<INSTANCE> {
    private final INSTANCE m_return = this;
    private String m_methodName;
    private Type m_returnType;
    private Block m_body;
    private boolean m_createOverride;
    private boolean m_createJavaDoc;
    private MethodDeclaration m_resultMethod;

    protected AstMethodBuilder(AstNodeFactory owner) {
        super(owner);
    }

    public INSTANCE withName(String name) {
        this.m_methodName = name;
        return this.m_return;
    }

    public INSTANCE withReturnType(Type returnType) {
        this.m_returnType = returnType;
        return this.m_return;
    }

    public INSTANCE withBody(Block body) {
        this.m_body = body;
        return this.m_return;
    }

    public INSTANCE withOverride(boolean createOverride) {
        this.m_createOverride = createOverride;
        return this.m_return;
    }

    public INSTANCE withJavaDoc(boolean createJavaDoc) {
        this.m_createJavaDoc = createJavaDoc;
        return this.m_return;
    }

    public MethodDeclaration get() {
        return this.m_resultMethod;
    }

    public String getMethodName() {
        return this.m_methodName;
    }

    public boolean isCreateOverride() {
        return this.m_createOverride;
    }

    public boolean isCreateJavaDoc() {
        return this.m_createJavaDoc;
    }

    public Type getReturnType() {
        return this.m_returnType;
    }

    public Block getBody() {
        return this.m_body;
    }

    protected void insertMethod() {
        if (this.getDeclaringType() != null) {
            this.getDeclaringType().bodyDeclarations().add(this.m_resultMethod);
        }
    }

    @Override
    public INSTANCE insert() {
        Validate.notNull((Object)this.getMethodName());
        AST ast = this.getFactory().getAst();
        Block body = this.getBody();
        if (body == null) {
            body = ast.newBlock();
        }
        this.m_resultMethod = ast.newMethodDeclaration();
        this.m_resultMethod.setConstructor(false);
        for (Modifier.ModifierKeyword mod : this.getModifiers()) {
            this.m_resultMethod.modifiers().add(ast.newModifier(mod));
        }
        SimpleName methodName = ast.newSimpleName(this.getMethodName());
        this.m_resultMethod.setName(methodName);
        Type returnType = this.getReturnType();
        if (returnType != null) {
            this.m_resultMethod.setReturnType2(returnType);
        }
        this.m_resultMethod.setBody(body);
        if (this.isCreateJavaDoc() && this.getFactory().isCreateCommentsSetting() && this.getModifiers().contains(Modifier.ModifierKeyword.PUBLIC_KEYWORD)) {
            try {
                String declaringTypeFqn = AstUtils.getFullyQualifiedName((TypeDeclaration)this.getDeclaringType(), (TypeDeclaration)this.getFactory().getType(), (char)'.');
                String javadocText = CodeGeneration.getMethodComment((ICompilationUnit)this.getFactory().getIcu(), (String)declaringTypeFqn, (MethodDeclaration)this.m_resultMethod, null, (String)this.getFactory().getIcu().findRecommendedLineSeparator());
                if (StringUtils.isNotBlank((CharSequence)javadocText)) {
                    Javadoc javadoc = (Javadoc)this.getFactory().getRewrite().createStringPlaceholder(javadocText, 29);
                    this.m_resultMethod.setJavadoc(javadoc);
                }
            }
            catch (CoreException e) {
                SdkLog.warning((String)"Unable to add default javadoc to form field getter.", (Object[])new Object[]{e});
            }
        }
        if (this.isCreateOverride() && this.getFactory().isCreateOverrideAnnotationSetting()) {
            AstUtils.addAnnotationTo((Annotation)this.getFactory().newOverrideAnnotation(), (BodyDeclaration)this.m_resultMethod);
        }
        this.insertMethod();
        return (INSTANCE)this;
    }
}

