/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.api.io.KeyKeeper;
import org.eclipse.passage.lic.base.io.LicensingPaths;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;

public class BundleKeyKeeper
implements KeyKeeper {
    protected static final String PATH_DEFAULT = "OSGI-INF/";
    private ComponentContext componentContext;

    @Activate
    public void activate(ComponentContext context) {
        this.componentContext = context;
    }

    public InputStream openKeyStream(LicensingConfiguration configuration) throws IOException {
        String fileName = LicensingPaths.composeFileName((LicensingConfiguration)configuration, (String)LicensingPaths.EXTENSION_PRODUCT_PUBLIC);
        String keypath = PATH_DEFAULT + fileName;
        Bundle bundle = this.getUsingBundle(this.componentContext);
        if (bundle == null) {
            throw new FileNotFoundException(keypath);
        }
        URL resource = bundle.getResource(keypath);
        if (resource == null) {
            throw new FileNotFoundException(keypath);
        }
        return resource.openStream();
    }

    protected Bundle getUsingBundle(ComponentContext context) {
        Bundle bundle = context.getUsingBundle();
        if (bundle == null) {
            return FrameworkUtil.getBundle(this.getClass());
        }
        return bundle;
    }
}

