/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.profile.ImageManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ElementImportTreeSelectionDialog<E extends Element>
extends Dialog {
    private final java.lang.Class<E> elementType;
    protected List<Package> packages;
    protected final EnumSet<ImportAction> allowedActions;
    protected boolean subSelection = false;
    private Set<E> initialSelections = new HashSet();
    private Map<E, ImportSpec<E>> importSpecs = new HashMap<E, ImportSpec<E>>();
    protected List<ImportSpec<E>> elementsToImport = new ArrayList<ImportSpec<E>>();
    protected CheckboxTreeViewer elementTree;
    protected static final Image IMG_PACKAGE = ImageManager.IMG_PACKAGE;
    protected static final Image IMG_CLASS = ImageManager.IMG_CLASS;
    protected static final Image IMG_DATATYPE = ImageManager.IMG_DATATYPE;
    protected static final Image IMG_ENUM = ImageManager.IMG_ENUMERATION;
    protected static final Image IMG_PRIMITIVE = ImageManager.IMG_PRIMITIVETYPE;
    protected static final Image IMG_PROFILE = ImageManager.IMG_PROFILE;
    protected static final Image IMG_ASSOCIATION = ImageManager.IMG_ASSOCIATION;
    protected static final Image IMG_INSTANCESPEC = ImageManager.IMG_INSTANCESPEC;

    public ElementImportTreeSelectionDialog(Shell parent, ImportAction action, java.lang.Class<E> elementType, Package model) {
        this(parent, EnumSet.of(action), elementType, Collections.singletonList(model));
    }

    public ElementImportTreeSelectionDialog(Shell parent, ImportAction action, java.lang.Class<E> elementType, Collection<? extends Package> models) {
        this(parent, EnumSet.of(action), elementType, models);
    }

    public ElementImportTreeSelectionDialog(Shell parent, Set<ImportAction> allowedActions, java.lang.Class<E> elementType, Package model) {
        this(parent, allowedActions, elementType, Collections.singletonList(model));
    }

    public ElementImportTreeSelectionDialog(Shell parent, Set<ImportAction> allowedActions, java.lang.Class<E> elementType, Collection<? extends Package> models) {
        super(parent);
        this.allowedActions = EnumSet.copyOf(allowedActions);
        this.elementType = elementType;
        this.packages = new ArrayList<Package>(models);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select the elements to import");
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Tree tree = new Tree(comp, 2592);
        GridData treeData = new GridData(4, 4, true, true);
        treeData.widthHint = 300;
        treeData.heightHint = 300;
        tree.setLayoutData((Object)treeData);
        tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    ElementImportTreeSelectionDialog.this.handleCheckStateChanged(ElementImportTreeSelectionDialog.this.getImportSpec(event.item));
                }
            }
        });
        this.elementTree = new CheckboxTreeViewer(tree);
        TreeViewerColumn col = new TreeViewerColumn((TreeViewer)this.elementTree, 0);
        col.getColumn().setText("Import");
        col.getColumn().setWidth(300);
        col.getColumn().setResizable(true);
        col.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                ImportSpec importSpec = (ImportSpec)cell.getElement();
                cell.setImage(ElementImportTreeSelectionDialog.this.getElementImage((Element)importSpec.getElement()));
                cell.setText(ElementImportTreeSelectionDialog.this.getElementText((Element)importSpec.getElement()));
            }

            public String getToolTipText(Object element) {
                ImportSpec importSpec = (ImportSpec)element;
                return importSpec.getElement().eResource().getURI().toString();
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.elementTree);
        if (this.allowedActions.size() > 1) {
            tree.setHeaderVisible(true);
            col.getColumn().setWidth(220);
            col = new TreeViewerColumn((TreeViewer)this.elementTree, 0);
            col.getColumn().setText("Action");
            col.getColumn().setWidth(80);
            col.getColumn().setResizable(true);
            col.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    ImportSpec importSpec = (ImportSpec)cell.getElement();
                    cell.setText(ElementImportTreeSelectionDialog.this.getDisplayName(importSpec.getAction()));
                }
            });
            col.setEditingSupport((EditingSupport)new ImportActionEditingSupport((ColumnViewer)this.elementTree));
        }
        this.elementTree.setContentProvider((IContentProvider)new ElementTreeContentProvider());
        this.elementTree.setInput(this.packages);
        this.elementTree.expandAll();
        tree.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (Element next : ElementImportTreeSelectionDialog.this.initialSelections) {
                    ImportSpec importSpec = ElementImportTreeSelectionDialog.this.getImportSpec(next);
                    if (importSpec == null) continue;
                    ElementImportTreeSelectionDialog.this.elementTree.setChecked(importSpec, true);
                    ElementImportTreeSelectionDialog.this.handleCheckStateChanged(importSpec);
                }
            }
        });
        return comp;
    }

    protected void handleCheckStateChanged(ImportSpec<E> importSpec) {
        if (!this.elementTree.getChecked(importSpec)) {
            this.removeResult(importSpec);
        } else {
            this.addResult(importSpec);
        }
    }

    protected void setInitialSelection(E element) {
        this.initialSelections.add(element);
    }

    protected String getDisplayName(ImportAction importAction) {
        String result;
        switch (importAction) {
            case IMPORT: {
                result = "Import";
                break;
            }
            case APPLY: {
                result = "Apply";
                break;
            }
            case COPY: {
                result = "Copy";
                break;
            }
            case LOAD: {
                result = "Load";
                break;
            }
            default: {
                result = "<none>";
            }
        }
        return result;
    }

    protected void addChildSelection(ImportSpec<E> item) {
        ITreeContentProvider provider = (ITreeContentProvider)this.elementTree.getContentProvider();
        Object[] objectArray = provider.getChildren(item);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object next = objectArray[n2];
            this.elementTree.setChecked(next, true);
            this.addResult((ImportSpec)next);
            ++n2;
        }
    }

    protected void remChildSelection(ImportSpec<E> item) {
        ITreeContentProvider provider = (ITreeContentProvider)this.elementTree.getContentProvider();
        Object[] objectArray = provider.getChildren(item);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object next = objectArray[n2];
            this.elementTree.setChecked(next, false);
            this.removeResult((ImportSpec)next);
            ++n2;
        }
    }

    protected String getElementText(Element element) {
        String result = null;
        if (element instanceof NamedElement) {
            result = UMLLabelInternationalization.getInstance().getLabel((NamedElement)element);
        }
        return result == null ? "" : result;
    }

    protected Image getElementImage(Element element) {
        return (Image)new UMLSwitch<Image>(){

            public Image casePackage(Package object) {
                return IMG_PACKAGE;
            }

            public Image caseProfile(Profile object) {
                return IMG_PROFILE;
            }

            public Image caseAssociation(Association object) {
                return IMG_ASSOCIATION;
            }

            public Image caseEnumeration(Enumeration object) {
                return IMG_ENUM;
            }

            public Image casePrimitiveType(PrimitiveType object) {
                return IMG_PRIMITIVE;
            }

            public Image caseDataType(DataType object) {
                return IMG_DATATYPE;
            }

            public Image caseClass(Class object) {
                return IMG_CLASS;
            }

            public Image caseInstanceSpecification(InstanceSpecification object) {
                return IMG_INSTANCESPEC;
            }
        }.doSwitch((EObject)element);
    }

    public Collection<ImportSpec<E>> getResult() {
        return this.elementsToImport;
    }

    protected Collection<? extends Element> getChildren(Package package_) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element elem : package_.getPackagedElements()) {
            if (!(elem instanceof NamedElement)) continue;
            result.add(elem);
        }
        return result;
    }

    protected ImportSpec<E> createImportSpec(Element element) {
        ImportSpec<Element> result = new ImportSpec<Element>(element);
        if (this.elementType.isInstance(element) && !this.allowedActions.isEmpty()) {
            result.setAction((ImportAction)((Object)this.allowedActions.iterator().next()));
        }
        return result;
    }

    protected ImportSpec<E> getImportSpec(Element element) {
        ImportSpec<E> result = this.importSpecs.get(element);
        if (result == null) {
            result = this.createImportSpec(element);
            this.importSpecs.put(element, result);
        }
        return result;
    }

    protected ImportSpec<E> getImportSpec(Widget item) {
        return (ImportSpec)item.getData();
    }

    protected <T extends E> Iterator<T> getAllElementsOfType(java.lang.Class<T> type) {
        return this.filter((Iterator<?>)EcoreUtil.getAllContents(this.packages), type);
    }

    private <T> Iterator<T> filter(Iterator<?> iterator, final java.lang.Class<T> type) {
        return new Iterator<T>(iterator){
            private final Iterator<?> delegate;
            private T next;
            {
                this.delegate = iterator;
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    while (this.delegate.hasNext()) {
                        Object next = this.delegate.next();
                        if (!type.isInstance(next)) continue;
                        this.next = type.cast(next);
                        break;
                    }
                }
                return this.next != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.next = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    protected <T extends E> Iterator<T> getRootElementsOfType(java.lang.Class<T> type) {
        return this.filter(this.packages.iterator(), type);
    }

    protected void selectAll(ImportAction action) {
        Iterator<E> iter;
        if (action == ImportAction.NONE || this.subSelection) {
            iter = this.getAllElementsOfType(this.elementType);
        } else {
            this.selectAll(ImportAction.NONE);
            iter = this.getRootElementsOfType(this.elementType);
        }
        while (iter.hasNext()) {
            ImportSpec<E> importSpec = this.getImportSpec((Element)iter.next());
            if (action == ImportAction.NONE) {
                if (this.elementTree.getChecked(importSpec)) {
                    this.elementTree.setChecked(importSpec, false);
                    this.removeResult(importSpec);
                }
            } else {
                if (!this.elementTree.getChecked(importSpec)) {
                    this.elementTree.setChecked(importSpec, true);
                    this.addResult(importSpec);
                }
                importSpec.setAction(action);
            }
            this.elementTree.update(importSpec, null);
        }
    }

    protected void addResult(ImportSpec<E> importSpec) {
        if (!this.elementsToImport.contains(importSpec)) {
            this.elementsToImport.add(importSpec);
        }
        if (this.subSelection) {
            this.addChildSelection(importSpec);
        }
    }

    protected void removeResult(ImportSpec<E> importSpec) {
        while (this.elementsToImport.contains(importSpec)) {
            this.elementsToImport.remove(importSpec);
        }
        if (this.subSelection) {
            this.remChildSelection(importSpec);
        }
    }

    private class ElementTreeContentProvider
    implements ITreeContentProvider {
        private ElementTreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList result = new ArrayList(ElementImportTreeSelectionDialog.this.packages.size());
            for (Package next : ElementImportTreeSelectionDialog.this.packages) {
                result.add(ElementImportTreeSelectionDialog.this.getImportSpec((Element)next));
            }
            return result.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList result = new ArrayList();
            Object parent = ((ImportSpec)parentElement).getElement();
            if (parent instanceof Package) {
                for (Element next : ElementImportTreeSelectionDialog.this.getChildren((Package)parent)) {
                    result.add(ElementImportTreeSelectionDialog.this.getImportSpec(next));
                }
            }
            return result.toArray();
        }

        public boolean hasChildren(Object element) {
            Object parent = ((ImportSpec)element).getElement();
            return parent instanceof Package;
        }

        public Object getParent(Object element) {
            ImportSpec result = null;
            ImportSpec importSpec = (ImportSpec)element;
            Element parent = importSpec.getElement().getOwner();
            if (parent != null && ElementImportTreeSelectionDialog.this.importSpecs.containsKey(parent)) {
                result = (ImportSpec)ElementImportTreeSelectionDialog.this.importSpecs.get(parent);
            }
            return result;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    public static enum ImportAction {
        NONE,
        LOAD,
        IMPORT,
        APPLY,
        COPY;

    }

    private class ImportActionEditingSupport
    extends EditingSupport {
        private ComboBoxViewerCellEditor editor;

        public ImportActionEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected CellEditor getCellEditor(Object element) {
            if (this.editor == null) {
                this.editor = new ComboBoxViewerCellEditor((Composite)((Tree)this.getViewer().getControl()), 2048);
                this.editor.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return ElementImportTreeSelectionDialog.this.getDisplayName((ImportAction)((Object)element));
                    }
                });
                this.editor.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                this.editor.setInput(ElementImportTreeSelectionDialog.this.allowedActions);
            }
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            ImportSpec spec = (ImportSpec)element;
            return ElementImportTreeSelectionDialog.this.elementType.isInstance(spec.getElement());
        }

        protected Object getValue(Object element) {
            ImportSpec spec = (ImportSpec)element;
            return ElementImportTreeSelectionDialog.this.elementType.isInstance(spec.getElement()) ? spec.getAction() : ImportAction.NONE;
        }

        protected void setValue(final Object element, Object value) {
            ImportSpec importSpec = (ImportSpec)element;
            importSpec.setAction((ImportAction)((Object)value));
            if (!ElementImportTreeSelectionDialog.this.elementTree.getChecked((Object)importSpec)) {
                ElementImportTreeSelectionDialog.this.elementTree.setChecked((Object)importSpec, true);
                ElementImportTreeSelectionDialog.this.addResult(importSpec);
            }
            this.editor.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ((ImportActionEditingSupport)ImportActionEditingSupport.this).ElementImportTreeSelectionDialog.this.elementTree.update(element, null);
                }
            });
        }
    }

    public static class ImportSpec<E extends Element> {
        private final E element;
        private ImportAction action = ImportAction.NONE;

        protected ImportSpec(E element) {
            this.element = element;
        }

        public E getElement() {
            return this.element;
        }

        public ImportAction getAction() {
            return this.action;
        }

        public void setAction(ImportAction action) {
            this.action = action == null ? ImportAction.NONE : action;
        }

        public String toString() {
            return String.format("<%s> %s", new Object[]{this.action, this.element});
        }
    }
}

