/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.editor.reload;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.ui.editor.reload.CompositeReloadContext;
import org.eclipse.papyrus.infra.ui.editor.reload.DelegatingReloadContext;

interface IInternalEMFSelectionContext {
    public void setResourceSetSupplier(Supplier<? extends ResourceSet> var1);

    public URI getToken(Object var1);

    public Object resolveToken(URI var1);

    public static class Composite
    extends Default {
        private final CompositeReloadContext composite;

        Composite(CompositeReloadContext composite) {
            this.composite = composite;
        }

        @Override
        public void setResourceSetSupplier(Supplier<? extends ResourceSet> resourceSetSupplier) {
            super.setResourceSetSupplier(resourceSetSupplier);
            for (Object next : this.composite.getReloadContexts()) {
                IInternalEMFSelectionContext emfContext = (IInternalEMFSelectionContext)AdapterUtils.adapt(next, IInternalEMFSelectionContext.class, null);
                if (emfContext == null) continue;
                emfContext.setResourceSetSupplier((Supplier<? extends ResourceSet>)this.resourceSetSupplier);
            }
        }
    }

    public static class Default
    implements IInternalEMFSelectionContext {
        Supplier<? extends ResourceSet> resourceSetSupplier;

        Default() {
        }

        @Override
        public void setResourceSetSupplier(Supplier<? extends ResourceSet> resourceSetSupplier) {
            this.resourceSetSupplier = Suppliers.memoize(resourceSetSupplier);
        }

        @Override
        public URI getToken(Object object) {
            return object instanceof EObject ? EcoreUtil.getURI((EObject)((EObject)object)) : null;
        }

        @Override
        public Object resolveToken(URI token) {
            ResourceSet rset = this.resourceSetSupplier == null ? null : (ResourceSet)this.resourceSetSupplier.get();
            return rset == null ? null : rset.getEObject(token, true);
        }
    }

    public static class Delegating
    extends Default {
        private final DelegatingReloadContext delegating;

        Delegating(DelegatingReloadContext delegating) {
            this.delegating = delegating;
        }

        @Override
        public void setResourceSetSupplier(Supplier<? extends ResourceSet> resourceSetSupplier) {
            super.setResourceSetSupplier(resourceSetSupplier);
            IInternalEMFSelectionContext emfContext = (IInternalEMFSelectionContext)AdapterUtils.adapt((Object)this.delegating.getDelegate(), IInternalEMFSelectionContext.class, null);
            if (emfContext != null) {
                emfContext.setResourceSetSupplier((Supplier<? extends ResourceSet>)this.resourceSetSupplier);
            }
        }
    }
}

