/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.emf.WorkspaceSaveHelper;
import org.eclipse.papyrus.infra.emf.internal.resource.index.IndexPersistenceManager;
import org.eclipse.papyrus.infra.emf.spi.resolver.EObjectResolverService;
import org.eclipse.papyrus.infra.emf.spi.resolver.IEObjectResolver;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.infra.emf";
    private static Activator plugin;
    public static LogHelper log;
    private ICustomizationManager fCustomizationManager;
    private ResourceSet facetRecsourceSet = new ResourceSetImpl();
    private EObjectResolverService resolverService;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)this);
        this.resolverService = new EObjectResolverService(context);
        WorkspaceSaveHelper saveHelper = new WorkspaceSaveHelper();
        List<WorkspaceSaveHelper.SaveDelegate> saveDelegates = this.getSaveDelegates();
        ISavedState state = ResourcesPlugin.getWorkspace().addSaveParticipant(PLUGIN_ID, saveHelper.createSaveParticipant(saveDelegates));
        if (state != null && state.getSaveNumber() != 0) {
            saveHelper.initializeSaveDelegates(state, saveDelegates);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.resolverService.dispose();
        this.resolverService = null;
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ICustomizationManager getCustomizationManager() {
        if (this.fCustomizationManager == null) {
            this.fCustomizationManager = ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager(this.facetRecsourceSet);
        }
        return this.fCustomizationManager;
    }

    public static String getMetaclassQualifiedName(EClassifier eClass) {
        ArrayList<String> qualifiedNameParts = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        EPackage ePackage = eClass.getEPackage();
        while (ePackage != null) {
            qualifiedNameParts.add(ePackage.getName());
            ePackage = ePackage.getESuperPackage();
        }
        int i = qualifiedNameParts.size() - 1;
        while (i >= 0) {
            builder.append(String.valueOf((String)qualifiedNameParts.get(i)) + ".");
            --i;
        }
        builder.append(eClass.getName());
        return builder.toString();
    }

    public IEObjectResolver getEObjectResolver() {
        return this.resolverService;
    }

    private List<WorkspaceSaveHelper.SaveDelegate> getSaveDelegates() {
        WorkspaceSaveHelper.SaveDelegate[] saveDelegateArray = new WorkspaceSaveHelper.SaveDelegate[1];
        saveDelegateArray[0] = new WorkspaceSaveHelper.SaveDelegate("index", IndexPersistenceManager.INSTANCE.getSaveParticipant(), IndexPersistenceManager.INSTANCE::initialize);
        return Arrays.asList(saveDelegateArray);
    }
}

