/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.ecore;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameters;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.library.ecore.EcoreReflectiveFragment;
import org.eclipse.ocl.pivot.internal.library.ecore.EcoreReflectivePackage;
import org.eclipse.ocl.pivot.internal.library.executor.AbstractReflectiveInheritanceType;
import org.eclipse.ocl.pivot.internal.library.executor.DomainProperties;
import org.eclipse.ocl.pivot.types.AbstractFragment;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.TypeUtil;

public class EcoreReflectiveType
extends AbstractReflectiveInheritanceType {
    public static final @NonNull List<CompleteInheritance> EMPTY_INHERITANCES = Collections.emptyList();
    protected final @NonNull EcoreReflectivePackage evaluationPackage;
    protected final @NonNull EClassifier eClassifier;
    protected final @NonNull TemplateParameters typeParameters;
    private DomainProperties allProperties;

    public EcoreReflectiveType(@NonNull EcoreReflectivePackage evaluationPackage, int flags, @NonNull EClassifier eClassifier, TemplateParameter ... typeParameters) {
        super(ClassUtil.nonNullEMF(eClassifier.getName()), flags);
        this.evaluationPackage = evaluationPackage;
        this.eClassifier = eClassifier;
        this.typeParameters = TypeUtil.createTemplateParameters(typeParameters);
    }

    @Override
    protected @NonNull AbstractFragment createFragment(@NonNull CompleteInheritance baseInheritance) {
        return new EcoreReflectiveFragment(this, baseInheritance);
    }

    @Override
    public @NonNull EObject createInstance() {
        if (this.eClassifier instanceof EClass) {
            EClass eClass = (EClass)this.eClassifier;
            EObject element = eClass.getEPackage().getEFactoryInstance().create(eClass);
            return ClassUtil.nonNullEMF(element);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Object createInstance(@NonNull String value) {
        if (this.eClassifier instanceof EDataType) {
            EDataType eDataType = (EDataType)this.eClassifier;
            Object element = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, value);
            return ClassUtil.nonNullEMF(element);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Type getCommonType(@NonNull IdResolver idResolver, @NonNull Type type) {
        if (this == type) {
            return this.getPivotClass();
        }
        EcoreReflectiveType firstInheritance = this;
        CompleteInheritance secondInheritance = type.getInheritance(idResolver.getStandardLibrary());
        CompleteInheritance commonInheritance = firstInheritance.getCommonInheritance(secondInheritance);
        return commonInheritance.getPivotClass();
    }

    public final @NonNull EClassifier getEClassifier() {
        return this.eClassifier;
    }

    @Override
    public @NonNull Iterable<@NonNull ? extends CompleteInheritance> getInitialSuperInheritances() {
        EList eSuperTypes = this.eClassifier instanceof EClass ? ((EClass)this.eClassifier).getESuperTypes() : Collections.emptyList();
        final Iterator iterator = eSuperTypes.iterator();
        return new Iterable<CompleteInheritance>(){

            @Override
            public @NonNull Iterator<@NonNull CompleteInheritance> iterator() {
                return new Iterator<CompleteInheritance>(){
                    private boolean gotOne = false;

                    @Override
                    public boolean hasNext() {
                        return !this.gotOne || iterator.hasNext();
                    }

                    @Override
                    public @NonNull CompleteInheritance next() {
                        if (!this.gotOne) {
                            this.gotOne = true;
                            if (!iterator.hasNext()) {
                                StandardLibrary standardLibrary = (this).EcoreReflectiveType.this.evaluationPackage.getStandardLibrary();
                                Class oclAnyType = standardLibrary.getOclAnyType();
                                return standardLibrary.getInheritance(oclAnyType);
                            }
                        }
                        EClass next = (EClass)iterator.next();
                        if (!$assertionsDisabled && next == null) {
                            throw new AssertionError();
                        }
                        IdResolver idResolver = (this).EcoreReflectiveType.this.evaluationPackage.getIdResolver();
                        return idResolver.getInheritance((EClassifier)next);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public @NonNull Package getOwningPackage() {
        return this.evaluationPackage;
    }

    @Override
    public @NonNull List<Class> getSuperClasses() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable Operation getMemberOperation(@NonNull OperationId operationId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable Property getMemberProperty(@NonNull String name) {
        DomainProperties allProperties2 = this.allProperties;
        if (allProperties2 == null) {
            this.allProperties = allProperties2 = new DomainProperties(this);
        }
        return allProperties2.getMemberProperty(name);
    }

    @Override
    public @NonNull String getMetaTypeName() {
        return ClassUtil.nonNullPivot(this.eClassifier.getName());
    }

    @Override
    public @NonNull List<Constraint> getOwnedInvariants() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull List<Property> getOwnedProperties() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull List<Operation> getOwnedOperations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull List<Constraint> getOwnedConstraints() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Class getPivotClass() {
        return this;
    }

    @Override
    public @NonNull TypeId getTypeId() {
        return this.getOwningPackage().getPackageId().getClassId(this.name, this.getPivotClass().getTypeParameters().parametersSize());
    }

    @Override
    public @NonNull TemplateParameters getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public boolean isOrdered() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isUnique() {
        return (this.flags & 2) != 0;
    }
}

