/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.monitor;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.internal.util.table.Cell;
import org.eclipse.net4j.internal.util.table.Dumper;
import org.eclipse.net4j.internal.util.table.Formula;
import org.eclipse.net4j.internal.util.table.Range;
import org.eclipse.net4j.internal.util.table.RectangularRange;
import org.eclipse.net4j.internal.util.table.Table;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.monitor.SubMonitor;

public final class ProbingSubMonitor
extends SubMonitor {
    private static final boolean TRACE = Boolean.getBoolean("submonitor.probing.trace");
    private static final Map<StackTraceElement, Statistics> STATISTICS = new HashMap<StackTraceElement, Statistics>();
    private static final Map<Integer, KeyedWeakReference> MAP = new ConcurrentHashMap<Integer, KeyedWeakReference>();
    private static final ReferenceQueue<ProbingSubMonitor> QUEUE = new ReferenceQueue();
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final String NAME1 = SubMonitor.class.getName();
    private static final String NAME2 = ProbingSubMonitor.class.getName();
    private static final String NAME3 = SubMonitor.RootInfo.class.getName();
    private static final int FULL_MODE = 16;
    private static final int DONE_FLAG = 32;
    private final ProbingSubMonitor parent;
    private final int totalTicks;
    private final int key;
    private final Map<StackTraceElement, Probe> probes = new HashMap<StackTraceElement, Probe>();
    private StackTraceElement location = ProbingSubMonitor.determineLocation();
    private long timeStamp = ProbingSubMonitor.determineTimeStamp();
    private StackTraceElement forkLocation;
    private StackTraceElement forkTarget;
    private int forkTicks;

    static {
        final AtomicBoolean shuttingDown = new AtomicBoolean();
        Runtime.getRuntime().addShutdownHook(new Thread("Progress Probe Shutdown Hook"){

            public void run() {
                shuttingDown.set(true);
                for (KeyedWeakReference reference : MAP.values()) {
                    ProbingSubMonitor progress = (ProbingSubMonitor)reference.get();
                    if (progress == null) continue;
                    ProbingSubMonitor.finishProbe(progress);
                }
                ProbingSubMonitor.reportStatistics();
            }
        });
        Thread monitor = new Thread("Progress Probe Monitor"){

            public void run() {
                while (!this.isInterrupted() && !shuttingDown.get()) {
                    KeyedWeakReference reference = (KeyedWeakReference)QUEUE.poll();
                    if (reference == null) continue;
                    MAP.remove(reference.key);
                    ProbingSubMonitor progress = (ProbingSubMonitor)reference.get();
                    if (progress == null || (progress.flags & 0x20) != 0) continue;
                    ProbingSubMonitor.finishProbe(progress);
                }
            }
        };
        monitor.setDaemon(true);
        monitor.start();
    }

    ProbingSubMonitor(ProbingSubMonitor parent, SubMonitor.RootInfo rootInfo, int totalWork, int availableToChildren, int flags, boolean full) {
        super(rootInfo, totalWork, availableToChildren, flags | (full ? 16 : 0));
        this.parent = parent;
        this.totalTicks = totalWork;
        if (parent != null) {
            parent.forkTarget = this.location;
        }
        this.key = COUNTER.incrementAndGet();
        MAP.put(this.key, new KeyedWeakReference(this.key, this));
    }

    SubMonitor createSubMonitor(SubMonitor.RootInfo rootInfo, int totalWork, int availableToChildren, int flags) {
        this.timeStamp = ProbingSubMonitor.determineTimeStamp();
        this.forkLocation = ProbingSubMonitor.determineLocation();
        this.forkTicks = totalWork;
        boolean full = (flags & 0x10) != 0;
        return new ProbingSubMonitor(this, rootInfo, totalWork, availableToChildren, flags, full);
    }

    void adjustLocation() {
        this.location = ProbingSubMonitor.determineLocation();
        if (this.parent != null) {
            this.parent.forkTarget = this.location;
        }
    }

    public void worked(int work) {
        this.probe(work);
        super.worked(work);
    }

    public void done() {
        if ((this.flags & 0x20) == 0) {
            this.flags |= 0x20;
            try {
                ProbingSubMonitor.finishProbe(this);
                super.done();
                if (this.parent != null) {
                    this.parent.childDone();
                }
            }
            finally {
                this.forkLocation = null;
                this.forkTarget = null;
                this.forkTicks = 0;
                MAP.remove(this.key);
            }
        }
    }

    public void childDone() {
        if (this.forkLocation != null) {
            this.probe(this.forkLocation, this.forkTicks);
        }
    }

    public String toString() {
        return ProbingSubMonitor.shorten(this.location);
    }

    private void probe(int ticks) {
        StackTraceElement location = ProbingSubMonitor.determineLocation();
        this.probe(location, ticks);
    }

    private void probe(StackTraceElement location, int ticks) {
        try {
            long now = ProbingSubMonitor.determineTimeStamp();
            int time = (int)(Math.abs(now - this.timeStamp) / 1000000L);
            Probe probe = this.probes.get(location);
            if (probe == null) {
                probe = new Probe(location);
                this.probes.put(location, probe);
            }
            probe.update(this.forkTarget, ticks, time);
            this.forkLocation = null;
            this.forkTarget = null;
            this.forkTicks = 0;
            this.timeStamp = now;
        }
        catch (Exception ex) {
            OM.LOG.error(ex);
        }
    }

    private static String shorten(StackTraceElement location) {
        int length;
        String className = location.getClassName();
        boolean lastCharWasDigit = false;
        int i = length = className.length();
        while (--i >= 0) {
            char c = className.charAt(i);
            if (!(c != '.' && c != '$' || lastCharWasDigit)) {
                ++i;
                break;
            }
            lastCharWasDigit = Character.isDigit(c);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(className, i, length);
        builder.append('.');
        builder.append(location.getMethodName());
        if (location.isNativeMethod()) {
            builder.append("(Native Method)");
        } else {
            String fileName = location.getFileName();
            int lineNumber = location.getLineNumber();
            if (fileName != null && lineNumber >= 0) {
                builder.append('(');
                builder.append(fileName);
                builder.append(':');
                builder.append(lineNumber);
                builder.append(')');
            } else if (fileName != null) {
                builder.append('(');
                builder.append(fileName);
                builder.append(')');
            } else {
                builder.append("(Unknown Source)");
            }
        }
        return builder.toString();
    }

    private static StackTraceElement determineLocation() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int i = 3;
        while (i < stackTrace.length) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String className = stackTraceElement.getClassName();
            if (className != NAME1 && className != NAME2 && className != NAME3) {
                return stackTraceElement;
            }
            ++i;
        }
        return null;
    }

    private static long determineTimeStamp() {
        return System.nanoTime();
    }

    private static void finishProbe(ProbingSubMonitor progress) {
        try {
            StackTraceElement location = progress.location;
            Statistics statistics = STATISTICS.get(location);
            if (statistics == null) {
                statistics = new Statistics(location);
                STATISTICS.put(location, statistics);
            }
            statistics.update(progress);
        }
        catch (Exception ex) {
            OM.LOG.error(ex);
        }
    }

    public static void reportStatistics() {
        for (Statistics statistics : STATISTICS.values()) {
            statistics.report();
        }
    }

    public static void resetStatistics() {
        STATISTICS.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class KeyedWeakReference
    extends WeakReference<ProbingSubMonitor> {
        private final int key;

        public KeyedWeakReference(int key, ProbingSubMonitor progress) {
            super(progress);
            this.key = key;
        }
    }

    private static final class Probe {
        private final StackTraceElement location;
        private StackTraceElement[] forkTargets;
        private int ticks;
        private int time;

        public Probe(StackTraceElement location) {
            this.location = location;
        }

        public void update(StackTraceElement forkTarget, int ticks, int time) {
            this.ticks += ticks;
            this.time += time;
            if (forkTarget != null) {
                if (this.forkTargets == null) {
                    this.forkTargets = new StackTraceElement[]{forkTarget};
                } else {
                    int i = 0;
                    while (i < this.forkTargets.length) {
                        StackTraceElement location = this.forkTargets[i];
                        if (location.equals(forkTarget)) {
                            return;
                        }
                        ++i;
                    }
                    StackTraceElement[] newForkTargets = new StackTraceElement[this.forkTargets.length + 1];
                    System.arraycopy(this.forkTargets, 0, newForkTargets, 0, this.forkTargets.length);
                    newForkTargets[this.forkTargets.length] = forkTarget;
                    this.forkTargets = newForkTargets;
                }
            }
        }

        public String toString() {
            return this.location + " - " + this.time;
        }
    }

    private static final class Statistics {
        public static final Format TICKS = new DecimalFormat("0 Ticks");
        public static final Format MILLIS = new DecimalFormat("0 ms");
        public static final Format MILLIS_PRECISE = new DecimalFormat("0.00 ms");
        public static final Format PERCENT = new DecimalFormat("0 %");
        private static final int DEFAULT_COLUMNS = 3;
        private static final boolean SMOOTH_BORDERS = "smooth".equalsIgnoreCase(OMPlatform.INSTANCE.getProperty("submonitor.probing.borders"));
        private static final Dumper DUMPER = SMOOTH_BORDERS ? Dumper.UTF8 : Dumper.ASCII;
        private final StackTraceElement location;
        private long totalTicks;
        private int columns;
        private Row[] rows;

        public Statistics(StackTraceElement location) {
            this.location = location;
        }

        public void update(ProbingSubMonitor progress) {
            ArrayList<Row> newRows;
            this.totalTicks += (long)progress.totalTicks;
            if (this.rows == null) {
                newRows = new ArrayList<Row>(10);
            } else {
                newRows = new ArrayList(10 + this.rows.length);
                int i = 0;
                while (i < this.rows.length) {
                    Row row = this.rows[i];
                    Probe probe = (Probe)progress.probes.remove(row.location);
                    if (probe == null) {
                        row.skipProbes(1);
                    } else {
                        row.addProbe(probe);
                    }
                    newRows.add(row);
                    ++i;
                }
            }
            boolean full = (progress.flags & 0x10) != 0;
            for (Probe newProbe : progress.probes.values()) {
                Row row = Row.create(newProbe.location, full);
                if (this.columns > 0) {
                    row.skipProbes(this.columns);
                }
                row.addProbe(newProbe);
                newRows.add(row);
            }
            this.rows = newRows.toArray(new Row[newRows.size()]);
            ++this.columns;
            if (TRACE) {
                this.report();
            }
        }

        public void report() {
            if (this.rows != null && this.rows.length != 0) {
                Arrays.sort(this.rows);
                int rowCount = this.rows.length;
                Table table = new Table(3, 1 + rowCount);
                table.cell(0, 0).value(ProbingSubMonitor.shorten(this.location));
                table.cell(1, 0).value(this.totalTicks / (long)this.columns);
                table.column(1).format(TICKS);
                int lastCol = this.rows[0].header(table, rowCount);
                int r = 0;
                while (r < rowCount) {
                    Row row = this.rows[r];
                    table.cell(0, 1 + r).value(ProbingSubMonitor.shorten(row.location));
                    Cell tickCell = table.cell(1, 1 + r);
                    tickCell.value(row.ticks / (long)row.getRuns());
                    Formula.Percent percent = new Formula.Percent(table.column(1, 1), tickCell);
                    table.cell(2, 1 + r).format(PERCENT).value(percent);
                    row.body(table, r + 1);
                    if (row.forkTargets != null) {
                        StringBuilder builder = new StringBuilder();
                        int i = 0;
                        while (i < row.forkTargets.length) {
                            if (builder.length() != 0) {
                                builder.append(", ");
                            }
                            StackTraceElement forkTarget = row.forkTargets[i];
                            builder.append(ProbingSubMonitor.shorten(forkTarget));
                            ++i;
                        }
                        table.cell(lastCol + 1, r + 1).value(builder);
                    }
                    ++r;
                }
                int forkTargetCol = table.bottomRight().col;
                if (forkTargetCol > lastCol) {
                    table.cell(forkTargetCol, 0).value("Fork Targets");
                }
                this.rows[0].footer(table, rowCount);
                System.out.println();
                DUMPER.dump(System.out, (RectangularRange)table, 0, rowCount);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static abstract class Row
        implements Comparable<Row> {
            private final StackTraceElement location;
            private StackTraceElement[] forkTargets;
            private long ticks;

            public Row(StackTraceElement location) {
                this.location = location;
            }

            public void addProbe(Probe probe) {
                if (probe.forkTargets != null) {
                    if (this.forkTargets == null) {
                        this.forkTargets = probe.forkTargets;
                    } else if (this.forkTargets.length != 1 || probe.forkTargets.length != 1 || !this.forkTargets[0].equals(probe.forkTargets[0])) {
                        HashSet<StackTraceElement> set = new HashSet<StackTraceElement>();
                        set.addAll(Arrays.asList(this.forkTargets));
                        set.addAll(Arrays.asList(probe.forkTargets));
                        this.forkTargets = set.toArray(new StackTraceElement[set.size()]);
                    }
                }
                this.ticks += (long)probe.ticks;
                this.addProbe(probe.time);
            }

            public abstract void addProbe(int var1);

            public abstract void skipProbes(int var1);

            public abstract int getRuns();

            public abstract int header(Table var1, int var2);

            public abstract void body(Table var1, int var2);

            public abstract void footer(Table var1, int var2);

            @Override
            public int compareTo(Row o) {
                int result = this.location.getFileName().compareTo(o.location.getFileName());
                if (result == 0) {
                    result = this.location.getLineNumber() - o.location.getLineNumber();
                }
                return result;
            }

            public static Row create(StackTraceElement location, boolean full) {
                return full ? new Full(location) : new Compressed(location);
            }

            private static final class Compressed
            extends Row {
                private int skips;
                private int runs;
                private long sum;
                private int min = Integer.MAX_VALUE;
                private int max = Integer.MIN_VALUE;

                public Compressed(StackTraceElement location) {
                    super(location);
                }

                public void addProbe(int time) {
                    ++this.runs;
                    this.sum += (long)time;
                    this.min = Math.min(this.min, time);
                    this.max = Math.max(this.max, time);
                }

                public void skipProbes(int count) {
                    ++this.skips;
                }

                public int getRuns() {
                    return this.runs;
                }

                public int header(Table table, int rows) {
                    int col = 2;
                    table.cell(++col, 0).value("Skips");
                    table.cell(++col, 0).value("Runs");
                    table.cell(++col, 0).value("Runs %");
                    table.cell(++col, 0).value("Sum");
                    table.cell(++col, 0).value("Min");
                    table.cell(++col, 0).value("Max");
                    table.cell(++col, 0).value("Range");
                    table.cell(++col, 0).value("Average/Runs");
                    table.cell(++col, 0).value("Average%");
                    table.row(0, 1).alignment(Range.Alignment.RIGHT);
                    return col;
                }

                public void body(Table table, int row) {
                    int col = 2;
                    table.cell(++col, row).value(this.skips);
                    Cell runsCell = table.cell(++col, row);
                    runsCell.value(this.runs);
                    Formula.Percent runsPercent = new Formula.Percent(table.range(col - 1, row, col, row), runsCell);
                    table.cell(++col, row).format(PERCENT).value(runsPercent);
                    table.cell(++col, row).format(MILLIS).value(this.sum);
                    table.cell(++col, row).format(MILLIS).value(this.min);
                    table.cell(++col, row).format(MILLIS).value(this.max);
                    table.cell(++col, row).format(MILLIS).value(new Formula(){

                        public Object evaluate() {
                            return Compressed.this.max - Compressed.this.min;
                        }
                    });
                    Cell avgCell = table.cell(++col, row);
                    avgCell.format(MILLIS_PRECISE).value(this.sum / (long)this.runs);
                    Formula.Percent avgPercent = new Formula.Percent(table.column(avgCell.col(), 1), avgCell);
                    table.cell(++col, row).format(PERCENT).value(avgPercent);
                }

                public void footer(Table table, int rows) {
                }
            }

            private static final class Full
            extends Row {
                private static final int SKIPPED = -1;
                private int[] times;

                public Full(StackTraceElement location) {
                    super(location);
                }

                public void addProbe(int time) {
                    if (this.times == null) {
                        this.times = new int[1];
                        this.times[0] = time;
                    } else {
                        int[] newTimes = new int[this.times.length + 1];
                        System.arraycopy(this.times, 0, newTimes, 0, this.times.length);
                        newTimes[this.times.length] = time;
                        this.times = newTimes;
                    }
                }

                public void skipProbes(int count) {
                    if (this.times == null) {
                        this.times = new int[count];
                        Arrays.fill(this.times, -1);
                    } else {
                        int length = this.times.length;
                        int newLength = length + count;
                        int[] newTimes = new int[newLength];
                        System.arraycopy(this.times, 0, newTimes, 0, length);
                        Arrays.fill(newTimes, length, newLength, -1);
                        this.times = newTimes;
                    }
                }

                public int getRuns() {
                    if (this.times == null) {
                        return 0;
                    }
                    int runs = 0;
                    int i = 0;
                    while (i < this.times.length) {
                        if (this.times[i] != -1) {
                            ++runs;
                        }
                        ++i;
                    }
                    return runs;
                }

                public int header(Table table, int rows) {
                    int i = 0;
                    while (i < this.times.length) {
                        Cell timeCell = table.cell(3 + 2 * i, 0);
                        timeCell.alignment(Range.Alignment.RIGHT).value("Run" + (i + 1));
                        ++i;
                    }
                    Cell avgTimeCell = table.cell(3 + 2 * this.times.length, 0);
                    avgTimeCell.alignment(Range.Alignment.RIGHT).value("AVERAGE");
                    return avgTimeCell.col() + 1;
                }

                public void body(Table table, int row) {
                    Cell avgTimeRange = null;
                    int i = 0;
                    while (i < this.times.length) {
                        int time = this.times[i];
                        if (time != -1) {
                            int timeCol = 3 + 2 * i;
                            Cell timeCell = table.cell(timeCol, row);
                            timeCell.format(MILLIS).value(time);
                            Cell ratioCell = timeCell.offset(1, 0);
                            ratioCell.format(PERCENT).value(new Formula.Percent(table.column(timeCol, 1), timeCell));
                            avgTimeRange = avgTimeRange == null ? timeCell : avgTimeRange.addRanges(timeCell);
                        }
                        ++i;
                    }
                    Cell avgTimeCell = table.cell(3 + 2 * this.times.length, row);
                    avgTimeCell.format(MILLIS).value(new Formula.Avg(avgTimeRange));
                    Cell avgRatioCell = avgTimeCell.offset(1, 0);
                    avgRatioCell.format(PERCENT).value(new Formula.Percent(table.column(avgTimeCell.col(), 1), avgTimeCell));
                }

                public void footer(Table table, int rows) {
                    table.cell(0, 1 + rows).value("TOTAL");
                    table.cell(1, 1 + rows).format(TICKS).value(new Formula.Sum(table.column(1, 1, 1)));
                    int i = 0;
                    while (i <= this.times.length) {
                        int timeCol = 3 + 2 * i;
                        Cell sumCell = table.cell(timeCol, 1 + rows);
                        sumCell.format(MILLIS).value(new Formula.Sum(table.column(timeCol, 1, 1)));
                        ++i;
                    }
                }
            }
        }
    }
}

