/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.util.ArrayList;
import org.eclipse.net4j.util.collection.MoveableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveableArrayList<E>
extends ArrayList<E>
implements MoveableList<E> {
    private static final long serialVersionUID = 1L;

    public MoveableArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public void move(int newPosition, Object object) {
        this.move(newPosition, this.indexOf(object));
    }

    @Override
    public E move(int targetIndex, int sourceIndex) {
        int size = this.size();
        if (sourceIndex >= size) {
            throw new IndexOutOfBoundsException("sourceIndex=" + sourceIndex + ", size=" + size);
        }
        if (targetIndex >= size) {
            throw new IndexOutOfBoundsException("targetIndex=" + targetIndex + ", size=" + size);
        }
        Object object = this.get(sourceIndex);
        if (targetIndex == sourceIndex) {
            return object;
        }
        if (targetIndex < sourceIndex) {
            this.moveUp1(targetIndex, sourceIndex - targetIndex);
        } else {
            this.moveDown1(targetIndex, targetIndex - sourceIndex);
        }
        this.set(targetIndex, object);
        return object;
    }

    private void moveUp1(int index, int count) {
        int i = count;
        while (i > 0) {
            this.set(index + i, this.get(index + i - 1));
            --i;
        }
    }

    private void moveDown1(int index, int count) {
        int i = count;
        while (i > 0) {
            this.set(index - i, this.get(index - i + 1));
            --i;
        }
    }
}

