/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.confirmation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.net4j.util.confirmation.Confirmation;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfirmationDialog
extends MessageDialog {
    public ConfirmationDialog(Shell shell, String title, String message, Set<Confirmation> acceptableResponses, Confirmation suggestedResponse) {
        this(shell, title, message, ConfirmationDialog.getButtonLabels(ConfirmationDialog.inOrder(acceptableResponses)), ConfirmationDialog.inOrder(acceptableResponses).indexOf(suggestedResponse));
    }

    private ConfirmationDialog(Shell shell, String title, String message, String[] buttonLabels, int defaultIndex) {
        super(shell, title, null, message, 5, buttonLabels, defaultIndex);
    }

    public static Confirmation openConfirm(Shell shell, String title, String message, Set<Confirmation> acceptableResponses, Confirmation suggestedResponse) {
        int defaultIndex;
        List<Confirmation> inOrder = ConfirmationDialog.inOrder(acceptableResponses);
        String[] buttonLabels = ConfirmationDialog.getButtonLabels(inOrder);
        ConfirmationDialog dialog = new ConfirmationDialog(shell, title, message, buttonLabels, defaultIndex = inOrder.indexOf(suggestedResponse));
        int index = dialog.open();
        return index == -1 ? suggestedResponse : inOrder.get(index);
    }

    private static String[] getButtonLabels(List<Confirmation> acceptableResponses) {
        ArrayList<String> result = new ArrayList<String>(acceptableResponses.size());
        for (Confirmation confirmation : acceptableResponses) {
            result.add(ConfirmationDialog.getLabel(confirmation));
        }
        return result.toArray(new String[result.size()]);
    }

    private static List<Confirmation> inOrder(Collection<Confirmation> confirmations) {
        ArrayList<Confirmation> result = new ArrayList<Confirmation>(confirmations);
        Collections.sort(result);
        return result;
    }

    private static String getLabel(Confirmation confirmation) {
        switch (confirmation) {
            case OK: {
                return IDialogConstants.OK_LABEL;
            }
            case CANCEL: {
                return IDialogConstants.CANCEL_LABEL;
            }
            case YES: {
                return IDialogConstants.YES_LABEL;
            }
            case NO: {
                return IDialogConstants.NO_LABEL;
            }
        }
        throw new IllegalArgumentException(confirmation.name());
    }
}

