/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.spi.editor;

import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.compatibility.CommonColors;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.mylyn.commons.workbench.forms.ScalingHyperlink;
import org.eclipse.mylyn.internal.reviews.ui.ReviewsImages;
import org.eclipse.mylyn.reviews.internal.core.BuildResult;
import org.eclipse.mylyn.reviews.ui.spi.editor.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IServiceLocator;

public class BuildStatusAttributeEditor
extends AbstractAttributeEditor {
    private final IServiceLocator locator;

    public BuildStatusAttributeEditor(TaskDataModel dataModel, IServiceLocator locator, TaskAttribute taskAttribute) {
        super(dataModel, taskAttribute);
        this.locator = locator;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Composite layoutComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().spacing(LayoutConstants.getSpacing().x, 0).numColumns(3).applyTo(layoutComposite);
        GridDataFactory.fillDefaults().indent(28, 0).applyTo((Control)layoutComposite);
        TaskAttribute buildAttribute = this.getTaskAttribute();
        int numberOfBuilds = buildAttribute.getAttributes().size();
        int i = 0;
        while (i < numberOfBuilds) {
            String buildKey = "BUILD_RESULT-" + i;
            TaskAttribute currentBuildAttribute = buildAttribute.getAttribute(buildKey);
            if (currentBuildAttribute == null) {
                return;
            }
            TaskAttribute statusAttribute = currentBuildAttribute.getAttribute("STATUS");
            TaskAttribute urlAttribute = currentBuildAttribute.getAttribute("URL");
            if (statusAttribute == null || urlAttribute == null) {
                return;
            }
            String statusValue = statusAttribute.getValue();
            final String urlValue = urlAttribute.getValue();
            ScalingHyperlink buildLink = new ScalingHyperlink(layoutComposite, 8);
            buildLink.setText(urlValue);
            buildLink.setForeground(CommonColors.HYPERLINK_WIDGET);
            buildLink.registerMouseTrackListener();
            buildLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent event) {
                    BrowserUtil.openUrl((String)urlValue);
                }
            });
            CLabel buildText = new CLabel(layoutComposite, 0);
            this.setControl((Control)layoutComposite);
            buildText.setText(statusValue);
            buildText.setImage(this.getImageForBuildStatus(statusValue));
            ToolBarManager toolBarManager = new ToolBarManager();
            IMenuService menuService = (IMenuService)this.locator.getService(IMenuService.class);
            if (menuService != null) {
                menuService.populateContributionManager((ContributionManager)toolBarManager, "toolbar:org.eclipse.mylyn.build.toolbar");
                toolBarManager.createControl(layoutComposite);
                ToolItem[] toolItemArray = toolBarManager.getControl().getItems();
                int n = toolItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ToolItem item = toolItemArray[n2];
                    item.setData((Object)urlValue);
                    ++n2;
                }
            } else {
                new Label(layoutComposite, 0);
            }
            ++i;
        }
    }

    public void decorateIncoming(Color color) {
        TaskAttribute buildAttribute = this.getTaskAttribute();
        int numberOfBuilds = this.getTaskAttribute().getAttributes().size();
        int i = 0;
        while (i < numberOfBuilds) {
            String buildKey = "BUILD_RESULT-" + i;
            TaskAttribute currentBuildAttribute = buildAttribute.getAttribute(buildKey);
            if (currentBuildAttribute == null) {
                return;
            }
            Composite layoutComposite = (Composite)this.getControl();
            if (this.getModel().hasIncomingChanges(currentBuildAttribute)) {
                layoutComposite.getChildren()[3 * i].setBackground(color);
                layoutComposite.getChildren()[3 * i + 1].setBackground(color);
            }
            ++i;
        }
    }

    public String getLabel() {
        String label = Messages.ReviewSet_BuildHeader;
        return label != null ? LegacyActionTools.escapeMnemonics((String)label) : "";
    }

    private Image getImageForBuildStatus(String status) {
        if (status.equals(BuildResult.BuildStatus.SUCCESS.toString())) {
            return CommonImages.getImage((ImageDescriptor)ReviewsImages.APPROVED);
        }
        if (status.equals(BuildResult.BuildStatus.STARTED.toString())) {
            return CommonImages.getImage((ImageDescriptor)ReviewsImages.UNKNOWN);
        }
        if (status.equals(BuildResult.BuildStatus.UNSTABLE.toString())) {
            return CommonImages.getImage((ImageDescriptor)ReviewsImages.UNSTABLE);
        }
        return CommonImages.getImage((ImageDescriptor)ReviewsImages.REJECTED);
    }
}

