/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.lsp4e.DocumentContentSynchronizer;
import org.eclipse.lsp4e.FileBufferListenerAdapter;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageClientImpl;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LoggingStreamConnectionProviderProxy;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeActionCapabilities;
import org.eclipse.lsp4j.CodeActionKindCapabilities;
import org.eclipse.lsp4j.CodeActionLiteralSupportCapabilities;
import org.eclipse.lsp4j.CodeLensCapabilities;
import org.eclipse.lsp4j.ColorProviderCapabilities;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.eclipse.lsp4j.DefinitionCapabilities;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.DocumentHighlightCapabilities;
import org.eclipse.lsp4j.DocumentLinkCapabilities;
import org.eclipse.lsp4j.DocumentSymbolCapabilities;
import org.eclipse.lsp4j.ExecuteCommandCapabilities;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.FormattingCapabilities;
import org.eclipse.lsp4j.HoverCapabilities;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.RangeFormattingCapabilities;
import org.eclipse.lsp4j.ReferencesCapabilities;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.RenameCapabilities;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelpCapabilities;
import org.eclipse.lsp4j.SymbolCapabilities;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolKindCapabilities;
import org.eclipse.lsp4j.SynchronizationCapabilities;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceEditCapabilities;
import org.eclipse.lsp4j.WorkspaceFoldersChangeEvent;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class LanguageServerWrapper {
    private IFileBufferListener fileBufferListener = new FileBufferListenerAdapter(){

        @Override
        public void bufferDisposed(IFileBuffer buffer) {
            Path filePath = new Path(buffer.getFileStore().toURI().getPath());
            LanguageServerWrapper.this.disconnect((IPath)filePath);
        }

        @Override
        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            if (isDirty) {
                return;
            }
            Path filePath = new Path(buffer.getFileStore().toURI().getPath());
            DocumentContentSynchronizer documentListener = LanguageServerWrapper.this.connectedDocuments.get(filePath);
            if (documentListener != null && documentListener.getModificationStamp() < buffer.getModificationStamp()) {
                documentListener.documentSaved(buffer.getModificationStamp());
            }
        }
    };
    public final @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition;
    protected final @Nullable IProject initialProject;
    protected final @NonNull Set<@NonNull IProject> allWatchedProjects;
    protected @NonNull Map<@NonNull IPath, @NonNull DocumentContentSynchronizer> connectedDocuments;
    protected StreamConnectionProvider lspStreamProvider;
    private Future<?> launcherFuture;
    private CompletableFuture<Void> initializeFuture;
    private LanguageServer languageServer;
    private ServerCapabilities serverCapabilities;
    private @NonNull Map<@NonNull String, @NonNull Runnable> dynamicRegistrations = new HashMap<String, Runnable>();
    private boolean initiallySupportsWorkspaceFolders = false;

    public LanguageServerWrapper(@Nullable IProject project, @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition) {
        this.initialProject = project;
        this.allWatchedProjects = new HashSet<IProject>();
        this.serverDefinition = serverDefinition;
        this.connectedDocuments = new HashMap<IPath, DocumentContentSynchronizer>();
    }

    public synchronized void start() throws IOException {
        Map<IPath, IDocument> filesToReconnect = Collections.emptyMap();
        if (this.languageServer != null) {
            if (this.isActive()) {
                return;
            }
            filesToReconnect = new HashMap();
            for (Map.Entry<IPath, DocumentContentSynchronizer> entry : this.connectedDocuments.entrySet()) {
                filesToReconnect.put(entry.getKey(), entry.getValue().getDocument());
            }
            this.stop();
        }
        try {
            this.lspStreamProvider = LoggingStreamConnectionProviderProxy.shouldLog(this.serverDefinition.id) ? new LoggingStreamConnectionProviderProxy(this.serverDefinition.createConnectionProvider(), this.serverDefinition.id) : this.serverDefinition.createConnectionProvider();
            this.lspStreamProvider.start();
            LanguageClientImpl client = this.serverDefinition.createLanguageClient();
            ExecutorService executorService = Executors.newCachedThreadPool();
            InitializeParams initParams = new InitializeParams();
            initParams.setProcessId(this.getCurrentProcessId());
            URI rootURI = null;
            IProject project = this.initialProject;
            if (project != null && project.exists()) {
                rootURI = LSPEclipseUtils.toUri((IResource)this.initialProject);
                initParams.setRootUri(rootURI.toString());
                initParams.setRootPath(rootURI.getPath());
            } else {
                initParams.setRootUri(LSPEclipseUtils.toUri(new File("/")).toString());
            }
            Launcher launcher = Launcher.createLauncher((Object)client, this.serverDefinition.getServerInterface(), (InputStream)this.lspStreamProvider.getInputStream(), (OutputStream)this.lspStreamProvider.getOutputStream(), (ExecutorService)executorService, consumer -> message -> {
                consumer.consume(message);
                this.logMessage(message);
                URI root = initParams.getRootUri() != null ? URI.create(initParams.getRootUri()) : null;
                this.lspStreamProvider.handleMessage(message, this.languageServer, root);
            });
            this.languageServer = (LanguageServer)launcher.getRemoteProxy();
            client.connect(this.languageServer, this);
            this.launcherFuture = launcher.startListening();
            String name = "Eclipse IDE";
            if (Platform.getProduct() != null) {
                name = Platform.getProduct().getName();
            }
            WorkspaceClientCapabilities workspaceClientCapabilities = new WorkspaceClientCapabilities();
            workspaceClientCapabilities.setApplyEdit(Boolean.TRUE);
            workspaceClientCapabilities.setExecuteCommand(new ExecuteCommandCapabilities(Boolean.TRUE));
            workspaceClientCapabilities.setSymbol(new SymbolCapabilities());
            workspaceClientCapabilities.setWorkspaceFolders(Boolean.TRUE);
            WorkspaceEditCapabilities editCapabilities = new WorkspaceEditCapabilities();
            editCapabilities.setDocumentChanges(Boolean.TRUE);
            editCapabilities.setResourceOperations(Arrays.asList("create", "delete", "rename"));
            editCapabilities.setFailureHandling("undo");
            workspaceClientCapabilities.setWorkspaceEdit(editCapabilities);
            TextDocumentClientCapabilities textDocumentClientCapabilities = new TextDocumentClientCapabilities();
            textDocumentClientCapabilities.setCodeAction(new CodeActionCapabilities(new CodeActionLiteralSupportCapabilities(new CodeActionKindCapabilities(Arrays.asList("quickfix", "refactor", "refactor.extract", "refactor.inline", "refactor.rewrite", "source", "source.organizeImports"))), Boolean.valueOf(true)));
            textDocumentClientCapabilities.setCodeLens(new CodeLensCapabilities());
            textDocumentClientCapabilities.setColorProvider(new ColorProviderCapabilities());
            textDocumentClientCapabilities.setCompletion(new CompletionCapabilities(new CompletionItemCapabilities(Boolean.TRUE)));
            textDocumentClientCapabilities.setDefinition(new DefinitionCapabilities());
            textDocumentClientCapabilities.setDocumentHighlight(new DocumentHighlightCapabilities());
            textDocumentClientCapabilities.setDocumentLink(new DocumentLinkCapabilities());
            DocumentSymbolCapabilities documentSymbol = new DocumentSymbolCapabilities();
            documentSymbol.setHierarchicalDocumentSymbolSupport(Boolean.valueOf(true));
            documentSymbol.setSymbolKind(new SymbolKindCapabilities(Arrays.asList(SymbolKind.Array, SymbolKind.Boolean, SymbolKind.Class, SymbolKind.Constant, SymbolKind.Constructor, SymbolKind.Enum, SymbolKind.EnumMember, SymbolKind.Event, SymbolKind.Field, SymbolKind.File, SymbolKind.Function, SymbolKind.Interface, SymbolKind.Key, SymbolKind.Method, SymbolKind.Module, SymbolKind.Namespace, SymbolKind.Null, SymbolKind.Number, SymbolKind.Object, SymbolKind.Operator, SymbolKind.Package, SymbolKind.Property, SymbolKind.String, SymbolKind.Struct, SymbolKind.TypeParameter, SymbolKind.Variable)));
            textDocumentClientCapabilities.setDocumentSymbol(documentSymbol);
            textDocumentClientCapabilities.setFormatting(new FormattingCapabilities());
            textDocumentClientCapabilities.setHover(new HoverCapabilities());
            textDocumentClientCapabilities.setOnTypeFormatting(null);
            textDocumentClientCapabilities.setRangeFormatting(new RangeFormattingCapabilities());
            textDocumentClientCapabilities.setReferences(new ReferencesCapabilities());
            textDocumentClientCapabilities.setRename(new RenameCapabilities());
            textDocumentClientCapabilities.setSignatureHelp(new SignatureHelpCapabilities());
            textDocumentClientCapabilities.setSynchronization(new SynchronizationCapabilities(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE));
            initParams.setCapabilities(new ClientCapabilities(workspaceClientCapabilities, textDocumentClientCapabilities, null));
            initParams.setClientName(name);
            initParams.setInitializationOptions(this.lspStreamProvider.getInitializationOptions(rootURI));
            initParams.setTrace(this.lspStreamProvider.getTrace(rootURI));
            this.initializeFuture = ((CompletableFuture)this.languageServer.initialize(initParams).thenAccept(res -> {
                this.serverCapabilities = res.getCapabilities();
                this.initiallySupportsWorkspaceFolders = LanguageServerWrapper.supportsWorkspaceFolders(this.serverCapabilities);
            })).thenRun(() -> this.languageServer.initialized(new InitializedParams()));
            Map<IPath, IDocument> toReconnect = filesToReconnect;
            this.initializeFuture.thenRunAsync(() -> {
                if (this.initialProject != null) {
                    this.watchProject(this.initialProject, true);
                }
                for (Map.Entry fileToReconnect : toReconnect.entrySet()) {
                    try {
                        this.connect((IPath)fileToReconnect.getKey(), (IDocument)fileToReconnect.getValue());
                    }
                    catch (IOException e) {
                        LanguageServerPlugin.logError(e);
                    }
                }
            });
            FileBuffers.getTextFileBufferManager().addFileBufferListener(this.fileBufferListener);
        }
        catch (Exception ex) {
            LanguageServerPlugin.logError(ex);
            this.stop();
        }
    }

    private static boolean supportsWorkspaceFolders(ServerCapabilities serverCapabilities) {
        return serverCapabilities != null && serverCapabilities.getWorkspace() != null && serverCapabilities.getWorkspace().getWorkspaceFolders() != null && Boolean.TRUE.equals(serverCapabilities.getWorkspace().getWorkspaceFolders().getSupported());
    }

    private Integer getCurrentProcessId() {
        String segment = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        try {
            return Integer.valueOf(segment);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private void logMessage(Message message) {
        if (message instanceof ResponseMessage && ((ResponseMessage)message).getError() != null && ((ResponseMessage)message).getId().equals(Integer.toString(ResponseErrorCode.RequestCancelled.getValue()))) {
            ResponseMessage responseMessage = (ResponseMessage)message;
            LanguageServerPlugin.logError((Throwable)new ResponseErrorException(responseMessage.getError()));
        } else if (LanguageServerPlugin.DEBUG) {
            LanguageServerPlugin.logInfo(String.valueOf(message.getClass().getSimpleName()) + '\n' + message.toString());
        }
    }

    public boolean isActive() {
        return this.launcherFuture != null && !this.launcherFuture.isDone() && !this.launcherFuture.isCancelled();
    }

    synchronized void stop() {
        if (this.initializeFuture != null) {
            this.initializeFuture.cancel(true);
            this.initializeFuture = null;
        }
        this.serverCapabilities = null;
        this.dynamicRegistrations.clear();
        Future<?> serverFuture = this.launcherFuture;
        StreamConnectionProvider provider = this.lspStreamProvider;
        Runnable stopFutureAndProvider = () -> {
            if (serverFuture != null) {
                serverFuture.cancel(true);
            }
            if (provider != null) {
                provider.stop();
            }
        };
        if (this.languageServer != null) {
            CompletableFuture shutdown = this.languageServer.shutdown();
            shutdown.thenRun(stopFutureAndProvider);
            shutdown.exceptionally(t -> {
                stopFutureAndProvider.run();
                return null;
            });
        } else {
            stopFutureAndProvider.run();
        }
        this.launcherFuture = null;
        this.lspStreamProvider = null;
        while (!this.connectedDocuments.isEmpty()) {
            this.disconnect(this.connectedDocuments.keySet().iterator().next());
        }
        this.languageServer = null;
        FileBuffers.getTextFileBufferManager().removeFileBufferListener(this.fileBufferListener);
    }

    public void connect(@NonNull IFile file, IDocument document) throws IOException {
        this.connect(file.getLocation(), document);
    }

    public void connect(IDocument document) throws IOException {
        IFile file = LSPEclipseUtils.getFile(document);
        if (file != null && file.exists()) {
            this.connect(file, document);
        } else {
            this.connect((IPath)new Path(LSPEclipseUtils.toUri(document).getPath()), document);
        }
    }

    protected synchronized void watchProject(IProject project, boolean isInitializationRootProject) {
        if (this.allWatchedProjects.contains(project)) {
            return;
        }
        if (isInitializationRootProject && !this.allWatchedProjects.isEmpty()) {
            return;
        }
        if (!isInitializationRootProject && !this.supportsWorkspaceFolderCapability()) {
            return;
        }
        this.allWatchedProjects.add(project);
        project.getWorkspace().addResourceChangeListener(event -> {
            if (project.equals((Object)event.getResource()) && (event.getDelta().getKind() == 4096 || event.getDelta().getKind() == 2)) {
                this.unwatchProject(project);
            }
        }, 1);
        if (this.supportsWorkspaceFolderCapability()) {
            WorkspaceFoldersChangeEvent event2 = new WorkspaceFoldersChangeEvent();
            event2.getAdded().add(LSPEclipseUtils.toWorkspaceFolder(project));
            DidChangeWorkspaceFoldersParams params = new DidChangeWorkspaceFoldersParams();
            params.setEvent(event2);
            this.languageServer.getWorkspaceService().didChangeWorkspaceFolders(params);
        }
    }

    private synchronized void unwatchProject(@NonNull IProject project) {
        this.allWatchedProjects.remove(project);
        if (this.supportsWorkspaceFolderCapability()) {
            WorkspaceFoldersChangeEvent event = new WorkspaceFoldersChangeEvent();
            event.getRemoved().add(LSPEclipseUtils.toWorkspaceFolder(project));
            DidChangeWorkspaceFoldersParams params = new DidChangeWorkspaceFoldersParams();
            params.setEvent(event);
            this.languageServer.getWorkspaceService().didChangeWorkspaceFolders(params);
        }
    }

    public boolean canOperate(IProject project) {
        if (project.equals((Object)this.initialProject) || this.allWatchedProjects.contains(project)) {
            return true;
        }
        return this.serverDefinition.isSingleton || this.supportsWorkspaceFolderCapability();
    }

    private boolean supportsWorkspaceFolderCapability() {
        if (this.initializeFuture != null) {
            try {
                this.initializeFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (ExecutionException | TimeoutException e) {
                LanguageServerPlugin.logError(e);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
            }
        }
        return this.initiallySupportsWorkspaceFolders || LanguageServerWrapper.supportsWorkspaceFolders(this.serverCapabilities);
    }

    private void connect(@NonNull IPath absolutePath, IDocument document) throws IOException {
        IPath thePath = Path.fromOSString((String)absolutePath.toFile().getAbsolutePath());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(thePath);
        if (file.exists()) {
            this.watchProject(file.getProject(), false);
        }
        if (this.connectedDocuments.containsKey(thePath)) {
            return;
        }
        this.start();
        if (this.initializeFuture == null) {
            return;
        }
        if (document == null) {
            IFile docFile = (IFile)LSPEclipseUtils.findResourceFor(thePath.toFile().toURI().toString());
            document = LSPEclipseUtils.getDocument((IResource)docFile);
        }
        if (document == null) {
            return;
        }
        IDocument theDocument = document;
        this.initializeFuture.thenRunAsync(() -> {
            Map<IPath, DocumentContentSynchronizer> map = this.connectedDocuments;
            synchronized (map) {
                if (this.connectedDocuments.containsKey(thePath)) {
                    return;
                }
                Either syncOptions = this.initializeFuture == null ? null : this.serverCapabilities.getTextDocumentSync();
                TextDocumentSyncKind syncKind = null;
                if (syncOptions != null) {
                    if (syncOptions.isRight()) {
                        syncKind = ((TextDocumentSyncOptions)syncOptions.getRight()).getChange();
                    } else if (syncOptions.isLeft()) {
                        syncKind = (TextDocumentSyncKind)syncOptions.getLeft();
                    }
                }
                DocumentContentSynchronizer listener = new DocumentContentSynchronizer(this, theDocument, syncKind);
                theDocument.addDocumentListener((IDocumentListener)listener);
                this.connectedDocuments.put(thePath, listener);
            }
        });
    }

    public void disconnect(IPath path) {
        DocumentContentSynchronizer documentListener = this.connectedDocuments.remove(path);
        if (documentListener != null) {
            documentListener.getDocument().removeDocumentListener((IDocumentListener)documentListener);
            documentListener.documentClosed();
        }
        if (this.connectedDocuments.isEmpty()) {
            this.stop();
        }
    }

    public void disconnectContentType(@NonNull IContentType contentType) {
        ArrayList<IPath> pathsToDisconnect = new ArrayList<IPath>();
        for (IPath path : this.connectedDocuments.keySet()) {
            IFile[] foundFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(path.toFile().toURI());
            if (foundFiles.length == 0) continue;
            if (!LSPEclipseUtils.getFileContentTypes(foundFiles[0]).stream().anyMatch(contentType::equals)) continue;
            pathsToDisconnect.add(path);
        }
        for (IPath path : pathsToDisconnect) {
            this.disconnect(path);
        }
    }

    public boolean isConnectedTo(IPath location) {
        return this.connectedDocuments.containsKey(location);
    }

    @Deprecated
    public @Nullable LanguageServer getServer() {
        CompletableFuture<LanguageServer> languagServerFuture = this.getInitializedServer();
        if (Display.getCurrent() != null) {
            return this.languageServer;
        }
        return languagServerFuture.join();
    }

    public @NonNull CompletableFuture<LanguageServer> getInitializedServer() {
        try {
            this.start();
        }
        catch (IOException ex) {
            LanguageServerPlugin.logError(ex);
        }
        if (this.initializeFuture != null && !this.initializeFuture.isDone()) {
            if (Display.getCurrent() != null) {
                Job waitForInitialization = new Job(Messages.initializeLanguageServer_job){

                    protected IStatus run(IProgressMonitor monitor) {
                        LanguageServerWrapper.this.initializeFuture.join();
                        return Status.OK_STATUS;
                    }
                };
                waitForInitialization.setUser(true);
                waitForInitialization.setSystem(false);
                PlatformUI.getWorkbench().getProgressService().showInDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), waitForInitialization);
            }
            return this.initializeFuture.thenApply(r -> this.languageServer);
        }
        return CompletableFuture.completedFuture(this.languageServer);
    }

    public @Nullable ServerCapabilities getServerCapabilities() {
        try {
            this.getInitializedServer().get(10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            LanguageServerPlugin.logError("LanguageServer not initialized after 10s", e);
        }
        catch (ExecutionException e) {
            LanguageServerPlugin.logError(e);
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
        }
        return this.serverCapabilities;
    }

    public @Nullable String getLanguageId(IContentType[] contentTypes) {
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            String languageId = this.serverDefinition.langugeIdMappings.get(contentType);
            if (languageId != null) {
                return languageId;
            }
            ++n2;
        }
        return null;
    }

    void registerCapability(RegistrationParams params) {
        params.getRegistrations().forEach(reg -> {
            Gson gson;
            ExecuteCommandOptions executeCommandOptions;
            List newCommands;
            if ("workspace/didChangeWorkspaceFolders".equals(reg.getMethod())) {
                Assert.isNotNull((Object)this.serverCapabilities, (String)"Dynamic capability registration failed! Server not yet initialized?");
                if (!this.initiallySupportsWorkspaceFolders) {
                    if (LanguageServerWrapper.supportsWorkspaceFolders(this.serverCapabilities)) {
                        LanguageServerPlugin.logWarning("Dynamic registration of 'workspace/didChangeWorkspaceFolders' ignored. It was already enabled before", null);
                    } else {
                        this.addRegistration((Registration)reg, () -> this.setWorkspaceFoldersEnablement(false));
                        this.setWorkspaceFoldersEnablement(true);
                    }
                }
            } else if ("workspace/executeCommand".equals(reg.getMethod()) && !(newCommands = (executeCommandOptions = (ExecuteCommandOptions)(gson = new Gson()).fromJson((JsonElement)((JsonObject)reg.getRegisterOptions()), ExecuteCommandOptions.class)).getCommands()).isEmpty()) {
                this.addRegistration((Registration)reg, () -> this.unregisterCommands(newCommands));
                this.registerCommands(newCommands);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRegistration(@NonNull Registration reg, @NonNull Runnable unregistrationHandler) {
        String regId = reg.getId();
        Map<String, Runnable> map = this.dynamicRegistrations;
        synchronized (map) {
            Assert.isLegal((!this.dynamicRegistrations.containsKey(regId) ? 1 : 0) != 0, (String)"Registration id is not unique");
            this.dynamicRegistrations.put(regId, unregistrationHandler);
        }
    }

    synchronized void setWorkspaceFoldersEnablement(boolean enable) {
        WorkspaceFoldersOptions folders;
        WorkspaceServerCapabilities workspace;
        if (this.serverCapabilities == null) {
            this.serverCapabilities = new ServerCapabilities();
        }
        if ((workspace = this.serverCapabilities.getWorkspace()) == null) {
            workspace = new WorkspaceServerCapabilities();
            this.serverCapabilities.setWorkspace(workspace);
        }
        if ((folders = workspace.getWorkspaceFolders()) == null) {
            folders = new WorkspaceFoldersOptions();
            workspace.setWorkspaceFolders(folders);
        }
        folders.setSupported(Boolean.valueOf(enable));
    }

    synchronized void registerCommands(List<String> newCommands) {
        ServerCapabilities caps = this.getServerCapabilities();
        if (caps != null) {
            ExecuteCommandOptions commandProvider = caps.getExecuteCommandProvider();
            if (commandProvider == null) {
                commandProvider = new ExecuteCommandOptions(new ArrayList());
                caps.setExecuteCommandProvider(commandProvider);
            }
            List existingCommands = commandProvider.getCommands();
            for (String newCmd : newCommands) {
                Assert.isLegal((!existingCommands.contains(newCmd) ? 1 : 0) != 0, (String)("Command already registered '" + newCmd + "'"));
                existingCommands.add(newCmd);
            }
        } else {
            throw new IllegalStateException("Dynamic command registration failed! Server not yet initialized?");
        }
    }

    void unregisterCapability(UnregistrationParams params) {
        params.getUnregisterations().forEach(reg -> {
            Runnable unregistrator;
            String id = reg.getId();
            Map<String, Runnable> map = this.dynamicRegistrations;
            synchronized (map) {
                unregistrator = this.dynamicRegistrations.get(id);
                this.dynamicRegistrations.remove(id);
            }
            if (unregistrator != null) {
                unregistrator.run();
            }
        });
    }

    void unregisterCommands(List<String> cmds) {
        ExecuteCommandOptions commandProvider;
        ServerCapabilities caps = this.getServerCapabilities();
        if (caps != null && (commandProvider = caps.getExecuteCommandProvider()) != null) {
            List existingCommands = commandProvider.getCommands();
            existingCommands.removeAll(cmds);
        }
    }

    int getVersion(IFile file) {
        DocumentContentSynchronizer documentContentSynchronizer;
        if (file != null && file.getLocation() != null && (documentContentSynchronizer = this.connectedDocuments.get(file.getLocation())) != null) {
            return documentContentSynchronizer.getVersion();
        }
        return -1;
    }

    public boolean canOperate(@NonNull IDocument document) {
        if (this.isConnectedTo((IPath)new Path(LSPEclipseUtils.toUri(document).getPath()))) {
            return true;
        }
        if (this.initialProject == null && this.connectedDocuments.isEmpty()) {
            return true;
        }
        IFile file = LSPEclipseUtils.getFile(document);
        if (file != null && file.exists() && this.canOperate(file.getProject())) {
            return true;
        }
        return this.serverDefinition.isSingleton || this.supportsWorkspaceFolderCapability();
    }
}

