/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.opt;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.CmdLineParser;
import org.eclipse.jgit.revwalk.RevTree;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Localizable;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class RevTreeHandler
extends OptionHandler<RevTree> {
    private final CmdLineParser clp;

    public RevTreeHandler(org.kohsuke.args4j.CmdLineParser parser, OptionDef option, Setter<? super RevTree> setter) {
        super(parser, option, setter);
        this.clp = (CmdLineParser)parser;
    }

    public int parseArguments(Parameters params) throws CmdLineException {
        RevTree c;
        ObjectId id;
        String name = params.getParameter(0);
        try {
            id = this.clp.getRepository().resolve(name);
        }
        catch (IOException e) {
            throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)this.clp, (Localizable)CLIText.format(e.getMessage()), new String[0]);
        }
        if (id == null) {
            throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)this.clp, (Localizable)CLIText.format(CLIText.get().notATree), new String[]{name});
        }
        try {
            c = this.clp.getRevWalk().parseTree((AnyObjectId)id);
        }
        catch (IncorrectObjectTypeException | MissingObjectException e) {
            throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)this.clp, (Localizable)CLIText.format(CLIText.get().notATree), new String[]{name});
        }
        catch (IOException e) {
            throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)this.clp, (Localizable)CLIText.format(CLIText.get().cannotReadBecause), new String[]{name, e.getMessage()});
        }
        this.setter.addValue((Object)c);
        return 1;
    }

    public String getDefaultMetaVariable() {
        return CLIText.get().metaVar_treeish;
    }
}

