/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.snippeteditor;

import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetEditor;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetMessages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.JavaParameterListValidator;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.text.java.AbstractProposalSorter;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.widgets.Shell;

public class JavaSnippetCompletionProcessor
implements IContentAssistProcessor {
    private CompletionProposalCollector fCollector;
    private JavaSnippetEditor fEditor;
    private IContextInformationValidator fValidator;
    private TemplateEngine fTemplateEngine;
    private CompletionProposalComparator fComparator;
    private String fErrorMessage;
    private char[] fProposalAutoActivationSet;
    private ContentAssistant fAssistant;

    public JavaSnippetCompletionProcessor(JavaSnippetEditor editor) {
        this.fEditor = editor;
        TemplateContextType contextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("java");
        if (contextType != null) {
            this.fTemplateEngine = new TemplateEngine(contextType);
        }
        this.fComparator = new CompletionProposalComparator();
    }

    public void setContentAssistant(ContentAssistant assistant) {
        this.fAssistant = assistant;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    protected void setErrorMessage(String message) {
        if (message != null && message.length() == 0) {
            message = null;
        }
        this.fErrorMessage = message;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new JavaParameterListValidator();
        }
        return this.fValidator;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int position) {
        try {
            this.setErrorMessage(null);
            try {
                this.fCollector = new CompletionProposalCollector(this.fEditor.getJavaProject());
                this.fEditor.codeComplete((CompletionRequestor)this.fCollector);
            }
            catch (JavaModelException x) {
                Shell shell = viewer.getTextWidget().getShell();
                ErrorDialog.openError((Shell)shell, (String)SnippetMessages.getString("CompletionProcessor.errorTitle"), (String)SnippetMessages.getString("CompletionProcessor.errorMessage"), (IStatus)x.getStatus());
                JDIDebugUIPlugin.log(x);
            }
            IJavaCompletionProposal[] results = this.fCollector.getJavaCompletionProposals();
            if (this.fTemplateEngine != null) {
                this.fTemplateEngine.reset();
                this.fTemplateEngine.complete(viewer, position, null);
                TemplateProposal[] templateResults = this.fTemplateEngine.getResults();
                IJavaCompletionProposal[] total = new IJavaCompletionProposal[results.length + templateResults.length];
                System.arraycopy(templateResults, 0, total, 0, templateResults.length);
                System.arraycopy(results, 0, total, templateResults.length, results.length);
                results = total;
            }
            ICompletionProposal[] iCompletionProposalArray = this.order(results);
            return iCompletionProposalArray;
        }
        finally {
            this.setErrorMessage(this.fCollector.getErrorMessage());
            this.fCollector = null;
        }
    }

    private ICompletionProposal[] order(IJavaCompletionProposal[] proposals) {
        if (this.fAssistant == null) {
            Arrays.sort(proposals, this.fComparator);
            return proposals;
        }
        this.fAssistant.setSorter((ICompletionProposalSorter)new AbstractProposalSorter(){

            public int compare(ICompletionProposal p1, ICompletionProposal p2) {
                return JavaSnippetCompletionProcessor.this.fComparator.compare(p1, p2);
            }
        });
        return proposals;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }
}

