/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Formats;

class ProjectsFormat
extends Format {
    private final Map<String, String> args;

    ProjectsFormat(Map<String, String> args) {
        this.args = args;
    }

    /*
     * Exception decompiling
     */
    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl35 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl35 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private StringBuffer handleMedium(StringBuffer sb, Collection<IServerDescriptor> servers) {
        int size = servers.size();
        switch (size) {
            case 0: {
                return sb.append(Messages.FORMATTING_ZERO_PROJECTS);
            }
            case 1: {
                return sb.append(((IServerDescriptor)Iterables.get(servers, (int)0)).getName());
            }
        }
        sb.append(((IServerDescriptor)Iterables.get(servers, (int)0)).getName());
        return sb.append(Formats.format(Messages.FORMATTING_MORE_PROJECTS, size - 1));
    }

    private StringBuffer handleLong(StringBuffer sb, Collection<IServerDescriptor> servers) {
        int size = servers.size();
        if (size == 1) {
            return sb.append(((IServerDescriptor)Iterables.get(servers, (int)0)).getName());
        }
        LinkedList cp = Lists.newLinkedList(servers);
        sb.append(Joiner.on((String)Messages.FORMATTING_LIST_SEPARATOR).join(cp.subList(0, size - 2)));
        return sb.append(Messages.FORMATTING_LIST_SEPARATOR_LAST).append(((IServerDescriptor)Iterables.getLast((Iterable)cp)).getName());
    }

    private StringBuffer handleNumbers(StringBuffer toAppendTo, Collection<IServerDescriptor> servers) {
        switch (servers.size()) {
            case 0: {
                return toAppendTo.append(Messages.FORMATTING_ZERO_PROJECTS);
            }
            case 1: {
                return toAppendTo.append(Messages.FORMATTING_ONE_PROJECT);
            }
            case 2: {
                return toAppendTo.append(Messages.FORMATTING_TWO_PROJECTS);
            }
            case 3: {
                return toAppendTo.append(Messages.FORMATTING_THREE_PROJECTS);
            }
        }
        return toAppendTo.append(Formats.format(Messages.FORMATTING_X_PROJECTS, servers.size()));
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }
}

