/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.controller;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Versions;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.ESCloseableIterable;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevertCommitController
extends ServerCall<Void> {
    private final PrimaryVersionSpec versionSpec;
    private final boolean headRevert;
    private final String checkedoutCopyName;

    public RevertCommitController(ProjectSpace projectSpace, PrimaryVersionSpec versionSpec, boolean headRevert, String checkedoutCopyName) {
        super(projectSpace);
        this.versionSpec = versionSpec;
        this.headRevert = headRevert;
        this.checkedoutCopyName = checkedoutCopyName;
    }

    private void checkoutHeadAndReverseCommit(ProjectSpace projectSpace, PrimaryVersionSpec baseVersion, boolean headRevert) throws ESException {
        PrimaryVersionSpec localHead = this.getConnectionManager().resolveVersionSpec(projectSpace.getUsersession().getSessionId(), projectSpace.getProjectId(), (VersionSpec)Versions.createHEAD((VersionSpec)baseVersion));
        ESLocalProjectImpl revertSpace = ((ESLocalProjectImpl)projectSpace.toAPI()).getRemoteProject().checkout(this.checkedoutCopyName, (ESUsersession)projectSpace.getUsersession().toAPI(), this.getProgressMonitor());
        List<AbstractChangePackage> changes = ((ProjectSpace)revertSpace.toInternalAPI()).getChanges((VersionSpec)baseVersion, (VersionSpec)(headRevert ? localHead : (PrimaryVersionSpec)ModelUtil.clone((EObject)baseVersion)));
        Collections.reverse(changes);
        Project project = ((ProjectSpace)revertSpace.toInternalAPI()).getProject();
        for (AbstractChangePackage changePackage : changes) {
            ESCloseableIterable reversedOperations = changePackage.reversedOperations();
            try {
                for (AbstractOperation reversedOperation : reversedOperations.iterable()) {
                    try {
                        reversedOperation.reverse().apply((IdEObjectCollection)project);
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
            finally {
                reversedOperations.close();
            }
        }
    }

    @Override
    protected Void run() throws ESException {
        return RunESCommand.WithException.runWithResult(ESException.class, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                RevertCommitController.this.checkoutHeadAndReverseCommit(RevertCommitController.this.getProjectSpace(), RevertCommitController.this.versionSpec, RevertCommitController.this.headRevert);
                return null;
            }
        });
    }
}

