/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.common;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.emfstore.client.ui.ESClassFilter;
import org.eclipse.emf.emfstore.client.ui.ESWhitelistFilter;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.FeatureOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.UnkownFeatureException;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.OperationUtil;

public final class EClassFilter {
    private static final String POINT_ID = "org.eclipse.emf.emfstore.client.ui.filteredTypes";
    private static final String FILTERED_TYPES_ATTRIBUTE = "filteredTypes";
    public static final EClassFilter INSTANCE = new EClassFilter();
    private final Set<EClass> filteredEClasses = new LinkedHashSet<EClass>();
    private final Map<EClass, Collection<EStructuralFeature>> whitelist = new LinkedHashMap<EClass, Collection<EStructuralFeature>>();
    private String filterLabel;

    EClassFilter() {
        this.initFilteredEClasses();
    }

    private void initFilteredEClasses() {
        ESExtensionPoint extensionPoint = new ESExtensionPoint(POINT_ID);
        if (extensionPoint.size() == 0) {
            return;
        }
        for (ESExtensionElement element : extensionPoint.getExtensionElements()) {
            ESClassFilter filter = (ESClassFilter)element.getClass(FILTERED_TYPES_ATTRIBUTE, ESClassFilter.class);
            this.registerFilter(filter);
            if (this.filterLabel != null) continue;
            this.filterLabel = filter.getLabel();
        }
    }

    void registerFilter(ESClassFilter filter) {
        if (filter != null) {
            this.filteredEClasses.addAll(filter.getFilteredEClasses());
        }
        if (ESWhitelistFilter.class.isInstance(filter)) {
            for (Map.Entry<EClass, Collection<EStructuralFeature>> entry : ((ESWhitelistFilter)ESWhitelistFilter.class.cast(filter)).getNonFilteredFeaturesForEClass().entrySet()) {
                if (!this.whitelist.containsKey(entry.getKey())) {
                    this.whitelist.put(entry.getKey(), new LinkedHashSet());
                }
                this.whitelist.get(entry.getKey()).addAll(entry.getValue());
            }
        }
    }

    public boolean isEnabled() {
        return this.filteredEClasses.size() > 0;
    }

    public boolean isFilteredEClass(EClass eClass) {
        return this.filteredEClasses.contains(eClass);
    }

    public boolean isFiltered(EClass eClass, EStructuralFeature feature) {
        if (!this.isFilteredEClass(eClass)) {
            return false;
        }
        if (!this.whitelist.containsKey(eClass)) {
            return true;
        }
        return !this.whitelist.get(eClass).contains(feature);
    }

    public boolean involvesOnlyFilteredEClasses(ModelElementIdToEObjectMapping idToEObjectMapping, AbstractOperation operation) {
        if (OperationUtil.isComposite((AbstractOperation)operation)) {
            return this.compositeOperationInvolvesOnlyFilteredEClasses(idToEObjectMapping, operation);
        }
        if (OperationUtil.isCreateDelete((AbstractOperation)operation)) {
            return this.createDeleteOperationInvolvesOnlyFilteredEClasses(idToEObjectMapping, operation);
        }
        ModelElementId id = operation.getModelElementId();
        EObject modelElement = idToEObjectMapping.get((Object)id);
        if (modelElement == null) {
            return false;
        }
        if (!this.isFilteredEClass(modelElement.eClass())) {
            return false;
        }
        if (OperationUtil.isFeature((AbstractOperation)operation)) {
            try {
                EStructuralFeature feature = ((FeatureOperation)FeatureOperation.class.cast(operation)).getFeature(modelElement);
                return this.isFiltered(modelElement.eClass(), feature);
            }
            catch (UnkownFeatureException ex) {
                ModelUtil.log((String)MessageFormat.format("{0} could not access feature of a feature operation", this.getClass().getName()), (Throwable)ex, (int)2);
                return true;
            }
        }
        return true;
    }

    private boolean createDeleteOperationInvolvesOnlyFilteredEClasses(ModelElementIdToEObjectMapping idToEObjectMapping, AbstractOperation operation) {
        CreateDeleteOperation createDeleteOperation = (CreateDeleteOperation)operation;
        for (EObject modelElement : createDeleteOperation.getEObjectToIdMap().keySet()) {
            if (modelElement != null && !this.isFilteredEClass(modelElement.eClass())) {
                return false;
            }
            if (modelElement != null) continue;
            return false;
        }
        for (AbstractOperation op : createDeleteOperation.getSubOperations()) {
            if (this.involvesOnlyFilteredEClasses(idToEObjectMapping, op)) continue;
            return false;
        }
        return true;
    }

    private boolean compositeOperationInvolvesOnlyFilteredEClasses(ModelElementIdToEObjectMapping idToEObjectMapping, AbstractOperation operation) {
        CompositeOperation composite = (CompositeOperation)operation;
        for (AbstractOperation op : composite.getSubOperations()) {
            if (this.involvesOnlyFilteredEClasses(idToEObjectMapping, op)) continue;
            return false;
        }
        return true;
    }

    public String getFilterLabel() {
        return this.filterLabel;
    }
}

