/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.ui.synchronize.ModelOperation;
import org.eclipse.ui.IWorkbenchPart;

public class GitScopeOperation
extends ModelOperation {
    public GitScopeOperation(IWorkbenchPart part, ISynchronizationScopeManager manager) {
        super(part, manager);
    }

    protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
    }

    List<IResource> getRelevantResources() {
        ResourceTraversal[] traversals;
        ArrayList<IResource> resourcesInScope = new ArrayList<IResource>();
        ResourceTraversal[] resourceTraversalArray = traversals = this.getScope().getTraversals();
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal resourceTraversal = resourceTraversalArray[n2];
            resourcesInScope.addAll(Arrays.asList(resourceTraversal.getResources()));
            ++n2;
        }
        return resourcesInScope;
    }

    protected boolean promptForInputChange(String requestPreviewMessage, IProgressMonitor monitor) {
        List<IResource> relevantResources = this.getRelevantResources();
        Map pathsByRepo = ResourceUtil.splitResourcesByRepository(relevantResources);
        for (Map.Entry entry : pathsByRepo.entrySet()) {
            IndexDiffData indexDiff;
            IndexDiffCacheEntry cacheEntry;
            Repository repository = (Repository)entry.getKey();
            Collection paths = (Collection)entry.getValue();
            IndexDiffCache cache = Activator.getDefault().getIndexDiffCache();
            if (cache == null || (cacheEntry = cache.getIndexDiffCacheEntry(repository)) == null || (indexDiff = cacheEntry.getIndexDiff()) == null || !GitScopeOperation.hasAnyPathChanged(paths, indexDiff)) continue;
            return super.promptForInputChange(requestPreviewMessage, monitor);
        }
        return false;
    }

    private static boolean hasAnyPathChanged(Collection<String> paths, IndexDiffData indexDiff) {
        for (String path : paths) {
            boolean hasChanged;
            boolean bl = hasChanged = indexDiff.getAdded().contains(path) || indexDiff.getChanged().contains(path) || indexDiff.getModified().contains(path) || indexDiff.getRemoved().contains(path) || indexDiff.getUntracked().contains(path);
            if (!hasChanged) continue;
            return true;
        }
        return false;
    }
}

