/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.actions;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.CommitOperation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.op.InitOperation;
import org.eclipse.egit.gitflow.ui.internal.JobFamilies;
import org.eclipse.egit.gitflow.ui.internal.UIText;
import org.eclipse.egit.gitflow.ui.internal.actions.GitFlowHandlerUtil;
import org.eclipse.egit.gitflow.ui.internal.dialogs.InitDialog;
import org.eclipse.egit.ui.internal.commit.CommitHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class InitHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        InitDialog dialog;
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        GitFlowRepository gfRepo = GitFlowHandlerUtil.getRepository(event);
        if (gfRepo == null) {
            return null;
        }
        Repository repository = gfRepo.getRepository();
        if (!gfRepo.hasBranches()) {
            boolean createMaster = MessageDialog.openQuestion((Shell)activeShell, (String)UIText.InitHandler_emptyRepository, (String)UIText.InitHandler_doYouWantToInitNow);
            if (!createMaster) {
                return null;
            }
            this.createInitialCommit(repository);
        }
        if ((dialog = new InitDialog(activeShell, gfRepo, this.getBranches(repository))).open() != 0) {
            return null;
        }
        InitOperation initOperation = new InitOperation(repository, dialog.getResult());
        JobUtil.scheduleUserWorkspaceJob((IEGitOperation)initOperation, (String)UIText.InitHandler_initializing, (Object)JobFamilies.GITFLOW_FAMILY);
        return null;
    }

    private void createInitialCommit(Repository repository) throws ExecutionException {
        CommitHelper commitHelper = new CommitHelper(repository);
        try {
            CommitOperation commitOperation = new CommitOperation(repository, commitHelper.getAuthor(), commitHelper.getCommitter(), UIText.InitHandler_initialCommit);
            commitOperation.execute(null);
        }
        catch (CoreException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private List<Ref> getBranches(Repository repository) throws ExecutionException {
        List branchList;
        try {
            branchList = Git.wrap((Repository)repository).branchList().call();
        }
        catch (GitAPIException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        return branchList;
    }
}

