/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wildwebdeveloper.Activator;

public class InitializeLaunchConfigurations {
    private static boolean alreadyWarned;

    public static String getVSCodeLocation(String appendPathSuffix) {
        String res = null;
        if (Platform.getOS().equals("linux")) {
            res = "/usr/share/code";
        } else if (Platform.getOS().equals("win32")) {
            res = "C:/Program Files (x86)/Microsoft VS Code";
        } else if (Platform.getOS().equals("macosx")) {
            res = "/Applications/Visual Studio Code.app";
            Path path = new Path(appendPathSuffix);
            if (path.segmentCount() > 1 && path.segment(0).equals("resources")) {
                path = path.removeFirstSegments(1);
                appendPathSuffix = new Path("/Contents/Resources").append((IPath)path).toOSString();
            }
        }
        if (res != null && new File(res).isDirectory()) {
            if (res.contains(" ") && Platform.getOS().equals("win32")) {
                return "\"" + res + appendPathSuffix + "\"";
            }
            return String.valueOf(res) + appendPathSuffix;
        }
        return "/unknown/path/to/VSCode" + appendPathSuffix;
    }

    public static String getNodeJsLocation() {
        String res;
        block10: {
            String nodeJsLocation = System.getProperty("org.eclipse.wildwebdeveloper.nodeJSLocation");
            if (nodeJsLocation != null && Files.exists(Paths.get(nodeJsLocation, new String[0]), new LinkOption[0])) {
                return nodeJsLocation;
            }
            res = "/path/to/node";
            String[] command = new String[]{"/bin/bash", "-c", "which node"};
            if (Platform.getOS().equals("win32")) {
                command = new String[]{"cmd", "/c", "where node"};
            }
            BufferedReader reader = null;
            try {
                try {
                    Process p = Runtime.getRuntime().exec(command);
                    reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    res = reader.readLine();
                }
                catch (IOException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
                    IOUtils.closeQuietly((Reader)reader);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        if (res == null && Platform.getOS().equals("macosx")) {
            res = "/usr/local/bin/node";
        }
        if (res != null && Files.exists(Paths.get(res, new String[0]), new LinkOption[0])) {
            return res;
        }
        if (!alreadyWarned) {
            InitializeLaunchConfigurations.warnNodeJSMissing();
            alreadyWarned = true;
        }
        return null;
    }

    private static void warnNodeJSMissing() {
        Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Missing node.js", (String)"Could not find node.js. This will result in editors missing key features.\nPlease make sure node.js is installed and that your PATH environement variable contains the location to the `node` executable."));
    }
}

