/**
 * Copyright (c) 2010-2013, Zoltan Ujhelyi, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Zoltan Ujhelyi - initial API and implementation
 *   Csaba Debreceni - add exception for deprecated methods
 */
package org.eclipse.viatra.addon.viewers.runtime.notation;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.viatra.addon.viewers.runtime.notation.NotationFactory
 * @model kind="package"
 * @generated
 */
public interface NotationPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "notation";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/viatra/addon/viewers/notation/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "notation";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	NotationPackage eINSTANCE = org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement <em>Formattable Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getFormattableElement()
	 * @generated
	 */
	int FORMATTABLE_ELEMENT = 0;

	/**
	 * The feature id for the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMATTABLE_ELEMENT__LABEL = 0;

	/**
	 * The feature id for the '<em><b>Format</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMATTABLE_ELEMENT__FORMAT = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMATTABLE_ELEMENT__ID = 2;

	/**
	 * The number of structural features of the '<em>Formattable Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMATTABLE_ELEMENT_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Formattable Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMATTABLE_ELEMENT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.impl.FormatSpecificationImpl <em>Format Specification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.FormatSpecificationImpl
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getFormatSpecification()
	 * @generated
	 */
	int FORMAT_SPECIFICATION = 1;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAT_SPECIFICATION__PROPERTIES = 0;

	/**
	 * The number of structural features of the '<em>Format Specification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAT_SPECIFICATION_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Format Specification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAT_SPECIFICATION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.impl.ItemImpl <em>Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.ItemImpl
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getItem()
	 * @generated
	 */
	int ITEM = 2;

	/**
	 * The feature id for the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEM__LABEL = FORMATTABLE_ELEMENT__LABEL;

	/**
	 * The feature id for the '<em><b>Format</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEM__FORMAT = FORMATTABLE_ELEMENT__FORMAT;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEM__ID = FORMATTABLE_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEM__PARENT = FORMATTABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Children</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEM__CHILDREN = FORMATTABLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEM__POLICY = FORMATTABLE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Param Object</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEM__PARAM_OBJECT = FORMATTABLE_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Param EObject</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEM__PARAM_EOBJECT = FORMATTABLE_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEM_FEATURE_COUNT = FORMATTABLE_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEM_OPERATION_COUNT = FORMATTABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.impl.EdgeImpl <em>Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.EdgeImpl
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getEdge()
	 * @generated
	 */
	int EDGE = 3;

	/**
	 * The feature id for the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE__LABEL = FORMATTABLE_ELEMENT__LABEL;

	/**
	 * The feature id for the '<em><b>Format</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE__FORMAT = FORMATTABLE_ELEMENT__FORMAT;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE__ID = FORMATTABLE_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE__SOURCE = FORMATTABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE__TARGET = FORMATTABLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_FEATURE_COUNT = FORMATTABLE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_OPERATION_COUNT = FORMATTABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.impl.ContainmentImpl <em>Containment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.ContainmentImpl
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getContainment()
	 * @generated
	 */
	int CONTAINMENT = 4;

	/**
	 * The feature id for the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT__LABEL = EDGE__LABEL;

	/**
	 * The feature id for the '<em><b>Format</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT__FORMAT = EDGE__FORMAT;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT__ID = EDGE__ID;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT__SOURCE = EDGE__SOURCE;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT__TARGET = EDGE__TARGET;

	/**
	 * The number of structural features of the '<em>Containment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_FEATURE_COUNT = EDGE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Containment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_OPERATION_COUNT = EDGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationModelImpl <em>Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationModelImpl
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getNotationModel()
	 * @generated
	 */
	int NOTATION_MODEL = 5;

	/**
	 * The feature id for the '<em><b>Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTATION_MODEL__ITEMS = 0;

	/**
	 * The feature id for the '<em><b>Edges</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTATION_MODEL__EDGES = 1;

	/**
	 * The feature id for the '<em><b>Containments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTATION_MODEL__CONTAINMENTS = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTATION_MODEL__ID = 3;

	/**
	 * The number of structural features of the '<em>Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTATION_MODEL_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTATION_MODEL_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.impl.AttributeImpl <em>Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.AttributeImpl
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getAttribute()
	 * @generated
	 */
	int ATTRIBUTE = 6;

	/**
	 * The feature id for the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__LABEL = FORMATTABLE_ELEMENT__LABEL;

	/**
	 * The feature id for the '<em><b>Format</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__FORMAT = FORMATTABLE_ELEMENT__FORMAT;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__ID = FORMATTABLE_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Container</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__CONTAINER = FORMATTABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_FEATURE_COUNT = FORMATTABLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_OPERATION_COUNT = FORMATTABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.impl.StringToStringMapImpl <em>String To String Map</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.StringToStringMapImpl
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getStringToStringMap()
	 * @generated
	 */
	int STRING_TO_STRING_MAP = 7;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_TO_STRING_MAP__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_TO_STRING_MAP__KEY = 1;

	/**
	 * The number of structural features of the '<em>String To String Map</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_TO_STRING_MAP_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>String To String Map</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_TO_STRING_MAP_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.HierarchyPolicy <em>Hierarchy Policy</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.HierarchyPolicy
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getHierarchyPolicy()
	 * @generated
	 */
	int HIERARCHY_POLICY = 8;


	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement <em>Formattable Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Formattable Element</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement
	 * @generated
	 */
	EClass getFormattableElement();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement#getLabel <em>Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Label</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement#getLabel()
	 * @see #getFormattableElement()
	 * @generated
	 */
	EAttribute getFormattableElement_Label();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement#getFormat <em>Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Format</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement#getFormat()
	 * @see #getFormattableElement()
	 * @generated
	 */
	EReference getFormattableElement_Format();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement#getId()
	 * @see #getFormattableElement()
	 * @generated
	 */
	EAttribute getFormattableElement_Id();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.addon.viewers.runtime.notation.FormatSpecification <em>Format Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Format Specification</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.FormatSpecification
	 * @generated
	 */
	EClass getFormatSpecification();

	/**
	 * Returns the meta object for the map '{@link org.eclipse.viatra.addon.viewers.runtime.notation.FormatSpecification#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>Properties</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.FormatSpecification#getProperties()
	 * @see #getFormatSpecification()
	 * @generated
	 */
	EReference getFormatSpecification_Properties();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Item <em>Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Item</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.Item
	 * @generated
	 */
	EClass getItem();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Item#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Parent</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.Item#getParent()
	 * @see #getItem()
	 * @generated
	 */
	EReference getItem_Parent();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Item#getChildren <em>Children</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Children</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.Item#getChildren()
	 * @see #getItem()
	 * @generated
	 */
	EReference getItem_Children();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Item#getPolicy <em>Policy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Policy</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.Item#getPolicy()
	 * @see #getItem()
	 * @generated
	 */
	EAttribute getItem_Policy();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Item#getParamObject <em>Param Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Param Object</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.Item#getParamObject()
	 * @see #getItem()
	 * @generated
	 */
	EAttribute getItem_ParamObject();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Item#getParamEObject <em>Param EObject</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Param EObject</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.Item#getParamEObject()
	 * @see #getItem()
	 * @generated
	 */
	EReference getItem_ParamEObject();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Edge <em>Edge</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Edge</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.Edge
	 * @generated
	 */
	EClass getEdge();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Edge#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.Edge#getSource()
	 * @see #getEdge()
	 * @generated
	 */
	EReference getEdge_Source();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Edge#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.Edge#getTarget()
	 * @see #getEdge()
	 * @generated
	 */
	EReference getEdge_Target();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Containment <em>Containment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Containment</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.Containment
	 * @generated
	 */
	EClass getContainment();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.addon.viewers.runtime.notation.NotationModel <em>Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Model</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.NotationModel
	 * @generated
	 */
	EClass getNotationModel();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.viatra.addon.viewers.runtime.notation.NotationModel#getItems <em>Items</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Items</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.NotationModel#getItems()
	 * @see #getNotationModel()
	 * @generated
	 */
	EReference getNotationModel_Items();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.viatra.addon.viewers.runtime.notation.NotationModel#getEdges <em>Edges</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Edges</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.NotationModel#getEdges()
	 * @see #getNotationModel()
	 * @generated
	 */
	EReference getNotationModel_Edges();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.viatra.addon.viewers.runtime.notation.NotationModel#getContainments <em>Containments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Containments</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.NotationModel#getContainments()
	 * @see #getNotationModel()
	 * @generated
	 */
	EReference getNotationModel_Containments();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.viatra.addon.viewers.runtime.notation.NotationModel#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.NotationModel#getId()
	 * @see #getNotationModel()
	 * @generated
	 */
	EAttribute getNotationModel_Id();

	/**
	 * Returns the meta object for class '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Attribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.Attribute
	 * @generated
	 */
	EClass getAttribute();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Attribute#getContainer <em>Container</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Container</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.Attribute#getContainer()
	 * @see #getAttribute()
	 * @generated
	 */
	EReference getAttribute_Container();

	/**
	 * Returns the meta object for class '{@link java.util.Map.Entry <em>String To String Map</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>String To String Map</em>'.
	 * @see java.util.Map.Entry
	 * @model features="value key" 
	 *        valueDataType="org.eclipse.emf.ecore.EJavaObject"
	 *        keyDataType="org.eclipse.emf.ecore.EString"
	 * @generated
	 */
	EClass getStringToStringMap();

	/**
	 * Returns the meta object for the attribute '{@link java.util.Map.Entry <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see java.util.Map.Entry
	 * @see #getStringToStringMap()
	 * @generated
	 */
	EAttribute getStringToStringMap_Value();

	/**
	 * Returns the meta object for the attribute '{@link java.util.Map.Entry <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see java.util.Map.Entry
	 * @see #getStringToStringMap()
	 * @generated
	 */
	EAttribute getStringToStringMap_Key();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.viatra.addon.viewers.runtime.notation.HierarchyPolicy <em>Hierarchy Policy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Hierarchy Policy</em>'.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.HierarchyPolicy
	 * @generated
	 */
	EEnum getHierarchyPolicy();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	NotationFactory getNotationFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement <em>Formattable Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getFormattableElement()
		 * @generated
		 */
		EClass FORMATTABLE_ELEMENT = eINSTANCE.getFormattableElement();

		/**
		 * The meta object literal for the '<em><b>Label</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FORMATTABLE_ELEMENT__LABEL = eINSTANCE.getFormattableElement_Label();

		/**
		 * The meta object literal for the '<em><b>Format</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FORMATTABLE_ELEMENT__FORMAT = eINSTANCE.getFormattableElement_Format();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FORMATTABLE_ELEMENT__ID = eINSTANCE.getFormattableElement_Id();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.impl.FormatSpecificationImpl <em>Format Specification</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.FormatSpecificationImpl
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getFormatSpecification()
		 * @generated
		 */
		EClass FORMAT_SPECIFICATION = eINSTANCE.getFormatSpecification();

		/**
		 * The meta object literal for the '<em><b>Properties</b></em>' map feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FORMAT_SPECIFICATION__PROPERTIES = eINSTANCE.getFormatSpecification_Properties();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.impl.ItemImpl <em>Item</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.ItemImpl
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getItem()
		 * @generated
		 */
		EClass ITEM = eINSTANCE.getItem();

		/**
		 * The meta object literal for the '<em><b>Parent</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ITEM__PARENT = eINSTANCE.getItem_Parent();

		/**
		 * The meta object literal for the '<em><b>Children</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ITEM__CHILDREN = eINSTANCE.getItem_Children();

		/**
		 * The meta object literal for the '<em><b>Policy</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ITEM__POLICY = eINSTANCE.getItem_Policy();

		/**
		 * The meta object literal for the '<em><b>Param Object</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ITEM__PARAM_OBJECT = eINSTANCE.getItem_ParamObject();

		/**
		 * The meta object literal for the '<em><b>Param EObject</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ITEM__PARAM_EOBJECT = eINSTANCE.getItem_ParamEObject();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.impl.EdgeImpl <em>Edge</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.EdgeImpl
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getEdge()
		 * @generated
		 */
		EClass EDGE = eINSTANCE.getEdge();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EDGE__SOURCE = eINSTANCE.getEdge_Source();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EDGE__TARGET = eINSTANCE.getEdge_Target();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.impl.ContainmentImpl <em>Containment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.ContainmentImpl
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getContainment()
		 * @generated
		 */
		EClass CONTAINMENT = eINSTANCE.getContainment();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationModelImpl <em>Model</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationModelImpl
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getNotationModel()
		 * @generated
		 */
		EClass NOTATION_MODEL = eINSTANCE.getNotationModel();

		/**
		 * The meta object literal for the '<em><b>Items</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NOTATION_MODEL__ITEMS = eINSTANCE.getNotationModel_Items();

		/**
		 * The meta object literal for the '<em><b>Edges</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NOTATION_MODEL__EDGES = eINSTANCE.getNotationModel_Edges();

		/**
		 * The meta object literal for the '<em><b>Containments</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NOTATION_MODEL__CONTAINMENTS = eINSTANCE.getNotationModel_Containments();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NOTATION_MODEL__ID = eINSTANCE.getNotationModel_Id();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.impl.AttributeImpl <em>Attribute</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.AttributeImpl
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getAttribute()
		 * @generated
		 */
		EClass ATTRIBUTE = eINSTANCE.getAttribute();

		/**
		 * The meta object literal for the '<em><b>Container</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE__CONTAINER = eINSTANCE.getAttribute_Container();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.impl.StringToStringMapImpl <em>String To String Map</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.StringToStringMapImpl
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getStringToStringMap()
		 * @generated
		 */
		EClass STRING_TO_STRING_MAP = eINSTANCE.getStringToStringMap();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STRING_TO_STRING_MAP__VALUE = eINSTANCE.getStringToStringMap_Value();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STRING_TO_STRING_MAP__KEY = eINSTANCE.getStringToStringMap_Key();

		/**
		 * The meta object literal for the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.HierarchyPolicy <em>Hierarchy Policy</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.HierarchyPolicy
		 * @see org.eclipse.viatra.addon.viewers.runtime.notation.impl.NotationPackageImpl#getHierarchyPolicy()
		 * @generated
		 */
		EEnum HIERARCHY_POLICY = eINSTANCE.getHierarchyPolicy();

	}

} //NotationPackage
