/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.table.Messages;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.table.SegmentStoreContentProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterCu;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.IFilterStrings;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TmfFilterAppliedSignal;
import org.eclipse.tracecompass.internal.segmentstore.core.arraylist.ArrayListStore;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.table.TmfSimpleTableViewer;

public abstract class AbstractSegmentStoreTableViewer
extends TmfSimpleTableViewer {
    private static final Format FORMATTER = new DecimalFormat("###,###.##");
    private @Nullable ISegmentStoreProvider fSegmentProvider = null;
    private final @Nullable SegmentStoreProviderProgressListener fListener;
    private @Nullable ITmfTrace fTrace;
    boolean fColumnsCreated = false;
    private Collection<String> fGlobalFilter = Collections.emptySet();

    public AbstractSegmentStoreTableViewer(TableViewer tableViewer) {
        this(tableViewer, true);
    }

    public AbstractSegmentStoreTableViewer(TableViewer tableViewer, boolean withListener) {
        super(tableViewer);
        this.getTableViewer().setContentProvider((IContentProvider)new SegmentStoreContentProvider());
        this.createColumns();
        this.getTableViewer().getTable().addSelectionListener((SelectionListener)new TableSelectionListener());
        this.addPackListener();
        this.fListener = withListener ? new SegmentStoreProviderProgressListener() : null;
    }

    @VisibleForTesting
    public void setSegmentProvider(ISegmentStoreProvider segmentProvider) {
        this.fSegmentProvider = segmentProvider;
        this.getTableViewer().setContentProvider((IContentProvider)new SegmentStoreContentProvider());
        Table table = this.getTableViewer().getTable();
        table.setRedraw(false);
        while (table.getColumnCount() > 0) {
            table.getColumn(0).dispose();
        }
        this.createColumns();
        this.createProviderColumns();
        this.getTableViewer().getTable().addSelectionListener((SelectionListener)new TableSelectionListener());
        this.addPackListener();
        table.setRedraw(true);
    }

    private void createColumns() {
        this.createColumn(Messages.SegmentStoreTableViewer_startTime, new SegmentStoreTableColumnLabelProvider(this){

            @Override
            public String getTextForSegment(ISegment input) {
                return NonNullUtils.nullToEmptyString((Object)TmfTimestampFormat.getDefaulTimeFormat().format(input.getStart()));
            }
        }, SegmentComparators.INTERVAL_START_COMPARATOR);
        this.createColumn(Messages.SegmentStoreTableViewer_endTime, new SegmentStoreTableColumnLabelProvider(this){

            @Override
            public String getTextForSegment(ISegment input) {
                return NonNullUtils.nullToEmptyString((Object)TmfTimestampFormat.getDefaulTimeFormat().format(input.getEnd()));
            }
        }, SegmentComparators.INTERVAL_END_COMPARATOR);
        this.createColumn(Messages.SegmentStoreTableViewer_duration, new SegmentStoreTableColumnLabelProvider(this){

            @Override
            public String getTextForSegment(ISegment input) {
                return NonNullUtils.nullToEmptyString((Object)FORMATTER.format(input.getLength()));
            }
        }, SegmentComparators.INTERVAL_LENGTH_COMPARATOR);
    }

    protected void createProviderColumns() {
        if (!this.fColumnsCreated) {
            ISegmentStoreProvider provider = this.getSegmentProvider();
            if (provider != null) {
                for (final ISegmentAspect aspect : provider.getSegmentAspects()) {
                    this.createColumn(aspect.getName(), new SegmentStoreTableColumnLabelProvider(this){

                        @Override
                        public String getTextForSegment(ISegment input) {
                            return NonNullUtils.nullToEmptyString((Object)aspect.resolve(input));
                        }
                    }, aspect.getComparator());
                }
            }
            this.fColumnsCreated = true;
        }
    }

    public void updateModel(final @Nullable Object dataInput) {
        final TableViewer tableViewer = this.getTableViewer();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!tableViewer.getTable().isDisposed()) {
                    tableViewer.getTable().setTopIndex(0);
                    tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    if (dataInput == null) {
                        tableViewer.setInput(null);
                        tableViewer.setItemCount(0);
                        return;
                    }
                    AbstractSegmentStoreTableViewer.this.addPackListener();
                    tableViewer.setInput(dataInput);
                    SegmentStoreContentProvider contentProvider = (SegmentStoreContentProvider)AbstractSegmentStoreTableViewer.this.getTableViewer().getContentProvider();
                    tableViewer.setItemCount((int)Math.min(Integer.MAX_VALUE, contentProvider.getSegmentCount()));
                }
            }
        });
    }

    public void setData(@Nullable ISegmentStoreProvider provider) {
        this.fSegmentProvider = provider;
        if (provider == null) {
            this.updateModel(null);
            return;
        }
        this.createProviderColumns();
        ISegmentStore segStore = provider.getSegmentStore();
        Map<@NonNull Integer, @NonNull Predicate<@NonNull Map<@NonNull String, @NonNull String>>> predicates = this.computeRegexPredicate();
        Predicate<ISegment> predicate = segment -> {
            if (!predicates.isEmpty()) {
                Map<@NonNull String, @NonNull String> input = AbstractSegmentStoreTableViewer.getFilterInput(segment, provider);
                boolean activateProperty = false;
                for (Map.Entry mapEntry : predicates.entrySet()) {
                    Integer property = Objects.requireNonNull((Integer)mapEntry.getKey());
                    Predicate value = Objects.requireNonNull((Predicate)mapEntry.getValue());
                    if (!(property == 1 | property == 4)) continue;
                    boolean status = value.test(input);
                    activateProperty |= status;
                }
                return activateProperty;
            }
            return true;
        };
        if (segStore != null) {
            if (predicates.isEmpty()) {
                this.updateModel(segStore);
                return;
            }
            Collection filtered = Collections2.filter((Collection)segStore, seg -> predicate.test((ISegment)seg));
            ArrayListStore filteredStore = new ArrayListStore((Object[])filtered.toArray(new ISegment[filtered.size()]));
            this.updateModel(filteredStore);
            return;
        }
        this.updateModel(null);
        SegmentStoreProviderProgressListener listener = this.fListener;
        if (listener != null) {
            provider.addListener((IAnalysisProgressListener)listener);
        }
        if (provider instanceof IAnalysisModule) {
            ((IAnalysisModule)provider).schedule();
        }
    }

    private static Map<String, String> getFilterInput(ISegment segment, ISegmentStoreProvider provider) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (ISegmentAspect aspect : provider.getSegmentAspects()) {
            Object resolve = aspect.resolve(segment);
            if (resolve == null) continue;
            map.put(aspect.getName(), String.valueOf(resolve));
        }
        return map;
    }

    protected Map<Integer, Predicate<@NonNull Map<@NonNull String, @NonNull String>>> computeRegexPredicate() {
        Multimap<@NonNull Integer, @NonNull String> regexes = this.getRegexes();
        HashMap<@NonNull Integer, @NonNull Predicate<@NonNull Map<@NonNull String, @NonNull String>>> predicates = new HashMap<Integer, Predicate<Map<String, String>>>();
        for (Map.Entry entry : regexes.asMap().entrySet()) {
            Predicate predicate;
            String regex = IFilterStrings.mergeFilters((Collection)((Collection)entry.getValue()));
            FilterCu cu = FilterCu.compile((String)regex);
            Predicate predicate2 = predicate = cu != null ? cu.generate() : null;
            if (predicate == null) continue;
            predicates.put((Integer)entry.getKey(), predicate);
        }
        return predicates;
    }

    protected abstract @Nullable ISegmentStoreProvider getSegmentStoreProvider(ITmfTrace var1);

    protected void appendToTablePopupMenu(IMenuManager manager, IStructuredSelection sel) {
        final ISegment segment = (ISegment)sel.getFirstElement();
        if (segment != null) {
            Action gotoStartTime = new Action(Messages.SegmentStoreTableViewer_goToStartEvent){

                public void run() {
                    AbstractSegmentStoreTableViewer.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractSegmentStoreTableViewer.this, TmfTimestamp.fromNanos((long)segment.getStart()), TmfTimestamp.fromNanos((long)segment.getStart()), AbstractSegmentStoreTableViewer.this.fTrace));
                }
            };
            Action gotoEndTime = new Action(Messages.SegmentStoreTableViewer_goToEndEvent){

                public void run() {
                    AbstractSegmentStoreTableViewer.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractSegmentStoreTableViewer.this, TmfTimestamp.fromNanos((long)segment.getEnd()), TmfTimestamp.fromNanos((long)segment.getEnd()), AbstractSegmentStoreTableViewer.this.fTrace));
                }
            };
            manager.add((IAction)gotoStartTime);
            manager.add((IAction)gotoEndTime);
        }
    }

    public @Nullable ISegmentStoreProvider getSegmentProvider() {
        return this.fSegmentProvider;
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        ITmfTrace trace;
        this.fTrace = trace = signal.getTrace();
        if (trace != null) {
            this.setData(this.getSegmentStoreProvider(trace));
        }
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        ITmfTrace trace;
        this.fTrace = trace = signal.getTrace();
        if (trace != null) {
            this.setData(this.getSegmentStoreProvider(trace));
        }
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (TmfTraceManager.getInstance().getActiveTrace() == null) {
            SegmentStoreProviderProgressListener listener;
            ISegmentStoreProvider provider;
            if (!this.getTableViewer().getTable().isDisposed()) {
                this.getTableViewer().setInput(null);
                this.getTableViewer().setItemCount(0);
                this.refresh();
            }
            if ((provider = this.getSegmentProvider()) != null && (listener = this.fListener) != null) {
                provider.removeListener((IAnalysisProgressListener)listener);
            }
            this.fTrace = null;
        }
    }

    @TmfSignalHandler
    public void regexFilterApplied(TmfFilterAppliedSignal signal) {
        Collection regex = signal.getFilter().getRegexes();
        this.setGlobalRegexFilter(regex);
        this.setData(this.getSegmentProvider());
    }

    private void setGlobalRegexFilter(Collection<String> regex) {
        this.fGlobalFilter = regex;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected Multimap<@NonNull Integer, @NonNull String> getRegexes() {
        @NonNull @NonNull HashMultimap regexes = HashMultimap.create();
        if (!this.fGlobalFilter.isEmpty()) {
            regexes.putAll((Object)1, (Iterable)NonNullUtils.checkNotNull(this.fGlobalFilter));
        }
        return regexes;
    }

    private void addPackListener() {
        this.getControl().addListener(36, new Listener(){

            public void handleEvent(@Nullable Event event) {
                AbstractSegmentStoreTableViewer.this.getControl().removeListener(36, (Listener)this);
                TableViewer tableViewer = AbstractSegmentStoreTableViewer.this.getTableViewer();
                if (tableViewer != null) {
                    TableColumn[] tableColumnArray = tableViewer.getTable().getColumns();
                    int n = tableColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumn col = tableColumnArray[n2];
                        col.pack();
                        ++n2;
                    }
                }
            }
        });
    }

    private final class SegmentStoreProviderProgressListener
    implements IAnalysisProgressListener {
        private SegmentStoreProviderProgressListener() {
        }

        public void onComplete(ISegmentStoreProvider activeProvider, ISegmentStore<ISegment> data) {
            if (activeProvider.equals(AbstractSegmentStoreTableViewer.this.fSegmentProvider)) {
                AbstractSegmentStoreTableViewer.this.updateModel(data);
            }
        }
    }

    private abstract class SegmentStoreTableColumnLabelProvider
    extends ColumnLabelProvider {
        private SegmentStoreTableColumnLabelProvider() {
        }

        public String getText(@Nullable Object input) {
            if (!(input instanceof ISegment)) {
                return "";
            }
            return this.getTextForSegment((ISegment)input);
        }

        public abstract String getTextForSegment(ISegment var1);
    }

    private class TableSelectionListener
    extends SelectionAdapter {
        private TableSelectionListener() {
        }

        public void widgetSelected(@Nullable SelectionEvent e) {
            ISegment selectedSegment = (ISegment)((SelectionEvent)NonNullUtils.checkNotNull((Object)e)).item.getData();
            ITmfTimestamp start = TmfTimestamp.fromNanos((long)selectedSegment.getStart());
            ITmfTimestamp end = TmfTimestamp.fromNanos((long)selectedSegment.getEnd());
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractSegmentStoreTableViewer.this, start, end, AbstractSegmentStoreTableViewer.this.fTrace));
        }
    }
}

