/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.oniguruma;

import java.nio.charset.StandardCharsets;
import org.eclipse.tm4e.core.internal.oniguruma.OnigResult;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.WarnCallback;

public class OnigRegExp {
    private Object lastSearchStrUniqueId = null;
    private int lastSearchPosition = -1;
    private OnigResult lastSearchResult = null;
    private Regex regex;

    public OnigRegExp(String source) {
        byte[] pattern = source.getBytes(StandardCharsets.UTF_8);
        this.regex = new Regex(pattern, 0, pattern.length, 256, (Encoding)UTF8Encoding.INSTANCE, Syntax.DEFAULT, WarnCallback.DEFAULT);
    }

    public OnigResult Search(OnigString str, int position) {
        if (this.lastSearchStrUniqueId == str.uniqueId() && this.lastSearchPosition <= position && (this.lastSearchResult == null || this.lastSearchResult.LocationAt(0) >= position)) {
            return this.lastSearchResult;
        }
        this.lastSearchStrUniqueId = str.uniqueId();
        this.lastSearchPosition = position;
        this.lastSearchResult = this.Search(str.utf8_value(), position, str.utf8_length());
        return this.lastSearchResult;
    }

    private OnigResult Search(byte[] data, int position, int end) {
        Matcher matcher = this.regex.matcher(data);
        int status = matcher.search(position, end, 0);
        if (status != -1) {
            Region region = matcher.getEagerRegion();
            return new OnigResult(region, -1);
        }
        return null;
    }
}

