/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.mappings.CVSModelProviderAction;
import org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileWizard;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.PlatformUI;

public class CreatePatchAction
extends CVSModelProviderAction
implements IDiffChangeListener {
    public CreatePatchAction(ISynchronizePageConfiguration configuration) {
        super(configuration);
        this.getSynchronizationContext().getDiffTree().addDiffChangeListener((IDiffChangeListener)this);
    }

    protected boolean isEnabledForSelection(IStructuredSelection selection) {
        return this.internalIsEnabled(selection);
    }

    private boolean internalIsEnabled(IStructuredSelection selection) {
        int mode = this.getConfiguration().getMode();
        if (mode == 2 || mode == 4) {
            return this.getResourceMappings(selection).length > 0;
        }
        return this.getSynchronizationContext().getDiffTree().countFor(768, 768) > 0L;
    }

    private IResource[] getVisibleResources(ResourceTraversal[] traversals) {
        HashSet<IResource> resources = new HashSet<IResource>();
        IResourceDiffTree diffTree = this.getSynchronizationContext().getDiffTree();
        IDiff[] diffs = diffTree.getDiffs(traversals);
        int i = 0;
        while (i < diffs.length) {
            IThreeWayDiff twd;
            ITwoWayDiff local;
            IDiff diff = diffs[i];
            IResource child = diffTree.getResource(diff);
            if (child.getType() == 1 && diff instanceof IThreeWayDiff && (local = (twd = (IThreeWayDiff)diff).getLocalChange()) != null && local.getKind() != 0) {
                resources.add(child);
            }
            ++i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    @Override
    protected String getBundleKeyPrefix() {
        return "GenerateDiffFileAction.";
    }

    @Override
    public void execute() {
        ResourceTraversal[][] traversals = new ResourceTraversal[1][];
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                try {
                    resourceTraversalArray[0] = this.getResourceTraversals(this.getStructuredSelection(), monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            Utils.handleError((Shell)this.getConfiguration().getSite().getShell(), (Exception)e, null, null);
        }
        catch (InterruptedException interruptedException) {}
        if (traversals[0] != null) {
            IResource[] resources = this.getVisibleResources(traversals[0]);
            if (resources.length == 0) {
                MessageDialog.openInformation((Shell)this.getConfiguration().getSite().getShell(), (String)CVSUIMessages.CreatePatchAction_0, (String)CVSUIMessages.CreatePatchAction_1);
            } else {
                GenerateDiffFileWizard.run(this.getConfiguration().getSite().getPart(), resources, false);
            }
        }
    }

    public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
        this.updateEnablement();
    }

    public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
    }
}

