/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.internal.ccvs.core.CVSCompareSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.SyncAction;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceTraversalAction;
import org.eclipse.team.internal.ccvs.ui.mappings.CompareSubscriberContext;
import org.eclipse.team.internal.ccvs.ui.mappings.ModelCompareParticipant;
import org.eclipse.team.internal.ccvs.ui.subscriber.CompareParticipant;
import org.eclipse.team.internal.ccvs.ui.tags.TagSelectionDialog;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;

public class CompareWithTagAction
extends WorkspaceTraversalAction {
    private static boolean isOpenEditorForSingleFile() {
        return CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("openCompareEditorForSingleFile");
    }

    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        CVSCompareSubscriber compareSubscriber;
        IFile file;
        IResource[] resources = this.getSelectedResources();
        CVSTag tag = this.promptForTag(resources);
        if (tag == null) {
            return;
        }
        if (CompareWithTagAction.isOpenEditorForSingleFile() && (file = this.getSelectedFile()) != null && SyncAction.isOKToShowSingleFile(file)) {
            CVSCompareSubscriber compareSubscriber2 = new CVSCompareSubscriber(resources, tag);
            SyncAction.showSingleFileComparison(this.getShell(), (Subscriber)compareSubscriber2, (IResource)file, this.getTargetPage());
            compareSubscriber2.dispose();
            return;
        }
        if (this.isShowModelSync()) {
            compareSubscriber = new CVSCompareSubscriber(CompareWithTagAction.getProjects(resources), tag);
            ResourceMapping[] mappings = this.getCVSResourceMappings();
            try {
                compareSubscriber.primeRemoteTree();
            }
            catch (CVSException cVSException) {}
            SubscriberScopeManager manager = new SubscriberScopeManager(compareSubscriber.getName(), mappings, (Subscriber)compareSubscriber, true){

                public void dispose() {
                    compareSubscriber.dispose();
                    super.dispose();
                }
            };
            SynchronizationContext context = CompareSubscriberContext.createContext((ISynchronizationScopeManager)manager, compareSubscriber);
            ModelCompareParticipant participant = new ModelCompareParticipant(context);
            TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
            participant.run(this.getTargetPart());
        } else {
            compareSubscriber = new CVSCompareSubscriber(CompareWithTagAction.getProjects(resources), tag);
            ResourceMapping[] resourceMappings = this.getCVSResourceMappings();
            if (CompareWithTagAction.isLogicalModel(resourceMappings)) {
                compareSubscriber = new CVSCompareSubscriber(CompareWithTagAction.getProjects(resources), tag);
                resources = this.getResourcesToCompare((Subscriber)compareSubscriber);
                compareSubscriber.dispose();
            }
            compareSubscriber = new CVSCompareSubscriber(resources, tag);
            try {
                compareSubscriber.primeRemoteTree();
            }
            catch (CVSException cVSException) {}
            CompareParticipant participant = CompareParticipant.getMatchingParticipant(resources, tag);
            if (participant == null) {
                CVSCompareSubscriber s = compareSubscriber;
                participant = new CompareParticipant(s);
                TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
            }
            participant.refresh(resources, null, null, null);
        }
    }

    private boolean isShowModelSync() {
        return CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("enableModelSync");
    }

    protected CVSTag promptForTag(IResource[] resources) {
        CVSTag tag = TagSelectionDialog.getTagToCompareWith(this.getShell(), TagSource.create(resources), 31);
        return tag;
    }

    @Override
    protected boolean isEnabledForNonExistantResources() {
        return true;
    }
}

