/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.layout;

import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.util.ViewRefactorHelper;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.JumpLinkStatus;
import org.eclipse.gmf.runtime.notation.JumpLinkType;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.Smoothness;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.layoutdata.AbstractLayoutData;
import org.eclipse.sirius.diagram.layoutdata.EdgeLayoutData;
import org.eclipse.sirius.diagram.layoutdata.LayoutdataFactory;
import org.eclipse.sirius.diagram.layoutdata.LayoutdataPackage;
import org.eclipse.sirius.diagram.layoutdata.NodeLayoutData;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.internal.operation.CenterEdgeEndModelChangeOperation;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.borderednode.CanonicalDBorderItemLocator;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutDataHelper;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutDataKey;
import org.eclipse.sirius.diagram.ui.tools.api.layout.SiriusLayoutDataManager;
import org.eclipse.sirius.ext.draw2d.figure.FigureUtilities;
import org.eclipse.sirius.tools.internal.SiriusCopierHelper;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

@Deprecated
public abstract class AbstractSiriusLayoutDataManager
implements SiriusLayoutDataManager {
    private static final Class<?>[] CLASS_EXCEPTIONS = new Class[]{DNodeListElement.class};

    @Override
    public void storeLayoutData(IGraphicalEditPart rootEditPart) {
        HashSet<LayoutDataKey> discoveredKeys = new HashSet<LayoutDataKey>();
        EObject semanticElement = rootEditPart.resolveSemanticElement();
        View toStoreView = (View)rootEditPart.getModel();
        if (toStoreView instanceof Edge && semanticElement instanceof DEdge) {
            this.addEdgeLayoutData(null, (DEdge)semanticElement, rootEditPart.getRoot().getViewer());
        } else if (toStoreView instanceof Diagram && semanticElement instanceof DDiagram) {
            this.addChildLayout((DDiagram)semanticElement, rootEditPart, discoveredKeys);
        } else if (toStoreView instanceof Node && semanticElement instanceof DDiagramElement && semanticElement instanceof DSemanticDecorator) {
            this.addChildLayout(null, (DSemanticDecorator)semanticElement, (Node)toStoreView, rootEditPart, discoveredKeys);
        }
        discoveredKeys.clear();
    }

    @Override
    public void applyFormat(IGraphicalEditPart rootEditPart) {
        this.applyFormat(rootEditPart, true, true);
    }

    @Override
    public void applyLayout(IGraphicalEditPart rootEditPart) {
        this.applyFormat(rootEditPart, true, false);
    }

    @Override
    public void applyStyle(IGraphicalEditPart rootEditPart) {
        this.applyFormat(rootEditPart, false, true);
    }

    protected void applyFormat(IGraphicalEditPart rootEditPart, boolean applyLayout, boolean applyStyle) {
        EObject semanticElement = rootEditPart.resolveSemanticElement();
        View toStoreView = (View)rootEditPart.getModel();
        if (!(toStoreView instanceof Edge)) {
            if (toStoreView instanceof Diagram && semanticElement instanceof DDiagram) {
                this.applyFormat((DDiagram)semanticElement, (Diagram)toStoreView, rootEditPart.getRoot().getViewer(), applyLayout, applyStyle);
                this.centerEdgesEnds(toStoreView);
            } else if (toStoreView instanceof Node) {
                if (semanticElement instanceof DDiagramElement && semanticElement instanceof DSemanticDecorator) {
                    this.applyFormat((DSemanticDecorator)semanticElement, (Node)toStoreView, rootEditPart.getRoot().getViewer(), null, applyLayout, applyStyle);
                }
                this.centerEdgesEnds(toStoreView);
            }
        }
    }

    private void centerEdgesEnds(View view) {
        HashSet edges = new HashSet();
        if (view instanceof Diagram) {
            edges.addAll(((Diagram)view).getEdges());
        } else {
            ViewUtil.getAllRelatedEdgesForView((View)view, edges);
        }
        for (Edge edge : edges) {
            CenterEdgeEndModelChangeOperation centerEdgeEndModelChangeOperation = new CenterEdgeEndModelChangeOperation(edge, false);
            centerEdgeEndModelChangeOperation.execute();
        }
    }

    private void applyFormat(DDiagram diagram, Diagram toStoreView, EditPartViewer editPartViewer, boolean applyLayout, boolean applyStyle) {
        for (AbstractDNode node : Iterables.filter((Iterable)diagram.getOwnedDiagramElements(), AbstractDNode.class)) {
            Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)node);
            if (gmfNode == null) continue;
            this.applyFormat((DSemanticDecorator)node, gmfNode, editPartViewer, null, applyLayout, applyStyle);
        }
    }

    private void applyFormatToOutgoingEdge(EdgeTarget sourceNode, EditPartViewer editPartViewer, boolean applyLayout, boolean applyStyle) {
        for (DEdge edge : sourceNode.getOutgoingEdges()) {
            Edge gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)edge);
            if (gmfEdge == null) continue;
            this.applyFormat(edge, gmfEdge, editPartViewer, applyLayout, applyStyle);
        }
    }

    private void applyFormat(DEdge edge, Edge gmfEdge, EditPartViewer editPartViewer, boolean applyLayout, boolean applyStyle) {
        EdgeLayoutData layoutData = (EdgeLayoutData)this.getLayoutData(this.createKey((DSemanticDecorator)edge));
        if (layoutData != null) {
            if (applyLayout) {
                RoutingStyle routingStyle;
                Bendpoints bendpoints = this.convertPointsToGMFBendpoint(layoutData);
                gmfEdge.setBendpoints(bendpoints);
                if (layoutData.getSourceTerminal() != null) {
                    if (gmfEdge.getSourceAnchor() == null) {
                        gmfEdge.setSourceAnchor((Anchor)NotationFactory.eINSTANCE.createIdentityAnchor());
                    }
                    if (gmfEdge.getSourceAnchor() instanceof IdentityAnchor) {
                        ((IdentityAnchor)gmfEdge.getSourceAnchor()).setId(layoutData.getSourceTerminal());
                    }
                } else if (gmfEdge.getSourceAnchor() instanceof IdentityAnchor) {
                    gmfEdge.setSourceAnchor(null);
                }
                if (layoutData.getTargetTerminal() != null) {
                    if (gmfEdge.getTargetAnchor() == null) {
                        gmfEdge.setTargetAnchor((Anchor)NotationFactory.eINSTANCE.createIdentityAnchor());
                    }
                    if (gmfEdge.getTargetAnchor() instanceof IdentityAnchor) {
                        ((IdentityAnchor)gmfEdge.getTargetAnchor()).setId(layoutData.getTargetTerminal());
                    }
                } else if (gmfEdge.getTargetAnchor() instanceof IdentityAnchor) {
                    gmfEdge.setTargetAnchor(null);
                }
                if ((routingStyle = (RoutingStyle)gmfEdge.getStyle(NotationPackage.eINSTANCE.getRoutingStyle())) != null) {
                    routingStyle.setRouting(Routing.get((int)layoutData.getRouting()));
                    routingStyle.setJumpLinkStatus(JumpLinkStatus.get((int)layoutData.getJumpLinkStatus()));
                    routingStyle.setJumpLinkType(JumpLinkType.get((int)layoutData.getJumpLinkType()));
                    routingStyle.setJumpLinksReverse(layoutData.isReverseJumpLink());
                    routingStyle.setSmoothness(Smoothness.get((int)layoutData.getSmoothness()));
                }
            }
            if (applyStyle) {
                this.applySiriusStyle((DSemanticDecorator)edge, (AbstractLayoutData)layoutData);
                this.applyGMFStyle((View)gmfEdge, (AbstractLayoutData)layoutData);
            }
            this.applyLabelFormat((View)gmfEdge, (AbstractLayoutData)layoutData, applyLayout, applyStyle);
        }
    }

    private void applyLabelFormat(View gmfView, AbstractLayoutData parentLayoutData, boolean applyLayout, boolean applyStyle) {
        if (parentLayoutData != null) {
            Node labelNode = SiriusGMFHelper.getLabelNode(gmfView);
            if (parentLayoutData.getLabel() != null && labelNode != null) {
                if (applyLayout) {
                    if (!parentLayoutData.getLabel().eIsSet((EStructuralFeature)LayoutdataPackage.eINSTANCE.getNodeLayoutData_Width()) && !parentLayoutData.getLabel().eIsSet((EStructuralFeature)LayoutdataPackage.eINSTANCE.getNodeLayoutData_Height())) {
                        Location location = NotationFactory.eINSTANCE.createLocation();
                        location.setX(parentLayoutData.getLabel().getLocation().getX());
                        location.setY(parentLayoutData.getLabel().getLocation().getY());
                        labelNode.setLayoutConstraint((LayoutConstraint)location);
                    } else {
                        Bounds bounds = NotationFactory.eINSTANCE.createBounds();
                        bounds.setX(parentLayoutData.getLabel().getLocation().getX());
                        bounds.setY(parentLayoutData.getLabel().getLocation().getY());
                        bounds.setWidth(parentLayoutData.getLabel().getWidth());
                        bounds.setHeight(parentLayoutData.getLabel().getHeight());
                        labelNode.setLayoutConstraint((LayoutConstraint)bounds);
                    }
                }
                if (applyStyle) {
                    this.applyGMFStyle((View)labelNode, (AbstractLayoutData)parentLayoutData.getLabel());
                }
            }
        }
    }

    private Bendpoints convertPointsToGMFBendpoint(EdgeLayoutData edgeLayoutData) {
        RelativeBendpoints result = NotationFactory.eINSTANCE.createRelativeBendpoints();
        LinkedList<RelativeBendpoint> relativeBendpoints = new LinkedList<RelativeBendpoint>();
        org.eclipse.sirius.diagram.layoutdata.Point source = edgeLayoutData.getSourceRefPoint();
        org.eclipse.sirius.diagram.layoutdata.Point target = edgeLayoutData.getTargetRefPoint();
        if (source != null && target != null) {
            Point sourceRefPoint = new Point(source.getX(), source.getY());
            Point targetRefPoint = new Point(target.getX(), target.getY());
            for (org.eclipse.sirius.diagram.layoutdata.Point point : edgeLayoutData.getPointList()) {
                Point tempPoint = new Point(point.getX(), point.getY());
                Dimension s = tempPoint.getDifference(sourceRefPoint);
                Dimension t = tempPoint.getDifference(targetRefPoint);
                relativeBendpoints.add(new RelativeBendpoint(s.width, s.height, t.width, t.height));
            }
        }
        result.setPoints(relativeBendpoints);
        return result;
    }

    private void applyFormat(DSemanticDecorator semanticDecorator, Node toRestoreView, EditPartViewer editPartViewer, NodeLayoutData parentLayoutData, boolean applyLayout, boolean applyStyle) {
        LayoutDataKey key = this.createKey(semanticDecorator);
        NodeLayoutData layoutData = (NodeLayoutData)this.getLayoutData(key);
        if (parentLayoutData != null && parentLayoutData == layoutData && !StringUtil.isEmpty((String)key.getId())) {
            layoutData = null;
            for (NodeLayoutData childLayoutData : parentLayoutData.getChildren()) {
                if (!key.getId().equals(childLayoutData.getId())) continue;
                if (layoutData == null) {
                    layoutData = childLayoutData;
                    continue;
                }
                layoutData = null;
                break;
            }
        }
        if (layoutData != null && applyLayout) {
            org.eclipse.sirius.diagram.layoutdata.Point locationToApply;
            Bounds bounds = NotationFactory.eINSTANCE.createBounds();
            IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)editPartViewer.getEditPartRegistry().get(toRestoreView);
            boolean isCollapsed = false;
            if (graphicalEditPart instanceof AbstractDiagramBorderNodeEditPart) {
                locationToApply = LayoutDataHelper.INSTANCE.getAbsoluteLocation(layoutData);
                Node parentNode = (Node)toRestoreView.eContainer();
                CanonicalDBorderItemLocator locator = new CanonicalDBorderItemLocator(parentNode, 29);
                if (semanticDecorator instanceof DDiagramElement) {
                    if (new DDiagramElementQuery((DDiagramElement)semanticDecorator).isIndirectlyCollapsed()) {
                        isCollapsed = true;
                        locator.setBorderItemOffset(IBorderItemOffsets.COLLAPSE_FILTER_OFFSET);
                    } else {
                        locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                    }
                } else {
                    locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                }
                Rectangle rect = new Rectangle(locationToApply.getX(), locationToApply.getY(), layoutData.getWidth(), layoutData.getHeight());
                Point realLocation = locator.getValidLocation(rect, toRestoreView, new ArrayList<Node>(Arrays.asList(toRestoreView)));
                Point parentAbsoluteLocation = ((IGraphicalEditPart)graphicalEditPart.getParent()).getFigure().getBounds().getTopLeft().getCopy();
                FigureUtilities.translateToAbsoluteByIgnoringScrollbar((IFigure)((IGraphicalEditPart)graphicalEditPart.getParent()).getFigure(), (Point)parentAbsoluteLocation);
                locationToApply.setX(realLocation.x);
                locationToApply.setY(realLocation.y);
                locationToApply = LayoutDataHelper.INSTANCE.getTranslated(locationToApply, parentAbsoluteLocation.negate());
            } else {
                locationToApply = LayoutDataHelper.INSTANCE.getRelativeLocation(layoutData, graphicalEditPart);
                graphicalEditPart.getFigure().setLocation(new Point(locationToApply.getX(), locationToApply.getY()));
            }
            bounds.setX(locationToApply.getX());
            bounds.setY(locationToApply.getY());
            if (isCollapsed) {
                Dimension dim = new NodeQuery(toRestoreView).getCollapsedSize();
                bounds.setHeight(dim.height);
                bounds.setWidth(dim.width);
            } else {
                bounds.setHeight(layoutData.getHeight());
                bounds.setWidth(layoutData.getWidth());
            }
            toRestoreView.setLayoutConstraint((LayoutConstraint)bounds);
        }
        if (layoutData != null && applyStyle) {
            this.applySiriusStyle(semanticDecorator, (AbstractLayoutData)layoutData);
            this.applyGMFStyle((View)toRestoreView, (AbstractLayoutData)layoutData);
        }
        if (semanticDecorator instanceof DNode) {
            this.applyFormatToNodeChildren((DNode)semanticDecorator, editPartViewer, layoutData, applyLayout, applyStyle);
        } else if (semanticDecorator instanceof DNodeContainer) {
            this.applyFormatToNodeContainerChildren((DNodeContainer)semanticDecorator, editPartViewer, layoutData, applyLayout, applyStyle);
        } else if (semanticDecorator instanceof DNodeList) {
            this.applyFormatToNodeListChildren((DNodeList)semanticDecorator, editPartViewer, layoutData, applyLayout, applyStyle);
        } else {
            this.logWarnMessage(semanticDecorator);
        }
        if (semanticDecorator instanceof EdgeTarget) {
            this.applyFormatToOutgoingEdge((EdgeTarget)semanticDecorator, editPartViewer, applyLayout, applyStyle);
        }
    }

    protected void applySiriusStyle(DSemanticDecorator semanticDecorator, AbstractLayoutData layoutData) {
        Style copyOfSiriusStyle = (Style)SiriusCopierHelper.copyWithNoUidDuplication((EObject)layoutData.getSiriusStyle());
        if ((semanticDecorator instanceof DNode || semanticDecorator instanceof DNodeListElement) && copyOfSiriusStyle instanceof NodeStyle) {
            if (semanticDecorator instanceof DNode) {
                this.computeCustomFeatures((Style)((DNode)semanticDecorator).getOwnedStyle(), copyOfSiriusStyle);
                ((DNode)semanticDecorator).setOwnedStyle((NodeStyle)copyOfSiriusStyle);
            } else {
                this.computeCustomFeatures((Style)((DNodeListElement)semanticDecorator).getOwnedStyle(), copyOfSiriusStyle);
                ((DNodeListElement)semanticDecorator).setOwnedStyle((NodeStyle)copyOfSiriusStyle);
            }
        } else if (semanticDecorator instanceof DDiagramElementContainer && copyOfSiriusStyle instanceof ContainerStyle) {
            this.computeCustomFeatures((Style)((DDiagramElementContainer)semanticDecorator).getOwnedStyle(), copyOfSiriusStyle);
            ((DDiagramElementContainer)semanticDecorator).setOwnedStyle((ContainerStyle)copyOfSiriusStyle);
        } else if (semanticDecorator instanceof DEdge && copyOfSiriusStyle instanceof EdgeStyle) {
            this.computeCustomFeatures((Style)((DEdge)semanticDecorator).getOwnedStyle(), copyOfSiriusStyle);
            ((DEdge)semanticDecorator).setOwnedStyle((EdgeStyle)copyOfSiriusStyle);
        }
    }

    protected void applyGMFStyle(View newView, AbstractLayoutData layoutData) {
        if (newView != null && layoutData.getGmfView() != null) {
            ArrayList<EClass> excludedStyles = new ArrayList<EClass>();
            if (newView instanceof Edge) {
                excludedStyles.add(NotationPackage.eINSTANCE.getRoutingStyle());
            }
            new ViewRefactorHelper().copyViewAppearance(layoutData.getGmfView(), newView, excludedStyles);
        }
    }

    private void logWarnMessage(DSemanticDecorator semanticDecorator) {
        Class<?> clazz = semanticDecorator.getClass();
        boolean logWarn = true;
        Class<?>[] classArray = CLASS_EXCEPTIONS;
        int n = CLASS_EXCEPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> exceptionClass = classArray[n2];
            if (exceptionClass.isAssignableFrom(clazz)) {
                logWarn = false;
                break;
            }
            ++n2;
        }
        if (logWarn) {
            DiagramPlugin.getDefault().logWarning(MessageFormat.format(Messages.AbstractSiriusLayoutDataManager_unhandledDiagramElementKind, semanticDecorator.getClass().getName()));
        }
    }

    private void applyFormatToNodeChildren(DNode parentNode, EditPartViewer editPartViewer, NodeLayoutData layoutData, boolean applyLayout, boolean applyStyle) {
        this.applyFormatForBorderedNodes((EList<DNode>)parentNode.getOwnedBorderedNodes(), editPartViewer, layoutData, applyLayout, applyStyle);
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)parentNode);
        this.applyLabelFormat((View)gmfNode, (AbstractLayoutData)layoutData, applyLayout, applyStyle);
    }

    private void applyFormatToNodeContainerChildren(DNodeContainer container, EditPartViewer editPartViewer, NodeLayoutData layoutData, boolean applyLayout, boolean applyStyle) {
        for (DDiagramElement child : container.getOwnedDiagramElements()) {
            Node gmfNode;
            if (!(child instanceof AbstractDNode) || (gmfNode = SiriusGMFHelper.getGmfNode(child)) == null) continue;
            this.applyFormat((DSemanticDecorator)child, gmfNode, editPartViewer, layoutData, applyLayout, applyStyle);
        }
        this.applyFormatForBorderedNodes((EList<DNode>)container.getOwnedBorderedNodes(), editPartViewer, layoutData, applyLayout, applyStyle);
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)container);
        this.applyLabelFormat((View)gmfNode, (AbstractLayoutData)layoutData, applyLayout, applyStyle);
    }

    private void applyFormatForBorderedNodes(EList<DNode> borderedNodes, EditPartViewer editPartViewer, NodeLayoutData parentLayoutData, boolean applyLayout, boolean applyStyle) {
        HashMap<Node, NodeLayoutData> nodesWithLayoutDataToApply = new HashMap<Node, NodeLayoutData>();
        HashMap<Node, DNode> nodesWithCoresspondingDSemanticDecorator = new HashMap<Node, DNode>();
        for (DNode child : borderedNodes) {
            Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)child);
            if (gmfNode == null) continue;
            LayoutDataKey key = this.createKey((DSemanticDecorator)child);
            NodeLayoutData layoutData = (NodeLayoutData)this.getLayoutData(key);
            if (parentLayoutData != null && parentLayoutData == layoutData && !StringUtil.isEmpty((String)key.getId())) {
                layoutData = null;
                for (NodeLayoutData childLayoutData : parentLayoutData.getChildren()) {
                    if (!key.getId().equals(childLayoutData.getId())) continue;
                    if (layoutData == null) {
                        layoutData = childLayoutData;
                        continue;
                    }
                    layoutData = null;
                    break;
                }
            }
            if (layoutData == null) continue;
            nodesWithLayoutDataToApply.put(gmfNode, layoutData);
            nodesWithCoresspondingDSemanticDecorator.put(gmfNode, child);
        }
        Set<Node> toIgnore = nodesWithLayoutDataToApply.keySet();
        for (Map.Entry entry : nodesWithLayoutDataToApply.entrySet()) {
            Node node = (Node)entry.getKey();
            this.applyFormatForBorderedNode((DSemanticDecorator)nodesWithCoresspondingDSemanticDecorator.get(node), node, editPartViewer, (NodeLayoutData)entry.getValue(), toIgnore, applyLayout, applyStyle);
        }
    }

    private void applyFormatForBorderedNode(DSemanticDecorator semanticDecorator, Node toRestoreView, EditPartViewer editPartViewer, NodeLayoutData layoutData, Set<Node> portsNodesToIgnore, boolean applyLayout, boolean applyStyle) {
        if (applyLayout) {
            org.eclipse.sirius.diagram.layoutdata.Point locationToApply;
            Bounds bounds = NotationFactory.eINSTANCE.createBounds();
            boolean isCollapsed = false;
            if (!(toRestoreView.eContainer() instanceof Node)) {
                return;
            }
            Node parentNode = (Node)toRestoreView.eContainer();
            Object parentGraphicalEditPart = editPartViewer.getEditPartRegistry().get(parentNode);
            NodeQuery nodeQuery = new NodeQuery(toRestoreView);
            if (nodeQuery.isBorderedNode() && parentGraphicalEditPart instanceof IGraphicalEditPart) {
                locationToApply = LayoutDataHelper.INSTANCE.getAbsoluteLocation(layoutData);
                CanonicalDBorderItemLocator locator = new CanonicalDBorderItemLocator(parentNode, 29);
                if (semanticDecorator instanceof DDiagramElement) {
                    if (new DDiagramElementQuery((DDiagramElement)semanticDecorator).isIndirectlyCollapsed()) {
                        isCollapsed = true;
                        locator.setBorderItemOffset(IBorderItemOffsets.COLLAPSE_FILTER_OFFSET);
                    } else {
                        locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                    }
                } else {
                    locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                }
                Rectangle rect = new Rectangle(locationToApply.getX(), locationToApply.getY(), layoutData.getWidth(), layoutData.getHeight());
                Point realLocation = locator.getValidLocation(rect, toRestoreView, portsNodesToIgnore);
                Point parentAbsoluteLocation = GMFHelper.getAbsoluteBounds(parentNode, true).getTopLeft();
                locationToApply.setX(realLocation.x);
                locationToApply.setY(realLocation.y);
                locationToApply = LayoutDataHelper.INSTANCE.getTranslated(locationToApply, parentAbsoluteLocation.negate());
            } else {
                Object graphicalEditPart = editPartViewer.getEditPartRegistry().get(toRestoreView);
                if (graphicalEditPart instanceof IGraphicalEditPart) {
                    locationToApply = LayoutDataHelper.INSTANCE.getRelativeLocation(layoutData, (IGraphicalEditPart)graphicalEditPart);
                    ((GraphicalEditPart)graphicalEditPart).getFigure().setLocation(new Point(locationToApply.getX(), locationToApply.getY()));
                } else {
                    locationToApply = LayoutdataFactory.eINSTANCE.createPoint();
                }
            }
            bounds.setX(locationToApply.getX());
            bounds.setY(locationToApply.getY());
            if (isCollapsed) {
                Dimension dim = new NodeQuery(toRestoreView).getCollapsedSize();
                bounds.setHeight(dim.height);
                bounds.setWidth(dim.width);
            } else {
                bounds.setHeight(layoutData.getHeight());
                bounds.setWidth(layoutData.getWidth());
            }
            toRestoreView.setLayoutConstraint((LayoutConstraint)bounds);
        }
        if (applyStyle) {
            this.applySiriusStyle(semanticDecorator, (AbstractLayoutData)layoutData);
            this.applyGMFStyle((View)toRestoreView, (AbstractLayoutData)layoutData);
        }
        if (semanticDecorator instanceof DNode) {
            this.applyFormatToNodeChildren((DNode)semanticDecorator, editPartViewer, layoutData, applyLayout, applyStyle);
        } else if (semanticDecorator instanceof DNodeContainer) {
            this.applyFormatToNodeContainerChildren((DNodeContainer)semanticDecorator, editPartViewer, layoutData, applyLayout, applyStyle);
        } else if (semanticDecorator instanceof DNodeList) {
            this.applyFormatToNodeListChildren((DNodeList)semanticDecorator, editPartViewer, layoutData, applyLayout, applyStyle);
        } else {
            this.logWarnMessage(semanticDecorator);
        }
        if (semanticDecorator instanceof EdgeTarget) {
            this.applyFormatToOutgoingEdge((EdgeTarget)semanticDecorator, editPartViewer, applyLayout, applyStyle);
        }
    }

    private void applyFormatToNodeListChildren(DNodeList nodeList, EditPartViewer editPartViewer, NodeLayoutData layoutData, boolean applyLayout, boolean applyStyle) {
        this.applyFormatForBorderedNodes((EList<DNode>)nodeList.getOwnedBorderedNodes(), editPartViewer, layoutData, applyLayout, applyStyle);
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)nodeList);
        this.applyLabelFormat((View)gmfNode, (AbstractLayoutData)layoutData, applyLayout, applyStyle);
    }

    protected void addNodeChildren(DNode parentNode, NodeLayoutData parentLayoutData, IGraphicalEditPart parentEditPart, View gmfView, Collection<LayoutDataKey> discoveredKeys) {
        for (DNode child : parentNode.getOwnedBorderedNodes()) {
            this.checkDataAndAddChildLayout(parentLayoutData, (AbstractDNode)child, parentEditPart, discoveredKeys);
        }
        this.addLabelLayoutData((AbstractLayoutData)parentLayoutData, gmfView);
    }

    protected void checkDataAndAddChildLayout(NodeLayoutData parentLayoutData, AbstractDNode child, IGraphicalEditPart parentSavedEditPart, Collection<LayoutDataKey> discoveredKeys) {
        IGraphicalEditPart editPart;
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)child);
        if (gmfNode != null && (editPart = (IGraphicalEditPart)parentSavedEditPart.getRoot().getViewer().getEditPartRegistry().get(gmfNode)) != null) {
            this.addChildLayout(parentLayoutData, (DSemanticDecorator)child, gmfNode, editPart, discoveredKeys);
        }
    }

    protected void addNodeContainerChildren(DNodeContainer container, NodeLayoutData parentLayoutData, IGraphicalEditPart parentEditPart, Collection<LayoutDataKey> discoveredKeys) {
        for (DDiagramElement child : container.getOwnedDiagramElements()) {
            if (!(child instanceof AbstractDNode)) continue;
            this.checkDataAndAddChildLayout(parentLayoutData, (AbstractDNode)child, parentEditPart, discoveredKeys);
        }
        for (DDiagramElement child : container.getOwnedBorderedNodes()) {
            this.checkDataAndAddChildLayout(parentLayoutData, (AbstractDNode)child, parentEditPart, discoveredKeys);
        }
    }

    protected void addNodeListChildren(DNodeList nodeList, NodeLayoutData parentLayoutData, IGraphicalEditPart parentEditPart, Collection<LayoutDataKey> discoveredKeys) {
        for (DNode child : nodeList.getOwnedBorderedNodes()) {
            this.checkDataAndAddChildLayout(parentLayoutData, (AbstractDNode)child, parentEditPart, discoveredKeys);
        }
    }

    private void addChildLayout(DDiagram diagram, IGraphicalEditPart diagramEditPart, Collection<LayoutDataKey> discoveredKeys) {
        for (AbstractDNode child : Iterables.filter((Iterable)diagram.getOwnedDiagramElements(), AbstractDNode.class)) {
            IGraphicalEditPart editPart;
            Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)child);
            if (gmfNode == null || (editPart = (IGraphicalEditPart)diagramEditPart.getRoot().getViewer().getEditPartRegistry().get(gmfNode)) == null) continue;
            this.addChildLayout(null, (DSemanticDecorator)child, gmfNode, editPart, discoveredKeys);
        }
    }

    private void addChildLayout(NodeLayoutData parentLayoutData, DSemanticDecorator child, Node gmfNode, IGraphicalEditPart editPart, Collection<LayoutDataKey> discoveredKeys) {
        NodeLayoutData childLayoutData = LayoutDataHelper.INSTANCE.createNodeLayoutData(gmfNode, editPart, parentLayoutData);
        if (parentLayoutData != null) {
            parentLayoutData.getChildren().add((Object)childLayoutData);
        }
        LayoutDataKey childKey = this.createKey(child);
        childLayoutData.setId(childKey.getId());
        if (!discoveredKeys.contains(childKey)) {
            this.addLayoutData(childKey, (AbstractLayoutData)childLayoutData);
            discoveredKeys.add(childKey);
        } else if (parentLayoutData == null) {
            this.addLayoutData(childKey, (AbstractLayoutData)childLayoutData);
        }
        if (child instanceof DNode) {
            this.addNodeChildren((DNode)child, childLayoutData, editPart, (View)gmfNode, discoveredKeys);
        } else if (child instanceof DNodeContainer) {
            this.addNodeContainerChildren((DNodeContainer)child, childLayoutData, editPart, discoveredKeys);
        } else if (child instanceof DNodeList) {
            this.addNodeListChildren((DNodeList)child, childLayoutData, editPart, discoveredKeys);
        } else {
            this.logWarnMessage(child);
        }
        if (child instanceof EdgeTarget) {
            this.addOutgoingEdge(childLayoutData, (EdgeTarget)child, editPart.getRoot().getViewer());
        }
    }

    protected void addOutgoingEdge(NodeLayoutData parentLayoutData, EdgeTarget sourceOfEdge, EditPartViewer editPartViewer) {
        for (DEdge outgoingEdge : sourceOfEdge.getOutgoingEdges()) {
            this.addEdgeLayoutData(parentLayoutData, outgoingEdge, editPartViewer);
        }
    }

    protected void addEdgeLayoutData(NodeLayoutData parentLayoutData, DEdge edge, EditPartViewer editPartViewer) {
        Edge gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)edge);
        if (gmfEdge != null) {
            EdgeLayoutData edgeLayoutData = LayoutDataHelper.INSTANCE.createEdgeLayoutData(gmfEdge, (ConnectionEditPart)editPartViewer.getEditPartRegistry().get(gmfEdge));
            if (parentLayoutData != null) {
                parentLayoutData.getOutgoingEdges().add((Object)edgeLayoutData);
            }
            LayoutDataKey edgeKey = this.createKey((DSemanticDecorator)edge);
            edgeLayoutData.setId(edgeKey.getId());
            this.addLayoutData(edgeKey, (AbstractLayoutData)edgeLayoutData);
            this.addLabelLayoutData((AbstractLayoutData)edgeLayoutData, (View)gmfEdge);
        }
    }

    private void addLabelLayoutData(AbstractLayoutData parentLayoutData, View gmfElement) {
        Node labelNode = SiriusGMFHelper.getLabelNode(gmfElement);
        if (labelNode != null && parentLayoutData != null) {
            NodeLayoutData labelLayoutData = LayoutDataHelper.INSTANCE.createLabelLayoutData(labelNode);
            if (labelNode.getElement() instanceof DSemanticDecorator) {
                labelLayoutData.setId(this.createKey((DSemanticDecorator)labelNode.getElement()).getId());
            }
            parentLayoutData.setLabel(labelLayoutData);
        }
    }

    protected void computeCustomFeatures(Style oldStyle, Style newStyle) {
        for (EAttribute attribute : newStyle.eClass().getEAllAttributes()) {
            EAttribute attributeOfOldStyle;
            if (ViewpointPackage.Literals.CUSTOMIZABLE__CUSTOM_FEATURES.equals(attribute) || (attributeOfOldStyle = this.getCorrespondingEAttribute(attribute, oldStyle)) == null) continue;
            if (newStyle.eIsSet((EStructuralFeature)attribute)) {
                if (newStyle.eGet((EStructuralFeature)attribute).equals(oldStyle.eGet((EStructuralFeature)attributeOfOldStyle))) continue;
                newStyle.getCustomFeatures().add((Object)attributeOfOldStyle.getName());
                continue;
            }
            if (!oldStyle.eIsSet((EStructuralFeature)attributeOfOldStyle)) continue;
            newStyle.getCustomFeatures().add((Object)attributeOfOldStyle.getName());
        }
    }

    private EAttribute getCorrespondingEAttribute(EAttribute attribute, Style style) {
        EAttribute result = null;
        if (style.eClass().getFeatureID((EStructuralFeature)attribute) != -1) {
            result = attribute;
        } else {
            EStructuralFeature structuralFeature = style.eClass().getEStructuralFeature(attribute.getName());
            if (structuralFeature instanceof EAttribute) {
                result = (EAttribute)structuralFeature;
            } else if ("color".equals(attribute.getName())) {
                structuralFeature = style.eClass().getEStructuralFeature("backgroundColor");
                if (structuralFeature instanceof EAttribute) {
                    result = (EAttribute)structuralFeature;
                }
            } else if ("backgroundColor".equals(attribute.getName())) {
                structuralFeature = style.eClass().getEStructuralFeature("color");
                if (structuralFeature instanceof EAttribute) {
                    result = (EAttribute)structuralFeature;
                }
            } else if ("width".equals(attribute.getName())) {
                structuralFeature = style.eClass().getEStructuralFeature("horizontalDiameter");
                if (structuralFeature instanceof EAttribute) {
                    result = (EAttribute)structuralFeature;
                }
            } else if ("horizontalDiameter".equals(attribute.getName())) {
                structuralFeature = style.eClass().getEStructuralFeature("width");
                if (structuralFeature instanceof EAttribute) {
                    result = (EAttribute)structuralFeature;
                }
            } else if ("height".equals(attribute.getName())) {
                structuralFeature = style.eClass().getEStructuralFeature("verticalDiameter");
                if (structuralFeature instanceof EAttribute) {
                    result = (EAttribute)structuralFeature;
                }
            } else if ("verticalDiameter".equals(attribute.getName()) && (structuralFeature = style.eClass().getEStructuralFeature("height")) instanceof EAttribute) {
                result = (EAttribute)structuralFeature;
            }
        }
        return result;
    }
}

