/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.BendpointLocator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConnectionBendpointEditPolicy;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.LineMode;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.MoveEdgeGroupManager;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SetConnectionBendpointsAndLabelCommmand;
import org.eclipse.sirius.diagram.ui.internal.edit.handles.SiriusBendpointCreationInvisibleHandle;
import org.eclipse.sirius.diagram.ui.internal.edit.handles.SiriusBendpointMoveHandle;
import org.eclipse.sirius.diagram.ui.internal.edit.handles.SiriusLineSegMoveInvisibleHandle;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.InitialPointsOfRequestDataManager;

public class SiriusConnectionBendpointEditPolicy
extends ConnectionBendpointEditPolicy {
    private InitialPointsOfRequestDataManager initialPointsManager = new InitialPointsOfRequestDataManager();

    public SiriusConnectionBendpointEditPolicy() {
        super(LineMode.OBLIQUE);
    }

    public SiriusConnectionBendpointEditPolicy(LineMode orthogonalFree) {
        super(orthogonalFree);
    }

    public Command getCommand(Request request) {
        MoveEdgeGroupManager nodesGroupMoveManager = new MoveEdgeGroupManager(request);
        if (nodesGroupMoveManager.isToolActivated()) {
            return nodesGroupMoveManager.getCommand();
        }
        return super.getCommand(request);
    }

    protected List createManualHandles() {
        ArrayList<SiriusBendpointMoveHandle> list = new ArrayList<SiriusBendpointMoveHandle>();
        org.eclipse.gef.ConnectionEditPart connEP = (org.eclipse.gef.ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        int i = 1;
        while (i < points.size() - 1) {
            this.addInvisibleCreationHandle(list, connEP, i - 1);
            list.add(new SiriusBendpointMoveHandle(connEP, i, (Locator)new BendpointLocator(this.getConnection(), i)));
            ++i;
        }
        this.addInvisibleCreationHandle(list, connEP, points.size() - 2);
        return list;
    }

    protected Command getBendpointsChangedCommand(BendpointRequest request) {
        ICommand iCommand;
        PointList originalPoints = InitialPointsOfRequestDataManager.getOriginalPoints((LocationRequest)request);
        Command result = super.getBendpointsChangedCommand(request);
        if (result instanceof ICommandProxy && (iCommand = ((ICommandProxy)result).getICommand()) instanceof SetConnectionBendpointsAndLabelCommmand) {
            ((SetConnectionBendpointsAndLabelCommmand)iCommand).setLabelsToUpdate((ConnectionEditPart)this.getHost(), originalPoints);
        }
        return result;
    }

    protected Command getBendpointsChangedCommand(Connection connection, Edge edge) {
        Point ptRef1 = connection.getSourceAnchor().getReferencePoint();
        this.getConnection().translateToRelative((Translatable)ptRef1);
        Point ptRef2 = connection.getTargetAnchor().getReferencePoint();
        this.getConnection().translateToRelative((Translatable)ptRef2);
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        SetConnectionBendpointsAndLabelCommmand sbbCommand = new SetConnectionBendpointsAndLabelCommmand(editingDomain);
        sbbCommand.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)edge));
        sbbCommand.setNewPointList(connection.getPoints(), ptRef1, ptRef2);
        return new ICommandProxy((ICommand)sbbCommand);
    }

    public void showSourceFeedback(Request request) {
        MoveEdgeGroupManager nodesGroupMoveManager = new MoveEdgeGroupManager(request);
        if (nodesGroupMoveManager.isToolActivated()) {
            nodesGroupMoveManager.showGroupFeedback();
        } else {
            nodesGroupMoveManager.eraseGroupFeedback();
            super.showSourceFeedback(request);
        }
    }

    public void eraseSourceFeedback(Request request) {
        MoveEdgeGroupManager nodesGroupMoveManager = new MoveEdgeGroupManager(request);
        nodesGroupMoveManager.eraseGroupFeedback();
        super.eraseSourceFeedback(request);
    }

    protected void addInvisibleCreationHandle(List list, org.eclipse.gef.ConnectionEditPart connEP, int i) {
        if (this.getLineSegMode() != LineMode.OBLIQUE) {
            list.add(new SiriusLineSegMoveInvisibleHandle(connEP, i));
        } else {
            list.add(new SiriusBendpointCreationInvisibleHandle(connEP, i));
        }
    }

    protected void showMoveBendpointFeedback(BendpointRequest request) {
        this.initialPointsManager.storeInitialPointsInRequest((LocationRequest)request, (org.eclipse.gef.ConnectionEditPart)this.getHost());
        super.showMoveBendpointFeedback(request);
    }

    protected void showCreateBendpointFeedback(BendpointRequest request) {
        this.initialPointsManager.storeInitialPointsInRequest((LocationRequest)request, (org.eclipse.gef.ConnectionEditPart)this.getHost());
        super.showCreateBendpointFeedback(request);
    }

    protected void eraseConnectionFeedback(BendpointRequest request, boolean removeFeedbackFigure) {
        super.eraseConnectionFeedback(request, removeFeedbackFigure);
        if (removeFeedbackFigure) {
            this.initialPointsManager.eraseInitialPoints(this.getConnection());
        }
    }
}

