/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.handler;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.job.ResourceBlockingOperationJob;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.wellform.WellformScoutTypeOperation;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.ui.handlers.HandlerUtil;

public class WellformSelectedHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Set<IResource> resourcesFromSelection = S2eUiUtils.getResourcesOfSelection(selection);
        if (resourcesFromSelection.isEmpty()) {
            WellformSelectedHandler.logNoSelection();
            return null;
        }
        Set<IType> types = WellformSelectedHandler.toTypes(resourcesFromSelection);
        if (types.isEmpty()) {
            WellformSelectedHandler.logNoSelection();
            return null;
        }
        HashSet<IResource> resources = new HashSet<IResource>(types.size());
        for (IType t : types) {
            resources.add(t.getResource());
        }
        new ResourceBlockingOperationJob((IOperation)new WellformScoutTypeOperation(types, true), resources.toArray(new IResource[resources.size()])).schedule();
        return null;
    }

    private static void logNoSelection() {
        SdkLog.warning((String)"Cannot wellform classes in the selected scope because no classes are selected.", (Object[])new Object[0]);
    }

    private static Set<IType> toTypes(Set<IResource> resources) {
        HashSet<IType> result = new HashSet<IType>(resources.size());
        for (IResource r : resources) {
            IJavaElement element;
            if (r == null || !r.isAccessible() || !S2eUtils.exists((IJavaElement)(element = JavaCore.create((IResource)r)))) continue;
            if (element.getElementType() == 7) {
                result.add((IType)element);
                continue;
            }
            if (element.getElementType() != 5) continue;
            ICompilationUnit icu = (ICompilationUnit)element;
            try {
                IType[] iTypeArray = icu.getTypes();
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType t = iTypeArray[n2];
                    result.add(t);
                    ++n2;
                }
            }
            catch (CoreException e) {
                SdkLog.warning((String)"Unable to wellform types in compilation unit {}. Skipping.", (Object[])new Object[]{icu.getElementName(), e});
            }
        }
        return result;
    }
}

