/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.launch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.ptp.core.util.LaunchUtils;
import org.eclipse.ptp.etfw.IToolLaunchConfigurationConstants;
import org.eclipse.ptp.etfw.PreferenceConstants;
import org.eclipse.ptp.internal.etfw.jaxb.JAXBInitializationUtil;
import org.eclipse.ptp.internal.etfw.jaxb.data.AnalysisToolType;
import org.eclipse.ptp.internal.etfw.jaxb.data.BuildToolType;
import org.eclipse.ptp.internal.etfw.jaxb.data.EtfwToolProcessType;
import org.eclipse.ptp.internal.etfw.jaxb.data.ExecToolType;
import org.eclipse.ptp.internal.etfw.jaxb.data.ToolAppType;
import org.eclipse.ptp.internal.etfw.jaxb.data.ToolPaneType;
import org.eclipse.ptp.internal.etfw.jaxb.util.JAXBExtensionUtils;
import org.eclipse.ptp.internal.etfw.launch.Activator;
import org.eclipse.ptp.internal.etfw.launch.ETFWParentLaunchConfigurationTab;
import org.eclipse.ptp.internal.etfw.launch.LaunchImages;
import org.eclipse.ptp.internal.etfw.launch.messages.Messages;
import org.eclipse.ptp.internal.etfw.ui.ExternalToolSelectionTab;
import org.eclipse.ptp.internal.rm.jaxb.control.core.variables.RMVariableMap;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationContentsChangedListener;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.tabs.LaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.core.LaunchControllerManager;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.CommandType;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.launch.IRemoteLaunchConfigService;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PerformanceAnalysisTab
extends LaunchConfigurationTab
implements IToolLaunchConfigurationConstants,
IExecutableExtension {
    private static final String TAB_ID = "org.eclipse.ptp.internal.etfw.launch.PerformanceAnalysisTab";
    protected boolean noPTP = false;
    private EtfwToolProcessType etfwTool;
    private ETFWParentLaunchConfigurationTab launchTabParent;
    private IVariableMap vmap;
    private ILaunchConfiguration launchConfiguration = null;
    private ILaunchController controller;
    private final WidgetListener listener = new WidgetListener();
    private List<ToolPaneType> toolTabs;
    private ScrolledComposite scroller;
    private Composite topComposite;
    private Composite toolComposite;
    private Composite bottomComposite;
    private Combo toolCombo;
    private Label selectToolLbl;
    private Button buildOnlyCheck;
    private Button analyzeonlyCheck;
    private final ContentsChangedListener launchContentsChangedListener = new ContentsChangedListener();
    private ExternalToolSelectionTab saxETFWTab;

    public PerformanceAnalysisTab() {
        this(false);
    }

    public PerformanceAnalysisTab(boolean noPar) {
        this.noPTP = noPar;
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        this.setControl((Control)content);
        GridLayout layout = new GridLayout();
        content.setLayout((Layout)layout);
        this.topComposite = new Composite(content, 0);
        this.topComposite.setLayout((Layout)new GridLayout(2, false));
        this.topComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolComposite = new Composite(content, 0);
        this.toolComposite.setLayout((Layout)new GridLayout());
        this.toolComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.bottomComposite = new Composite(content, 0);
        this.bottomComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.bottomComposite.setLayout((Layout)new GridLayout(1, false));
        this.buildOnlyCheck = new Button(this.bottomComposite, 32);
        this.buildOnlyCheck.setText(Messages.PerformanceAnalysisTab_BuildInstrumentedExecutable);
        this.analyzeonlyCheck = new Button(this.bottomComposite, 32);
        this.analyzeonlyCheck.setText(Messages.PerformanceAnalysisTab_SelectExistingPerfData);
        if (this.noPTP) {
            this.buildSAXParserUI();
        } else {
            String parser = PreferenceConstants.getVersion();
            if (parser.equals("sax-parser")) {
                this.buildSAXParserUI();
            } else {
                this.buildJAXBParserUI();
            }
        }
    }

    private void buildSAXParserUI() {
        this.bottomComposite.setVisible(false);
        this.saxETFWTab = new ExternalToolSelectionTab(this.noPTP);
        this.saxETFWTab.createControl(this.toolComposite);
        this.saxETFWTab.setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
        this.toolComposite.getParent().layout();
        this.toolComposite.layout();
    }

    private void buildJAXBParserUI() {
        if (PreferenceConstants.getWorkflow() == null) {
            this.selectToolLbl = new Label(this.topComposite, 0);
            this.selectToolLbl.setText(Messages.PerformanceAnalysisTab_SelectTool);
            this.toolCombo = new Combo(this.topComposite, 8);
            this.toolCombo.setLayoutData((Object)new GridData(4, 4, true, false));
            String[] toolNames = JAXBExtensionUtils.getToolNames();
            this.toolCombo.add(Messages.PerformanceAnalysisTab_PleaseSelectWorkflow);
            String[] stringArray = toolNames;
            int n = toolNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                this.toolCombo.add(name);
                ++n2;
            }
            this.toolCombo.addSelectionListener((SelectionListener)this.listener);
        }
        this.toolComposite.getParent().layout();
        this.topComposite.layout();
        this.toolComposite.layout();
    }

    private void addAttribute(String name, String value) {
        AttributeType attr = this.vmap.get(name);
        if (attr == null) {
            attr = new AttributeType();
            attr.setName(name);
            attr.setVisible(Boolean.valueOf(true));
            attr.setReadOnly(Boolean.valueOf(true));
            this.vmap.put(name, attr);
        }
        attr.setValue((Object)value);
    }

    private void setConnectionPropertyAttributes(IRemoteConnection conn) {
        String property = conn.getProperty("os.arch");
        if (property != null) {
            this.addAttribute("os.arch", property);
        }
        if ((property = conn.getProperty("os.name")) != null) {
            this.addAttribute("os.name", property);
        }
        if ((property = conn.getProperty("os.version")) != null) {
            this.addAttribute("os.version", property);
        }
    }

    private void rebuildTab(String toolName) {
        this.clearOldWidgets();
        if (toolName.equals(Messages.PerformanceAnalysisTab_PleaseSelectWorkflow)) {
            return;
        }
        this.etfwTool = JAXBExtensionUtils.getTool((String)toolName);
        if (this.controller != null) {
            IRemoteConnection remoteConnection;
            this.vmap = new RMVariableMap();
            JAXBInitializationUtil.initializeMap((EtfwToolProcessType)this.etfwTool, (IVariableMap)this.vmap);
            IRemoteServicesManager servicesManager = Activator.getService(IRemoteServicesManager.class);
            IRemoteConnectionType connectionType = servicesManager.getConnectionType(this.controller.getRemoteServicesId());
            if (connectionType != null && (remoteConnection = connectionType.getConnection(this.controller.getConnectionName())) != null) {
                this.setConnectionPropertyAttributes(remoteConnection);
            }
            Control[] controlArray = this.toolComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            if (this.etfwTool.getControlData() != null) {
                for (CommandType command : this.etfwTool.getControlData().getInitializeCommand()) {
                    if (command == null) continue;
                    try {
                        this.controller.runCommand(command, this.vmap);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.toolTabs = this.findTabControllers();
            try {
                this.launchTabParent = new ETFWParentLaunchConfigurationTab(this.controller, this.getLaunchConfigurationDialog(), (IProgressMonitor)new NullProgressMonitor(), this.toolTabs, this.vmap);
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
            this.launchTabParent.addContentsChangedListener(this.launchContentsChangedListener);
            Composite comp = new Composite(this.toolComposite, 0);
            GridLayout layout = new GridLayout(1, true);
            comp.setLayout((Layout)layout);
            GridData gd = new GridData(768);
            comp.setLayoutData((Object)gd);
            this.scroller = new ScrolledComposite(this.toolComposite, 2816);
            GridData gridData = new GridData(4, 4, true, true);
            this.scroller.setLayoutData((Object)gridData);
            this.scroller.setExpandHorizontal(true);
            this.scroller.setExpandVertical(true);
            this.scroller.setContent(null);
            Control[] controlArray2 = this.scroller.getChildren();
            int n3 = controlArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Control child = controlArray2[n4];
                child.dispose();
                ++n4;
            }
            try {
                this.launchTabParent.createControl((Composite)this.scroller, this.controller.getControlId());
                Control dynControl = this.launchTabParent.getControl();
                this.scroller.setContent(dynControl);
                Point size = dynControl.computeSize(-1, -1);
                this.scroller.setMinSize(size);
                this.launchTabParent.initializeFrom(this.launchConfiguration);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            Composite comp = new Composite(this.toolComposite, 0);
            GridLayout layout = new GridLayout();
            comp.setLayout((Layout)layout);
            Text message = new Text(comp, 0);
            message.setText(Messages.PerformanceAnalysisTab_Please_select_a_target_configuration_first);
            message.setBackground(this.toolComposite.getBackground());
            message.setLayoutData((Object)new GridData(4, 4, false, false));
        }
    }

    private List<ToolPaneType> findTabControllers() {
        ArrayList<ToolPaneType> subTabs = new ArrayList<ToolPaneType>();
        for (Object tool : this.etfwTool.getExecToolOrAnalysisToolOrBuildTool()) {
            if (tool instanceof BuildToolType) {
                BuildToolType buildTool = (BuildToolType)tool;
                if (buildTool.getGlobal() != null) {
                    for (ToolPaneType toolPane : buildTool.getGlobal().getToolPanes()) {
                        if (toolPane.isVirtual() || toolPane.getOptionPane() == null) continue;
                        subTabs.add(toolPane);
                    }
                }
                if (buildTool.getAllCompilers() == null) continue;
                for (ToolPaneType toolPane : buildTool.getAllCompilers().getToolPanes()) {
                    if (toolPane.isVirtual() || toolPane.getOptionPane() == null) continue;
                    subTabs.add(toolPane);
                }
                continue;
            }
            if (tool instanceof ExecToolType) {
                ExecToolType execTool = (ExecToolType)tool;
                if (execTool.getGlobal() != null) {
                    for (ToolPaneType toolPane : execTool.getGlobal().getToolPanes()) {
                        if (toolPane.isVirtual() || toolPane.getOptionPane() == null) continue;
                        subTabs.add(toolPane);
                    }
                }
                for (ToolAppType toolApp : execTool.getExecUtils()) {
                    for (ToolPaneType toolPane : toolApp.getToolPanes()) {
                        if (toolPane.isVirtual() || toolPane.getOptionPane() == null) continue;
                        subTabs.add(toolPane);
                    }
                }
                continue;
            }
            if (!(tool instanceof AnalysisToolType)) continue;
            AnalysisToolType analysisTool = (AnalysisToolType)tool;
            if (analysisTool.getGlobal() != null) {
                for (ToolPaneType toolPane : analysisTool.getGlobal().getToolPanes()) {
                    if (toolPane.isVirtual() || toolPane.getOptionPane() == null) continue;
                    subTabs.add(toolPane);
                }
            }
            for (ToolAppType toolApp : analysisTool.getAnalysisCommands()) {
                for (ToolPaneType toolPane : toolApp.getToolPanes()) {
                    if (toolPane.isVirtual() || toolPane.getOptionPane() == null) continue;
                    subTabs.add(toolPane);
                }
            }
        }
        return subTabs;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.launchConfiguration = configuration;
        if (this.noPTP) {
            this.saxETFWTab.initializeFrom(configuration);
        } else {
            String rmType = LaunchUtils.getTargetConfigurationName((ILaunchConfiguration)configuration);
            IRemoteLaunchConfigService launchService = Activator.getService(IRemoteLaunchConfigService.class);
            IRemoteConnection conn = launchService.getActiveConnection(configuration);
            if (conn != null) {
                try {
                    this.controller = LaunchControllerManager.getInstance().getLaunchController(conn.getConnectionType().getId(), conn.getName(), rmType);
                    if (this.controller != null) {
                        String parser = PreferenceConstants.getVersion();
                        if (parser.equals("sax-parser")) {
                            this.saxETFWTab.initializeFrom(configuration);
                        } else if (this.toolCombo != null) {
                            String toolName = configuration.getAttribute("selected_performance_tool", "");
                            int index = 0;
                            while (index < this.toolCombo.getItemCount()) {
                                if (this.toolCombo.getItem(index).equals(toolName)) {
                                    this.toolCombo.select(index);
                                    this.toolCombo.notifyListeners(13, null);
                                    break;
                                }
                                ++index;
                            }
                            if (toolName.equals("")) {
                                this.toolCombo.select(0);
                                this.clearOldWidgets();
                            }
                        } else {
                            this.rebuildTab(PreferenceConstants.getWorkflow());
                        }
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.noPTP) {
            configuration.setAttribute("ETFW_VERSION", "sax-parser");
            this.saxETFWTab.performApply(configuration);
        } else {
            String parser = PreferenceConstants.getVersion();
            configuration.setAttribute("ETFW_VERSION", parser);
            if (parser.equals("sax-parser")) {
                this.saxETFWTab.performApply(configuration);
            } else {
                configuration.setAttribute("build_but_do_not_run_instrumented_executable", this.buildOnlyCheck.getSelection());
                configuration.setAttribute("analyze_existing_perf_data_in_specified_location_build/run_nothing", this.analyzeonlyCheck.getSelection());
                if (this.toolCombo == null) {
                    configuration.setAttribute("selected_performance_tool", PreferenceConstants.getWorkflow());
                } else if (this.toolCombo.getSelectionIndex() > 0) {
                    configuration.setAttribute("selected_performance_tool", this.toolCombo.getItem(this.toolCombo.getSelectionIndex()));
                } else {
                    return;
                }
                if (this.launchTabParent != null) {
                    try {
                        String controlid = this.launchTabParent.getJobControl().getControlId();
                        String attributeName = String.valueOf(controlid) + "." + "current_controller";
                        String oldController = configuration.getAttribute(attributeName, "");
                        this.launchTabParent.performApply(configuration);
                        configuration.setAttribute(attributeName, oldController);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void clearOldWidgets() {
        Control[] controlArray = this.toolComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
    }

    public String getName() {
        return Messages.PerformanceAnalysisTab_Tab_Name;
    }

    public String getId() {
        return TAB_ID;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        String error;
        this.setErrorMessage(null);
        if (this.toolCombo != null) {
            try {
                String toolName = configuration.getAttribute("selected_performance_tool", "");
                if (this.toolCombo.getSelectionIndex() != -1 && this.toolCombo.getItem(this.toolCombo.getSelectionIndex()).equals(toolName)) {
                    return true;
                }
            }
            catch (CoreException toolName) {
                // empty catch block
            }
            this.setErrorMessage(Messages.PerformanceAnalysisTab_NoWorkflowSelected);
            return false;
        }
        if (this.launchTabParent != null && (error = this.launchTabParent.getUpdateHandler().getFirstError()) != null) {
            this.setErrorMessage(error);
            return false;
        }
        return true;
    }

    public Image getImage() {
        return LaunchImages.getImage(LaunchImages.IMG_PERFORMANCE_TAB);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data != null) {
            Map parameters = (Map)data;
            this.noPTP = Boolean.valueOf((String)parameters.get("noPTP"));
        }
    }

    private final class ContentsChangedListener
    implements IRMLaunchConfigurationContentsChangedListener {
        private ContentsChangedListener() {
        }

        public void handleContentsChanged(IRMLaunchConfigurationDynamicTab rmDynamicTab) {
            PerformanceAnalysisTab.this.updateLaunchConfigurationDialog();
        }
    }

    protected class WidgetListener
    extends SelectionAdapter {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            int selection = PerformanceAnalysisTab.this.toolCombo.getSelectionIndex();
            if (selection != -1) {
                String toolName = PerformanceAnalysisTab.this.toolCombo.getItem(selection);
                PerformanceAnalysisTab.this.rebuildTab(toolName);
                PerformanceAnalysisTab.this.updateLaunchConfigurationDialog();
            }
        }
    }
}

