/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.AddGetterSetterOperation;
import org.eclipse.php.internal.ui.actions.CodeGenerationSettings;
import org.eclipse.php.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.php.internal.ui.dialogs.GettersSettersDialog;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.handlers.Messages;
import org.eclipse.php.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.php.ui.util.CodeGenerationUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.handlers.HandlerUtil;

public class GettersSettersHandler
extends AbstractHandler {
    private static final String DIALOG_TITLE = Messages.GettersSettersHandler_0;
    private IWorkbenchWindow fWindow;
    private boolean fSort;
    private boolean fGenerateComment;
    private boolean fFinal;
    private int fVisibility;
    private int fNumEntries;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.fWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            this.execute((IStructuredSelection)selection);
        } else if (selection instanceof ITextSelection) {
            this.execute(event, (ITextSelection)selection);
        }
        return null;
    }

    private void execute(IStructuredSelection selection) throws ExecutionException {
        Object object = selection.getFirstElement();
        if (object instanceof IModelElement) {
            IModelElement element = (IModelElement)object;
            if (element.getOpenable() instanceof ExternalSourceModule) {
                MessageDialog.openError((Shell)this.fWindow.getShell(), (String)Messages.bind((String)DIALOG_TITLE, (Object[])new String[]{Messages.GettersSettersHandler_1}), (String)Messages.GettersSettersHandler_2);
                return;
            }
            try {
                IEditorPart editor = CodeGenerationUtils.openInEditor(element, true);
                if (editor instanceof PHPStructuredEditor) {
                    this.run((ISourceModule)((PHPStructuredEditor)editor).getModelElement(), element, (TextEditor)((PHPStructuredEditor)editor));
                }
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.fWindow.getShell(), (String)Messages.bind((String)DIALOG_TITLE, (Object[])new String[]{Messages.GettersSettersHandler_1}), (String)Messages.GettersSettersHandler_2);
                throw new ExecutionException("Editor open Error", (Throwable)e);
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
        }
    }

    private void execute(ExecutionEvent event, ITextSelection selection) throws ExecutionException {
        PHPStructuredEditor editor = CodeGenerationUtils.getPHPEditor(event);
        if (editor == null) {
            return;
        }
        IModelElement source = editor.getModelElement();
        if (!(source instanceof ISourceModule) || source instanceof ExternalSourceModule) {
            MessageDialog.openError((Shell)this.fWindow.getShell(), (String)Messages.bind((String)DIALOG_TITLE, (Object[])new String[]{Messages.GettersSettersHandler_1}), (String)Messages.GettersSettersHandler_2);
            return;
        }
        IModelElement element = CodeGenerationUtils.getCurrentModelElement(source, editor, selection);
        if (element == null) {
            element = CodeGenerationUtils.getCurrentModelElement(event);
        }
        try {
            this.run((ISourceModule)source, element, (TextEditor)editor);
        }
        catch (ModelException e) {
            PHPUiPlugin.log(e);
        }
    }

    private void run(ISourceModule source, IModelElement element, TextEditor editor) throws ModelException {
        IField[] getterSetterFields;
        IField[] setterFields;
        IField[] getterFields;
        IType type = CodeGenerationUtils.getType(element);
        if (type == null) {
            MessageDialog.openError((Shell)this.fWindow.getShell(), (String)Messages.bind((String)DIALOG_TITLE, (Object[])new String[]{Messages.GettersSettersHandler_1}), (String)Messages.GettersSettersHandler_2);
            return;
        }
        int flags = type.getFlags();
        if (PHPFlags.isInterface((int)flags)) {
            MessageDialog.openInformation((Shell)this.fWindow.getShell(), (String)Messages.bind((String)DIALOG_TITLE, (Object[])new String[]{Messages.GettersSettersHandler_1}), (String)Messages.GettersSettersHandler_4);
            return;
        }
        this.resetNumEntries();
        Map<IField, GettersSettersDialog.GetterSetterEntry[]> entries = this.createGetterSetterMapping(type);
        if (entries.isEmpty()) {
            MessageDialog.openInformation((Shell)this.fWindow.getShell(), (String)Messages.bind((String)DIALOG_TITLE, (Object[])new String[]{Messages.GettersSettersHandler_1}), (String)Messages.GettersSettersHandler_5);
            return;
        }
        GettersSettersDialog dialog = new GettersSettersDialog(this.fWindow.getShell(), (ILabelProvider)new GettersSettersDialog.GetterSetterLabelProvider(), new GettersSettersDialog.GettersSettersContentProvider(entries), type, editor);
        dialog.setTitle(Messages.bind((String)DIALOG_TITLE, (Object)type.getElementName()));
        String message = Messages.GettersSettersHandler_9;
        dialog.setMessage(message);
        dialog.setValidator(GettersSettersHandler.createValidator(this.fNumEntries));
        dialog.setProject(source.getScriptProject().getProject());
        dialog.setContainerMode(true);
        dialog.setSize(60, 18);
        dialog.setInput(type);
        if (element instanceof IField) {
            dialog.setInitialSelections(new Object[]{element});
            dialog.setExpandedElements(new Object[]{element});
        }
        LinkedHashSet<IField> keySet = new LinkedHashSet<IField>(entries.keySet());
        int dialogResult = dialog.open();
        if (dialogResult != 0) {
            return;
        }
        Object[] result = dialog.getResult();
        if (result == null) {
            return;
        }
        this.fSort = dialog.getSortOrder();
        this.fFinal = dialog.isFinal();
        this.fVisibility = dialog.getVisibilityModifier();
        this.fGenerateComment = dialog.getGenerateComment();
        if (this.fSort) {
            getterFields = GettersSettersHandler.getGetterFields(result, keySet);
            setterFields = GettersSettersHandler.getSetterFields(result, keySet);
            getterSetterFields = new IField[]{};
        } else {
            getterFields = GettersSettersHandler.getGetterOnlyFields(result, keySet);
            setterFields = GettersSettersHandler.getSetterOnlyFields(result, keySet);
            getterSetterFields = GettersSettersHandler.getGetterSetterFields(result, keySet);
        }
        IProject project = source.getScriptProject().getProject();
        Program program = null;
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        program = CodeGenerationUtils.getASTRoot(source, document, project);
        IRewriteTarget target = (IRewriteTarget)editor.getAdapter(IRewriteTarget.class);
        if (target != null) {
            target.setRedraw(false);
            target.beginCompoundChange();
        }
        try {
            if (program != null) {
                this.generate(type, getterFields, setterFields, getterSetterFields, program, document, dialog.getElementPosition());
            }
        }
        finally {
            if (target != null) {
                target.setRedraw(true);
                target.endCompoundChange();
            }
        }
    }

    private void resetNumEntries() {
        this.fNumEntries = 0;
    }

    private void incNumEntries() {
        ++this.fNumEntries;
    }

    private void generate(IType type, IField[] getterFields, IField[] setterFields, IField[] getterSetterFields, Program program, IDocument document, IMethod elementPosition) {
        try {
            CodeGenerationSettings settings = new CodeGenerationSettings();
            settings.createComments = this.fGenerateComment;
            AddGetterSetterOperation op = new AddGetterSetterOperation(type, getterFields, setterFields, getterSetterFields, program, document, elementPosition, settings, true);
            this.setOperationStatusFields(op);
            Object context = PHPUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            if (context == null) {
                context = new BusyIndicatorRunnableContext();
            }
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getSchedulingRule()), op.getSchedulingRule());
        }
        catch (InvocationTargetException e) {
            String message = Messages.GettersSettersHandler_6;
            MessageDialog.openError((Shell)this.fWindow.getShell(), (String)Messages.bind((String)DIALOG_TITLE, (Object[])new String[]{Messages.GettersSettersHandler_1}), (String)message);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void setOperationStatusFields(AddGetterSetterOperation op) {
        int flags = this.fVisibility;
        if (this.fFinal) {
            flags |= 4;
        }
        op.setSort(this.fSort);
        op.setVisibility(flags);
    }

    private static IField[] getSetterFields(Object[] result, Set<IField> set) {
        List<IField> list = new ArrayList<IField>();
        Object each = null;
        GettersSettersDialog.GetterSetterEntry entry = null;
        int i = 0;
        while (i < result.length) {
            each = result[i];
            if (each instanceof GettersSettersDialog.GetterSetterEntry) {
                entry = (GettersSettersDialog.GetterSetterEntry)each;
                if (!entry.isGetter) {
                    list.add(entry.field);
                }
            }
            ++i;
        }
        list = GettersSettersHandler.reorderFields(list, set);
        return list.toArray(new IField[list.size()]);
    }

    private static IField[] getGetterFields(Object[] result, Set<IField> set) {
        List<IField> list = new ArrayList<IField>();
        Object each = null;
        GettersSettersDialog.GetterSetterEntry entry = null;
        int i = 0;
        while (i < result.length) {
            each = result[i];
            if (each instanceof GettersSettersDialog.GetterSetterEntry) {
                entry = (GettersSettersDialog.GetterSetterEntry)each;
                if (entry.isGetter) {
                    list.add(entry.field);
                }
            }
            ++i;
        }
        list = GettersSettersHandler.reorderFields(list, set);
        return list.toArray(new IField[list.size()]);
    }

    private static IField[] getGetterOnlyFields(Object[] result, Set<IField> set) {
        List<IField> list = new ArrayList<IField>(0);
        Object each = null;
        GettersSettersDialog.GetterSetterEntry entry = null;
        boolean getterSet = false;
        int i = 0;
        while (i < result.length) {
            each = result[i];
            if (each instanceof GettersSettersDialog.GetterSetterEntry) {
                entry = (GettersSettersDialog.GetterSetterEntry)each;
                if (entry.isGetter) {
                    list.add(entry.field);
                    getterSet = true;
                }
                if (!entry.isGetter && getterSet) {
                    list.remove(entry.field);
                    getterSet = false;
                }
            } else {
                getterSet = false;
            }
            ++i;
        }
        list = GettersSettersHandler.reorderFields(list, set);
        return list.toArray(new IField[list.size()]);
    }

    private static IField[] getSetterOnlyFields(Object[] result, Set<IField> set) {
        List<IField> list = new ArrayList<IField>(0);
        Object each = null;
        GettersSettersDialog.GetterSetterEntry entry = null;
        boolean getterSet = false;
        int i = 0;
        while (i < result.length) {
            each = result[i];
            if (each instanceof GettersSettersDialog.GetterSetterEntry) {
                entry = (GettersSettersDialog.GetterSetterEntry)each;
                if (entry.isGetter) {
                    getterSet = true;
                }
                if (!entry.isGetter && !getterSet) {
                    list.add(entry.field);
                    getterSet = false;
                }
            } else {
                getterSet = false;
            }
            ++i;
        }
        list = GettersSettersHandler.reorderFields(list, set);
        return list.toArray(new IField[list.size()]);
    }

    private static IField[] getGetterSetterFields(Object[] result, Set<IField> set) {
        List<IField> list = new ArrayList<IField>();
        Object each = null;
        GettersSettersDialog.GetterSetterEntry entry = null;
        boolean getterSet = false;
        int i = 0;
        while (i < result.length) {
            each = result[i];
            if (each instanceof GettersSettersDialog.GetterSetterEntry) {
                entry = (GettersSettersDialog.GetterSetterEntry)each;
                if (entry.isGetter) {
                    getterSet = true;
                }
                if (!entry.isGetter && getterSet) {
                    list.add(entry.field);
                    getterSet = false;
                }
            } else {
                getterSet = false;
            }
            ++i;
        }
        list = GettersSettersHandler.reorderFields(list, set);
        return list.toArray(new IField[list.size()]);
    }

    private static List<IField> reorderFields(List<IField> collection, Set<IField> set) {
        ArrayList<IField> list = new ArrayList<IField>(collection.size());
        for (IField field : set) {
            if (!collection.contains(field)) continue;
            list.add(field);
        }
        return list;
    }

    private Map<IField, GettersSettersDialog.GetterSetterEntry[]> createGetterSetterMapping(IType type) throws ModelException {
        IField[] fields = type.getFields();
        LinkedHashMap<IField, GettersSettersDialog.GetterSetterEntry[]> result = new LinkedHashMap<IField, GettersSettersDialog.GetterSetterEntry[]>();
        IField[] iFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            int flags = field.getFlags();
            if (!PHPFlags.isConstant((int)flags)) {
                ArrayList<GettersSettersDialog.GetterSetterEntry> l = new ArrayList<GettersSettersDialog.GetterSetterEntry>(2);
                if (CodeGenerationUtils.getGetter(field) == null) {
                    l.add(new GettersSettersDialog.GetterSetterEntry(field, true, Flags.isFinal((int)flags), PHPFlags.isConstant((int)flags)));
                    this.incNumEntries();
                }
                if (CodeGenerationUtils.getSetter(field) == null) {
                    l.add(new GettersSettersDialog.GetterSetterEntry(field, false, Flags.isFinal((int)flags), PHPFlags.isConstant((int)flags)));
                    this.incNumEntries();
                }
                if (!l.isEmpty()) {
                    result.put(field, l.toArray(new GettersSettersDialog.GetterSetterEntry[l.size()]));
                }
            }
            ++n2;
        }
        return result;
    }

    private static ISelectionStatusValidator createValidator(int entries) {
        return new GettersSettersDialog.GettersSettersSelectionStatusValidator(entries);
    }
}

