/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.selectionactions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.jface.action.Action;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.selectionactions.Messages;
import org.eclipse.php.internal.ui.editor.selectionactions.SelectionHistory;
import org.eclipse.ui.texteditor.IUpdate;

public class StructureSelectHistoryAction
extends Action
implements IUpdate {
    private PHPStructuredEditor fEditor;
    private SelectionHistory fHistory;

    public StructureSelectHistoryAction(PHPStructuredEditor editor, SelectionHistory history) {
        super(Messages.StructureSelectHistoryAction_3);
        this.setToolTipText(Messages.StructureSelectHistoryAction_4);
        this.setDescription(Messages.StructureSelectHistoryAction_5);
        Assert.isNotNull((Object)history);
        Assert.isNotNull((Object)((Object)editor));
        this.fHistory = history;
        this.fEditor = editor;
        this.update();
    }

    public void update() {
        this.setEnabled(!this.fHistory.isEmpty());
    }

    public void run() {
        ISourceRange old = this.fHistory.getLast();
        if (old != null) {
            try {
                this.fHistory.ignoreSelectionChanges();
                this.fEditor.selectAndReveal(old.getOffset(), old.getLength());
            }
            finally {
                this.fHistory.listenToSelectionChanges();
            }
        }
    }
}

