/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.providers;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.uml.tools.helper.IProfileApplicationDelegate;
import org.eclipse.papyrus.uml.tools.helper.ProfileApplicationDelegateRegistry;
import org.eclipse.papyrus.uml.tools.utils.ProfileUtil;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;

public class ProfileApplicationContentProvider
extends AbstractStaticContentProvider
implements ITreeContentProvider {
    protected Package rootPackage = null;

    public ProfileApplicationContentProvider(Package rootPackage) {
        this.rootPackage = rootPackage;
    }

    public Object[] getElements() {
        return new Package[]{this.rootPackage};
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = null;
        if (parentElement instanceof ProfileApplication) {
            children = new Object[]{};
        } else if (parentElement instanceof Package) {
            Package parentPackage = (Package)parentElement;
            LinkedList<ProfileApplication> childrenList = new LinkedList<ProfileApplication>();
            for (ProfileApplication profileApplication : this.getDelegate(parentPackage).getProfileApplications(parentPackage)) {
                if (profileApplication == null || !ProfileUtil.isDirty((Package)parentPackage, (Profile)profileApplication.getAppliedProfile())) continue;
                childrenList.add(profileApplication);
            }
            childrenList.addAll((Collection<ProfileApplication>)parentPackage.getNestedPackages());
            children = childrenList.toArray();
        } else {
            children = new Object[]{};
        }
        return children;
    }

    protected IProfileApplicationDelegate getDelegate(Package package_) {
        return ProfileApplicationDelegateRegistry.INSTANCE.getDelegate(package_);
    }

    public Object getParent(Object element) {
        Package parent = null;
        if (element instanceof Package) {
            parent = ((Package)element).getNestingPackage();
        } else if (element instanceof ProfileApplication) {
            parent = ((ProfileApplication)element).getApplyingPackage();
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }
}

