/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.uml.diagram.component.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.component.providers.ElementInitializers;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;

public class InterfaceRealizationCreateCommand
extends EditElementCommand {
    protected final EObject source;
    protected final EObject target;
    protected Package container;

    public InterfaceRealizationCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.source = source;
        this.target = target;
        this.container = this.deduceContainer(source, target);
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof NamedElement)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof Interface)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canCreateInterfaceRealization_Edge(this.getContainer(), this.getSource(), this.getTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        InterfaceRealization newElement = UMLFactory.eINSTANCE.createInterfaceRealization();
        this.getContainer().getPackagedElements().add((Object)newElement);
        newElement.getClients().add((Object)this.getSource());
        newElement.setContract(this.getTarget());
        ElementInitializers.getInstance().init_InterfaceRealization_Edge(newElement);
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    protected void doConfigure(InterfaceRealization newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        configureRequest.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        configureRequest.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected NamedElement getSource() {
        return (NamedElement)this.source;
    }

    protected Interface getTarget() {
        return (Interface)this.target;
    }

    public Package getContainer() {
        return this.container;
    }

    protected Package deduceContainer(EObject source, EObject target) {
        EObject element = source;
        while (element != null) {
            if (element instanceof Package) {
                return (Package)element;
            }
            element = element.eContainer();
        }
        return null;
    }
}

