/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.architecture;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.infra.architecture.Activator;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;

public class ArchitectureDomainMerger
implements Cloneable {
    private ResourceSet resourceSet;
    private Collection<URI> extensionModels;
    private Collection<URI> preferenceModels;
    private Collection<ArchitectureDomain> dynamicDomains;
    private Map<String, MergedArchitectureDomain> mergedDomains;
    private Map<String, Object> idCache;

    ArchitectureDomainMerger() {
    }

    Collection<URI> getExtensionModels() {
        return this.extensionModels;
    }

    public void setExtensionModels(Collection<URI> models) {
        this.extensionModels = models;
        this.reset();
    }

    Collection<URI> getPrefereceModels() {
        return this.preferenceModels;
    }

    public void setPreferenceModels(Collection<URI> models) {
        this.preferenceModels = models;
        this.reset();
    }

    Collection<ArchitectureDomain> getDynamicDomains() {
        return this.dynamicDomains;
    }

    public void setDynamicDomains(Collection<ArchitectureDomain> domains) {
        this.dynamicDomains = domains;
        this.reset();
    }

    public Collection<MergedArchitectureDomain> getDomains() {
        if (this.mergedDomains == null) {
            this.init();
        }
        return this.mergedDomains.values();
    }

    public MergedArchitectureContext getArchitectureContextById(String id) {
        Object found;
        if (this.mergedDomains == null) {
            this.init();
        }
        return (found = this.idCache.get(id)) instanceof MergedArchitectureContext ? (MergedArchitectureContext)found : null;
    }

    public MergedArchitectureViewpoint getArchitectureViewpointById(String id) {
        Object found;
        if (this.mergedDomains == null) {
            this.init();
        }
        return (found = this.idCache.get(id)) instanceof MergedArchitectureViewpoint ? (MergedArchitectureViewpoint)found : null;
    }

    public RepresentationKind getRepresentationKindById(String id) {
        Object found;
        if (this.mergedDomains == null) {
            this.init();
        }
        return (found = this.idCache.get(id)) instanceof RepresentationKind ? (RepresentationKind)found : null;
    }

    public ArchitectureDomainMerger clone() {
        ArchitectureDomainMerger clone = new ArchitectureDomainMerger();
        clone.setExtensionModels(this.extensionModels);
        clone.setPreferenceModels(this.preferenceModels);
        return clone;
    }

    private void reset() {
        this.resourceSet = null;
        this.mergedDomains = null;
        this.idCache = null;
    }

    void init() {
        ArchitectureDomain domain;
        this.resourceSet = new ResourceSetImpl();
        this.mergedDomains = new HashMap<String, MergedArchitectureDomain>();
        if (this.extensionModels != null) {
            for (URI model : this.extensionModels) {
                domain = this.loadDomain(this.resourceSet.createResource(model));
                if (domain == null) continue;
                this.merge(domain);
            }
        }
        if (this.preferenceModels != null) {
            for (URI model : this.preferenceModels) {
                domain = this.loadDomain(this.resourceSet.createResource(model));
                if (domain == null) continue;
                this.merge(domain);
            }
        }
        if (this.dynamicDomains != null) {
            for (ArchitectureDomain domain2 : this.dynamicDomains) {
                if (domain2 == null) continue;
                this.merge(domain2);
            }
        }
        this.buildCache();
    }

    private ArchitectureDomain loadDomain(Resource resource) {
        try {
            resource.load(null);
        }
        catch (IOException e) {
            return null;
        }
        EObject content = (EObject)resource.getContents().get(0);
        if (content instanceof ArchitectureDomain) {
            return (ArchitectureDomain)content;
        }
        Activator.log.warn("file " + resource.getURI() + " is not an architecture model");
        return null;
    }

    private void merge(ArchitectureDomain domain) {
        MergedArchitectureDomain merged = this.mergedDomains.get(domain.getName());
        if (merged == null) {
            merged = new MergedArchitectureDomain();
            this.mergedDomains.put(domain.getName(), merged);
        }
        merged.merge(domain);
    }

    private void buildCache() {
        this.idCache = new HashMap<String, Object>();
        for (MergedArchitectureDomain domain : this.mergedDomains.values()) {
            for (MergedArchitectureContext context : domain.getContexts()) {
                this.idCache.put(context.getId(), context);
                for (MergedArchitectureViewpoint viewpoint : context.getViewpoints()) {
                    this.idCache.put(viewpoint.getId(), viewpoint);
                }
                if (!(context instanceof MergedArchitectureDescriptionLanguage)) continue;
                MergedArchitectureDescriptionLanguage language = (MergedArchitectureDescriptionLanguage)context;
                for (RepresentationKind representationKind : language.getRepresentationKinds()) {
                    this.idCache.put(representationKind.getId(), representationKind);
                }
            }
        }
    }
}

