/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.builder;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.OCL;

public class ValidationEntry {
    protected final @NonNull IFile file;
    protected final @NonNull String markerId;
    private @Nullable List< @NonNull MultiValidationJob.MarkerData> markerDatas = null;
    private @Nullable Throwable throwable = null;

    public ValidationEntry(@NonNull IFile file, @NonNull String markerId) {
        this.file = file;
        this.markerId = markerId;
    }

    public @NonNull OCL createOCL() {
        ASResourceFactoryRegistry registry = ASResourceFactoryRegistry.INSTANCE;
        String fileExtension = this.file.getFileExtension();
        ASResourceFactory asResourceFactory = registry.getASResourceFactoryForExtension(fileExtension);
        if (asResourceFactory instanceof ASResourceFactory.ASResourceFactoryExtension2) {
            EnvironmentFactoryInternal environmentFactory = ((ASResourceFactory.ASResourceFactoryExtension2)asResourceFactory).createEnvironmentFactory(ProjectManager.CLASS_PATH);
            return environmentFactory.createOCL();
        }
        return OCL.newInstance((ProjectManager)ProjectManager.CLASS_PATH);
    }

    public void deleteMarkers() throws CoreException {
        this.file.deleteMarkers(this.markerId, true, 0);
    }

    public @NonNull IFile getFile() {
        return this.file;
    }

    public @Nullable List< @NonNull MultiValidationJob.MarkerData> getMarkerDatas() {
        return this.markerDatas;
    }

    public @NonNull String getMarkerId() {
        return this.markerId;
    }

    public @Nullable Throwable getThrowable() {
        return this.throwable;
    }

    public void setMarkerDatas(@NonNull List< @NonNull MultiValidationJob.MarkerData> markerDatas) {
        this.markerDatas = markerDatas;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public String toString() {
        return this.file + " => " + this.markerId;
    }
}

