/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.mylyn.reviews.core.model.InternalReviewStatus;

public enum ReviewStatus implements InternalReviewStatus
{
    NEW(0, "New", "NEW"),
    SUBMITTED(1, "Submitted", "SUBMITTED"),
    MERGED(2, "Merged", "MERGED"),
    ABANDONED(3, "Abandoned", "ABANDONED"),
    DRAFT(4, "Draft", "DRAFT");

    public static final int NEW_VALUE = 0;
    public static final int SUBMITTED_VALUE = 1;
    public static final int MERGED_VALUE = 2;
    public static final int ABANDONED_VALUE = 3;
    public static final int DRAFT_VALUE = 4;
    private static final ReviewStatus[] VALUES_ARRAY;
    public static final List<ReviewStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ReviewStatus[]{NEW, SUBMITTED, MERGED, ABANDONED, DRAFT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ReviewStatus get(String literal) {
        ReviewStatus[] reviewStatusArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            ReviewStatus result = reviewStatusArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static ReviewStatus getByName(String name) {
        ReviewStatus[] reviewStatusArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            ReviewStatus result = reviewStatusArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static ReviewStatus get(int value) {
        switch (value) {
            case 0: {
                return NEW;
            }
            case 1: {
                return SUBMITTED;
            }
            case 2: {
                return MERGED;
            }
            case 3: {
                return ABANDONED;
            }
            case 4: {
                return DRAFT;
            }
        }
        return null;
    }

    private ReviewStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

