/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.linux;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileProperties;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.AbstractDataAdapter;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.OprofileSAXHandler;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.checkevent.CheckEventAdapter;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.info.InfoAdapter;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.modeldata.ModelDataAdapter;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.sessions.SessionManager;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class OpxmlRunner {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run(String[] args, Object callData) {
        XMLReader reader = null;
        OprofileSAXHandler handler = OprofileSAXHandler.getInstance(callData);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            reader = factory.newSAXParser().getXMLReader();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        InfoAdapter.checkTimerSupport();
        try {
            File file = this.constructFile(args);
            if (args[0].equals("sessions")) {
                SessionManager sessManNew = new SessionManager(SessionManager.SESSION_LOCATION);
                this.populateWithCurrentSession(sessManNew);
                sessManNew.write();
                FileReader fr = new FileReader(file);
                reader.parse(new InputSource(fr));
                return true;
            }
            if (!file.exists()) {
                if (args[0].equals("check-events")) {
                    CheckEventAdapter aea = new CheckEventAdapter(args[1], args[2], args[3]);
                    ((AbstractDataAdapter)aea).process();
                    BufferedReader bi = new BufferedReader(new InputStreamReader(aea.getInputStream()));
                    reader.parse(new InputSource(bi));
                    return true;
                }
                if (args[0].equals("info")) {
                    InfoAdapter aea = new InfoAdapter();
                    ((AbstractDataAdapter)aea).process();
                    BufferedReader bi = new BufferedReader(new InputStreamReader(aea.getInputStream()));
                    reader.parse(new InputSource(bi));
                    return true;
                }
                if (!args[0].equals("model-data")) throw new RuntimeException("Unrecognized argument encountered");
                if (!this.handleModelData(args)) {
                    return false;
                }
                FileReader fr = new FileReader(file);
                reader.parse(new InputSource(fr));
                return true;
            }
            if (args.length == 3 && args[0].equals("model-data") && args[2].equals("current") && !this.handleModelData(args)) {
                return false;
            }
            FileReader fr = new FileReader(file);
            reader.parse(new InputSource(fr));
            return true;
        }
        catch (SAXException e) {
            e.printStackTrace();
            OprofileCorePlugin.showErrorDialog("opxmlSAXParseException", null);
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            OprofileCorePlugin.showErrorDialog("opxmlParse", null);
        }
        return false;
    }

    private File saveOpxmlToFile(BufferedReader bi, String[] args) {
        String fileName = "";
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            fileName = String.valueOf(fileName) + arg;
            ++n2;
        }
        File file = new File(String.valueOf(SessionManager.OPXML_PREFIX) + fileName);
        try {
            file.createNewFile();
            Throwable throwable = null;
            stringArray = null;
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
                String line;
                while ((line = bi.readLine()) != null) {
                    bw.write(String.valueOf(line) + "\n");
                }
                bi.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    private File constructFile(String[] args) {
        String fileName = "";
        int i = 0;
        while (i < args.length) {
            fileName = String.valueOf(fileName) + args[i];
            ++i;
        }
        return new File(String.valueOf(SessionManager.OPXML_PREFIX) + fileName);
    }

    private boolean handleModelData(String[] args) {
        String[] a;
        InputStream is;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("-Xdg");
        if (!InfoAdapter.hasTimerSupport()) {
            cmd.add("event:" + args[1]);
        }
        if ((is = this.runOpReport(cmd.toArray(a = new String[0]))) == null) {
            return false;
        }
        ModelDataAdapter mda = new ModelDataAdapter(is);
        if (!mda.isParseable()) {
            return false;
        }
        mda.process();
        BufferedReader bi = new BufferedReader(new InputStreamReader(mda.getInputStream()));
        this.saveOpxmlToFile(bi, args);
        return true;
    }

    private void populateWithCurrentSession(SessionManager session) {
        session.removeAllCurrentSessions();
        String[] eventName = this.getEventNames();
        if (eventName != null) {
            int i = 0;
            while (i < eventName.length) {
                session.addSession("current", eventName[i]);
                ++i;
            }
        }
    }

    private String[] getEventNames() {
        String[] ret = null;
        try {
            String[] cmd = new String[]{"-X", "-d"};
            InputStream is = this.runOpReport(cmd);
            if (is != null) {
                String eventOrTimerName;
                String eventOrTimerSetup;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(is);
                Element root = (Element)doc.getElementsByTagName("profile").item(0);
                if (!InfoAdapter.hasTimerSupport()) {
                    eventOrTimerSetup = "eventsetup";
                    eventOrTimerName = "eventname";
                } else {
                    eventOrTimerSetup = "timersetup";
                    eventOrTimerName = "rtcinterrupts";
                }
                Element setupTag = (Element)root.getElementsByTagName("setup").item(0);
                NodeList eventSetupList = setupTag.getElementsByTagName(eventOrTimerSetup);
                ret = new String[eventSetupList.getLength()];
                int i = 0;
                while (i < eventSetupList.getLength()) {
                    Element elm = (Element)eventSetupList.item(i);
                    ret[i] = elm.getAttribute(eventOrTimerName);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            OprofileCorePlugin.showErrorDialog("opxmlParse", null);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
            OprofileCorePlugin.showErrorDialog("opxmlSAXParseException", null);
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream runOpReport(String[] args) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("opreport");
        if (Oprofile.OprofileProject.getProfilingBinary().equals("operf")) {
            String workingDir = "";
            RemoteProxyManager proxy = RemoteProxyManager.getInstance();
            try {
                IRemoteFileProxy rfile = proxy.getFileProxy(Oprofile.OprofileProject.getProject());
                workingDir = rfile.getWorkingDir().getPath();
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
            cmd.add(1, "--session-dir=" + workingDir + '/' + "oprofile_data");
        }
        Collections.addAll(cmd, args);
        Process p = null;
        try {
            StringBuilder output;
            block25: {
                p = RuntimeProcessFactory.getFactory().exec(cmd.toArray(new String[0]), Oprofile.OprofileProject.getProject());
                output = new StringBuilder();
                StringBuilder errorOutput = new StringBuilder();
                String s = null;
                try {
                    Throwable throwable = null;
                    Object var8_13 = null;
                    try {
                        BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        try {
                            try (BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));){
                                while ((s = stdInput.readLine()) != null) {
                                    output.append(String.valueOf(s) + System.getProperty("line.separator"));
                                }
                                while (true) {
                                    if ((s = stdError.readLine()) == null) {
                                        if (!errorOutput.toString().trim().equals("")) {
                                            String dialogTitle = NLS.bind((String)OprofileProperties.getString("process.log.stderr.dialog.title"), (Object)"opreport");
                                            String errorMessage = NLS.bind((String)OprofileProperties.getString("process.log.stderr"), (Object)"opreport", (Object)errorOutput.toString().trim());
                                            Display.getDefault().asyncExec(() -> {
                                                int n = ErrorDialog.openError(null, (String)dialogTitle, (String)errorMessage, (IStatus)new Status(4, OprofileCorePlugin.getId(), 0, errorMessage, null));
                                            });
                                        }
                                        break;
                                    }
                                    errorOutput.append(String.valueOf(s) + System.getProperty("line.separator"));
                                }
                            }
                            if (stdInput == null) break block25;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (stdInput == null) throw throwable;
                            stdInput.close();
                            throw throwable;
                        }
                        stdInput.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (p.waitFor() != 0) return null;
            return new ByteArrayInputStream(output.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e1) {
            e1.printStackTrace();
            OprofileCorePlugin.showErrorDialog("opxmlParse", null);
            return null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }
}

