/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui.internal.editor.text;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.ldt.ui.internal.editor.text.LuaWordFinder;

public class LuaDoubleClickSelector
implements ITextDoubleClickStrategy {
    private static char[] fgBrackets = new char[]{'{', '}', '(', ')', '[', ']'};
    private DefaultCharacterPairMatcher fPairMatcher = new DefaultCharacterPairMatcher(fgBrackets);

    public void doubleClicked(ITextViewer textViewer) {
        int offset = textViewer.getSelectedRange().x;
        if (offset < 0) {
            return;
        }
        IDocument document = textViewer.getDocument();
        IRegion region = this.fPairMatcher.match(document, offset);
        if (region != null && region.getLength() >= 2) {
            textViewer.setSelectedRange(region.getOffset() + 1, region.getLength() - 2);
        } else {
            region = LuaWordFinder.findWord(document, offset);
            if (region != null && region.getLength() > 0) {
                textViewer.setSelectedRange(region.getOffset(), region.getLength());
            }
        }
    }
}

